/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.PatternMatcher;
import com.atlassian.crowd.acceptance.tests.directory.ImmutableUser;
import com.atlassian.crowd.acceptance.tests.directory.MockDirectoryManager;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.acceptance.tests.directory.ModelAssertions;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelperImpl;
import com.atlassian.crowd.directory.loader.CacheableDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.LDAPDirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapShaPasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/dbCachingRemoteDirectoryApplicationContext.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-config.xml"})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_CLASS)
public class DbCachingLdapTest {
    private static final String LDAP_USER_NAME = "user1";
    private static final String LDAP_USER2_NAME = "user2";
    private static final String LDAP_USER3_NAME = "user3";
    private static final String LDAP_GROUP_NAME = "ldap-group";
    private static final String LDAP_GROUP2_NAME = "ldap-group2";
    private static final String LDAP_GROUP3_NAME = "ldap-group3";
    private static final String LOCAL_GROUP_NAME = "local-group";
    private static final String LOCAL_GROUP2_NAME = "local-group2";
    private static final String EXTERNAL_ID_PATTERN = "(\\w){8}-(\\w){4}-(\\w){4}-(\\w){4}-(\\w){12}";
    private RemoteDirectory remoteDirectory;
    private RemoteDirectory ldapDirectory;
    private User ldapUser;
    private Group ldapGroup;
    private Session session;
    private DirectoryImpl directory;
    @Inject
    private DataSource dataSource;
    @Inject
    private PasswordEncoderFactory passwordEncoderFactory;
    @Inject
    private SessionFactory sessionFactory;
    @Inject
    private DirectoryDao directoryDao;
    @Inject
    private MockDirectoryManager directoryManager;
    @Inject
    private LDAPPropertiesHelperImpl ldapPropertiesHelperImpl;
    @Inject
    private CacheableDirectoryInstanceLoader directoryInstanceLoader;
    @Inject
    private LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader;
    @Inject
    private InternalDirectoryInstanceLoader internalDirectoryInstanceLoader;

    @Before
    public void setUp() throws Exception {
        this.passwordEncoderFactory.addEncoder((PasswordEncoder)new AtlassianSHA1PasswordEncoder());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        DirectoryTestHelper.deleteFromTables(DirectoryTestHelper.TABLE_NAMES, jdbcTemplate);
        Properties properties = DirectoryTestHelper.getConfigProperties(DirectoryTestHelper.getApacheDS154ConfigFileName());
        DirectoryImpl directoryTemplate = DirectoryTestHelper.createDirectoryTemplate(properties, (LDAPPropertiesHelper)this.ldapPropertiesHelperImpl, true);
        this.session = this.sessionFactory.openSession();
        this.session.setFlushMode(FlushMode.ALWAYS);
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(this.session));
        this.directory = new DirectoryImpl(this.directoryDao.add((Directory)directoryTemplate));
        InternalEntityTemplate template = new InternalEntityTemplate(this.directory.getId(), this.directory.getName(), true, new Date(), new Date());
        DirectoryImpl templateForMockDirectoryManager = new DirectoryImpl(template);
        templateForMockDirectoryManager.updateDetailsFrom((Directory)this.directory);
        this.directoryManager.setDirectory((Directory)templateForMockDirectoryManager);
        this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
        this.remoteDirectory = this.directoryInstanceLoader.getDirectory((Directory)this.directory);
        this.ldapDirectory = this.ldapDirectoryInstanceLoader.getDirectory((Directory)this.directory);
        this.directoryInstanceLoader.getRawDirectory(this.directory.getId(), this.directory.getImplementationClass(), this.directory.getAttributes()).testConnection();
        this.passwordEncoderFactory.addEncoder((PasswordEncoder)new LdapShaPasswordEncoder());
        this.removeTestData();
        this.loadTestData();
    }

    @After
    public void tearDown() {
        this.removeTestData();
        TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        this.session.close();
    }

    private void loadTestData() throws Exception {
        ImmutableUser user = new ImmutableUser(this.directory.getId(), LDAP_USER_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        ImmutableUser user2 = new ImmutableUser(this.directory.getId(), LDAP_USER2_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        ImmutableUser user3 = new ImmutableUser(this.directory.getId(), LDAP_USER3_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        this.ldapUser = this.ldapDirectory.addUser(new UserTemplate((User)user), new PasswordCredential("password"));
        this.ldapDirectory.addUser(new UserTemplate((User)user2), new PasswordCredential("password"));
        this.ldapDirectory.addUser(new UserTemplate((User)user3), new PasswordCredential("password"));
        GroupTemplate groupTemplate1 = new GroupTemplate(LDAP_GROUP_NAME, this.directory.getId().longValue());
        groupTemplate1.setDescription("LDAP Group 1");
        this.ldapGroup = this.ldapDirectory.addGroup(groupTemplate1);
        GroupTemplate groupTemplate2 = new GroupTemplate(LDAP_GROUP2_NAME, this.directory.getId().longValue());
        groupTemplate2.setDescription("LDAP Group 2");
        this.ldapDirectory.addGroup(groupTemplate2);
        this.ldapDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
    }

    public void removeTestData() {
        DirectoryTestHelper.silentlyRemoveUser(LDAP_USER_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveUser(LDAP_USER2_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveUser(LDAP_USER3_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveGroup(LOCAL_GROUP_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveGroup(LOCAL_GROUP2_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveGroup(LDAP_GROUP_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveGroup(LDAP_GROUP2_NAME, this.remoteDirectory);
        DirectoryTestHelper.silentlyRemoveGroup(LDAP_GROUP3_NAME, this.remoteDirectory);
    }

    private static void synchroniseCache(RemoteDirectory remoteDirectory) throws OperationFailedException {
        ((SynchronisableDirectory)remoteDirectory).synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
    }

    @Test
    public void testSearchOperations() throws Exception {
        User user = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        ModelAssertions.assertUsersEqual(this.ldapUser, user);
        Group group = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.ldapGroup, group);
        Assert.assertFalse((boolean)this.remoteDirectory.isUserDirectGroupMember(LDAP_USER_NAME, LDAP_GROUP_NAME));
        Assert.assertTrue((boolean)this.remoteDirectory.isUserDirectGroupMember(LDAP_USER2_NAME, LDAP_GROUP2_NAME));
        Assert.assertTrue((boolean)this.remoteDirectory.isGroupDirectGroupMember(LDAP_GROUP_NAME, LDAP_GROUP2_NAME));
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
        List users = this.remoteDirectory.searchUsers(query);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertTrue((boolean)users.contains(LDAP_USER_NAME));
        Assert.assertTrue((boolean)users.contains(LDAP_USER2_NAME));
        Assert.assertTrue((boolean)users.contains(LDAP_USER3_NAME));
        query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        List groups = this.remoteDirectory.searchGroups(query);
        Assert.assertEquals((long)3L, (long)users.size());
        Assert.assertTrue((boolean)groups.contains(LDAP_GROUP_NAME));
        Assert.assertTrue((boolean)groups.contains(LDAP_GROUP2_NAME));
        MembershipQuery membershipquery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP_NAME).returningAtMost(-1);
        List members = this.remoteDirectory.searchGroupRelationships(membershipquery);
        Assert.assertEquals((long)0L, (long)members.size());
        membershipquery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        members = this.remoteDirectory.searchGroupRelationships(membershipquery);
        Assert.assertEquals((long)2L, (long)members.size());
        Assert.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
        Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserViaLdap() throws Exception {
        ImmutableUser newUser = new ImmutableUser(this.directory.getId(), "USER99", "Alice", "Jones", "Alice Jones", "ajones@example.com");
        this.ldapUser = this.ldapDirectory.addUser(new UserTemplate((User)newUser), new PasswordCredential("password"));
        try {
            Assert.assertThat((Object)this.ldapUser.getExternalId(), (Matcher)Matchers.isEmptyOrNullString());
            User retrievedUser = null;
            try {
                retrievedUser = this.remoteDirectory.findUserByName("USER99");
                Assert.fail((String)"User should not be seen locally yet");
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            retrievedUser = this.remoteDirectory.findUserByName("USER99");
            ModelAssertions.assertUsersEqual(newUser, retrievedUser);
            Assert.assertThat((Object)retrievedUser.getExternalId(), (Matcher)IsNot.not((Matcher)Matchers.isEmptyOrNullString()));
        }
        finally {
            this.ldapDirectory.removeUser("USER99");
        }
    }

    @Test(expected=UserNotFoundException.class)
    public void testRemoveUserViaLdap() throws Exception {
        this.ldapDirectory.removeUser(LDAP_USER_NAME);
        User retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        Assert.assertNotNull((Object)retrievedUser);
        ModelAssertions.assertUsersEqual(this.ldapUser, retrievedUser);
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        this.remoteDirectory.findUserByName(LDAP_USER_NAME);
    }

    @Test
    public void testUpdateUserViaLdap() throws Exception {
        User testUser = this.ldapDirectory.findUserByName(LDAP_USER_NAME);
        UserTemplate template = new UserTemplate(testUser);
        template.setDisplayName("Updated display name");
        template.setEmailAddress("updated@example.org");
        User updatedUser = this.ldapDirectory.updateUser(template);
        User retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        Assert.assertNotNull((Object)retrievedUser);
        Assert.assertEquals((Object)this.ldapUser.getDisplayName(), (Object)retrievedUser.getDisplayName());
        Assert.assertEquals((Object)this.ldapUser.getEmailAddress(), (Object)retrievedUser.getEmailAddress());
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        Assert.assertNotNull((Object)retrievedUser);
        Assert.assertEquals((Object)"Updated display name", (Object)retrievedUser.getDisplayName());
        Assert.assertEquals((Object)"updated@example.org", (Object)retrievedUser.getEmailAddress());
        Assert.assertThat((Object)retrievedUser.getExternalId(), (Matcher)PatternMatcher.matchesPattern(EXTERNAL_ID_PATTERN));
        Assert.assertEquals((Object)testUser.getExternalId(), (Object)retrievedUser.getExternalId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGroupViaLdap() throws Exception {
        this.ldapGroup = this.ldapDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
        try {
            Group retrievedGroup = null;
            try {
                retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
                Assert.fail((String)"Group should not be seen locally yet");
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
            ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
        }
        finally {
            this.ldapDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    @Test
    public void testRemoveGroupViaLdap() throws Exception {
        this.ldapDirectory.removeGroup(LDAP_GROUP_NAME);
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        Assert.assertNotNull((Object)retrievedGroup);
        ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        try {
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
            Assert.fail((String)"Group should have been removed");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateGroupViaLdap() throws Exception {
        Group testGroup = this.ldapDirectory.findGroupByName(LDAP_GROUP_NAME);
        GroupTemplate template = new GroupTemplate(testGroup);
        template.setDescription("Updated description");
        Group updatedGroup = this.ldapDirectory.updateGroup(template);
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        Assert.assertNotNull((Object)retrievedGroup);
        Assert.assertEquals((Object)this.ldapGroup.getDescription(), (Object)retrievedGroup.getDescription());
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        Assert.assertNotNull((Object)retrievedGroup);
        Assert.assertEquals((Object)"Updated description", (Object)retrievedGroup.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddMembershipViaLdap() throws Exception {
        try {
            this.ldapGroup = this.ldapDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            this.ldapDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            Assert.assertEquals((long)0L, (long)members.size());
            MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            Assert.assertEquals((long)0L, (long)groupMembers.size());
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            Assert.assertEquals((long)2L, (long)members.size());
            Assert.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
            Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
            groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            Assert.assertEquals((long)1L, (long)groupMembers.size());
            Assert.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
        }
        finally {
            this.ldapDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.removeUserFromGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            this.ldapDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    @Test
    public void testRemoveMembershipViaLdap() throws Exception {
        this.ldapDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        Assert.assertEquals((long)2L, (long)members.size());
        Assert.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
        Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        Assert.assertEquals((long)1L, (long)groupMembers.size());
        Assert.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        Assert.assertEquals((long)1L, (long)members.size());
        Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        Assert.assertEquals((long)0L, (long)groupMembers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddUserViaCachingDirectory() throws Exception {
        ImmutableUser newUser = new ImmutableUser(this.directory.getId(), "USER99", "Alice", "Jones", "Alice Jones", "ajones@example.com");
        this.ldapUser = this.remoteDirectory.addUser(new UserTemplate((User)newUser), new PasswordCredential("password"));
        this.session.flush();
        try {
            User retrievedUser = this.remoteDirectory.findUserByName("USER99");
            ModelAssertions.assertUsersEqual(newUser, retrievedUser);
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            retrievedUser = this.remoteDirectory.findUserByName("USER99");
            ModelAssertions.assertUsersEqual(newUser, retrievedUser);
            Assert.assertThat((Object)retrievedUser.getExternalId(), (Matcher)IsNot.not((Matcher)Matchers.isEmptyOrNullString()));
        }
        finally {
            this.remoteDirectory.removeUser("USER99");
        }
    }

    @Test
    public void testRemoveUserViaCachingDirectory() throws Exception {
        User retrievedUser;
        this.remoteDirectory.removeUser(LDAP_USER_NAME);
        this.session.flush();
        try {
            retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
            Assert.fail((String)"User should have been removed");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        try {
            retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
            Assert.fail((String)"User should have been removed");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateUserViaCachingDirectory() throws Exception {
        User testUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        Assert.assertThat((Object)testUser.getExternalId(), (Matcher)PatternMatcher.matchesPattern(EXTERNAL_ID_PATTERN));
        UserTemplate template = new UserTemplate(testUser);
        template.setDisplayName("Updated display name");
        template.setEmailAddress("updated@example.org");
        User updatedUser = this.remoteDirectory.updateUser(template);
        User retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        Assert.assertNotNull((Object)retrievedUser);
        Assert.assertEquals((Object)"Updated display name", (Object)retrievedUser.getDisplayName());
        Assert.assertEquals((Object)"updated@example.org", (Object)retrievedUser.getEmailAddress());
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        retrievedUser = this.remoteDirectory.findUserByName(LDAP_USER_NAME);
        Assert.assertNotNull((Object)retrievedUser);
        Assert.assertEquals((Object)"Updated display name", (Object)retrievedUser.getDisplayName());
        Assert.assertEquals((Object)"updated@example.org", (Object)retrievedUser.getEmailAddress());
        Assert.assertEquals((Object)testUser.getExternalId(), (Object)retrievedUser.getExternalId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddGroupViaCachingDirectory() throws Exception {
        this.ldapGroup = this.remoteDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
        this.session.flush();
        try {
            Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
            ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP3_NAME);
            ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
        }
        finally {
            this.remoteDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    @Test
    public void testRemoveGroupViaCachingDirectory() throws Exception {
        Group retrievedGroup;
        this.remoteDirectory.removeGroup(LDAP_GROUP_NAME);
        this.session.flush();
        try {
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
            Assert.fail((String)"Group should have been removed");
        }
        catch (GroupNotFoundException e) {
            // empty catch block
        }
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        try {
            retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
            Assert.fail((String)"Group should have been removed");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateGroupViaCachingDirectory() throws Exception {
        Group testGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        GroupTemplate template = new GroupTemplate(testGroup);
        template.setDescription("Updated description");
        Group updatedGroup = this.remoteDirectory.updateGroup(template);
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        Assert.assertNotNull((Object)retrievedGroup);
        Assert.assertEquals((Object)"Updated description", (Object)retrievedGroup.getDescription());
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        Assert.assertNotNull((Object)retrievedGroup);
        Assert.assertEquals((Object)"Updated description", (Object)retrievedGroup.getDescription());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddMembershipViaCachingDirectory() throws Exception {
        try {
            this.ldapGroup = this.remoteDirectory.addGroup(new GroupTemplate(LDAP_GROUP3_NAME, this.directory.getId().longValue()));
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            this.remoteDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            this.session.flush();
            MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            Assert.assertEquals((long)2L, (long)members.size());
            Assert.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
            Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
            MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            Assert.assertEquals((long)1L, (long)groupMembers.size());
            Assert.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
            DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
            membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
            Assert.assertEquals((long)2L, (long)members.size());
            Assert.assertTrue((boolean)members.contains(LDAP_USER2_NAME));
            Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
            groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP3_NAME).returningAtMost(-1);
            groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
            Assert.assertEquals((long)1L, (long)groupMembers.size());
            Assert.assertTrue((boolean)groupMembers.contains(LDAP_GROUP_NAME));
        }
        finally {
            this.remoteDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.removeUserFromGroup(LDAP_USER3_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP3_NAME);
            this.remoteDirectory.removeGroup(LDAP_GROUP3_NAME);
        }
    }

    @Test
    public void testRemoveMembershipViaCachingDirectory() throws Exception {
        this.remoteDirectory.removeUserFromGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.remoteDirectory.removeGroupFromGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        this.session.flush();
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        Assert.assertEquals((long)1L, (long)members.size());
        Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        MembershipQuery groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        List groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        Assert.assertEquals((long)0L, (long)groupMembers.size());
        DbCachingLdapTest.synchroniseCache(this.remoteDirectory);
        membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        members = this.remoteDirectory.searchGroupRelationships(membershipQuery);
        Assert.assertEquals((long)1L, (long)members.size());
        Assert.assertTrue((boolean)members.contains(LDAP_USER3_NAME));
        groupMembershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        groupMembers = this.remoteDirectory.searchGroupRelationships(groupMembershipQuery);
        Assert.assertEquals((long)0L, (long)groupMembers.size());
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setLdapPropertiesHelperImpl(LDAPPropertiesHelperImpl ldapPropertiesHelperImpl) {
        this.ldapPropertiesHelperImpl = ldapPropertiesHelperImpl;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    public void setDirectoryManager(MockDirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setDirectoryInstanceLoader(CacheableDirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }

    public void setLdapDirectoryInstanceLoader(LDAPDirectoryInstanceLoader ldapDirectoryInstanceLoader) {
        this.ldapDirectoryInstanceLoader = ldapDirectoryInstanceLoader;
    }

    public void setInternalDirectoryInstanceLoader(InternalDirectoryInstanceLoader internalDirectoryInstanceLoader) {
        this.internalDirectoryInstanceLoader = internalDirectoryInstanceLoader;
    }
}

