/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import junit.framework.TestCase;
import org.springframework.ldap.core.ContextExecutor;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

public class ChangeNotificationTest
extends TestCase {
    private String connectionURL;
    private String username;
    private String password;
    private String userDN;
    private LdapTemplate ldapTemplate;

    private void setupApacheDS() {
        this.connectionURL = "ldap://localhost:10389";
        this.username = "uid=admin,ou=system";
        this.password = "secret";
        this.userDN = "ou=users,dc=example,dc=com";
    }

    private void setupOpenDS() {
        this.connectionURL = "ldap://crowd-opends:389";
        this.username = "cn=Directory Manager";
        this.password = "atlassian";
        this.userDN = "ou=People,dc=example,dc=com";
    }

    private void setupNovell() {
        this.connectionURL = "ldap://crowd-novell:389";
        this.username = "cn=Admin,o=null";
        this.password = "atlassian";
        this.userDN = "o=Atlassian";
    }

    protected void setUp() throws Exception {
        this.setupNovell();
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.connectionURL);
        contextSource.setUserDn(this.username);
        contextSource.setPassword(this.password);
        HashMap env = new HashMap();
        contextSource.setBaseEnvironmentProperties(env);
        contextSource.setPooled(true);
        contextSource.setDirObjectFactory(null);
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            e.printStackTrace();
            ChangeNotificationTest.fail((String)e.getMessage());
        }
        this.ldapTemplate = new LdapTemplate((ContextSource)contextSource);
    }

    public void testPersistentSearch() throws Exception {
        final SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        ContextExecutor contextExecutor = new ContextExecutor(){

            public Object executeWithContext(DirContext ctx) throws NamingException {
                EventDirContext ectx = (EventDirContext)ctx.lookup("");
                ectx.addNamingListener(ChangeNotificationTest.this.userDN, "(objectclass=inetorgperson)", searchControls, (NamingListener)new SimpleChangeListener("listener_1"));
                return null;
            }
        };
        this.ldapTemplate.executeReadOnly(contextExecutor);
        System.out.println("slumber..");
        Thread.sleep(120000L);
        System.out.println("..party's over");
    }

    private static class SimpleChangeListener
    implements NamespaceChangeListener,
    ObjectChangeListener {
        private String id;

        public SimpleChangeListener(String id) {
            this.id = id;
        }

        @Override
        public void objectAdded(NamingEvent evt) {
            System.out.println("\n\n" + this.id + ">>> object added event. Object Name: " + evt.getNewBinding().getName());
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            System.out.println("\n\n" + this.id + ">>> object removed event. Object Name: " + evt.getOldBinding().getName());
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            System.out.println("\n\n" + this.id + ">>> object renamed event. New name: " + evt.getNewBinding().getName() + " Old name: " + evt.getOldBinding().getName());
        }

        @Override
        public void objectChanged(NamingEvent evt) {
            System.out.println("\n\n" + this.id + ">>> object changed event. Object name: " + evt.getNewBinding().getName());
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
            System.out.println("\n\n" + this.id + ">>> Listener received a naming exception");
            evt.getException().printStackTrace();
        }
    }
}

