/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.integration.soap.SOAPEntity;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class SecurityServerClientTest
extends CrowdAcceptanceTestCase {
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("tokenauthenticationtest.xml");
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testSearchGroupsWhereUserIsAMember() throws Exception {
        SearchRestriction restriction = new SearchRestriction("group.principal.member", "admin");
        SOAPGroup[] soapGroups = this.securityServerClient.searchGroups(new SearchRestriction[]{restriction});
        SecurityServerClientTest.assertContainsExactly(Arrays.asList(soapGroups), "crowd-administrators", "general-group");
    }

    public void testSearchGroupsWithNameRestriction() throws Exception {
        SearchRestriction restriction = new SearchRestriction("group.name", "crowd-administrators");
        SOAPGroup[] soapGroups = this.securityServerClient.searchGroups(new SearchRestriction[]{restriction});
        SecurityServerClientTest.assertContainsExactly(Arrays.asList(soapGroups), "crowd-administrators");
    }

    public void testSearchGroupsPopulatesEntityFields() throws Exception {
        SearchRestriction restriction = new SearchRestriction("group.name", "general-group");
        SOAPGroup[] soapGroups = this.securityServerClient.searchGroups(new SearchRestriction[]{restriction});
        SecurityServerClientTest.assertTrue((boolean)soapGroups[0].isActive());
        SecurityServerClientTest.assertEquals((String)"General Group", (String)soapGroups[0].getDescription());
        SecurityServerClientTest.assertEquals((long)32769L, (long)soapGroups[0].getDirectoryId());
    }

    static List<String> namesOf(Iterable<? extends SOAPEntity> entities) {
        ArrayList<String> names = new ArrayList<String>();
        for (SOAPEntity sOAPEntity : entities) {
            names.add(sOAPEntity.getName());
        }
        return names;
    }

    public static void assertContainsExactly(List<? extends SOAPEntity> entities, String ... names) {
        SecurityServerClientTest.assertEquals(SecurityServerClientTest.namesOf(entities), Arrays.asList(names));
    }

    public void testSearchPrincipals_Aliases() throws Exception {
        this.setApplication("aliases", "aliases");
        SOAPPrincipal[] principals = this.securityServerClient.searchPrincipals(new SearchRestriction[]{new SearchRestriction("principal.name", "alias")});
        SecurityServerClientTest.assertContainsExactly(Arrays.asList(principals), "alias1", "alias2");
    }

    public void testSearchPrincipals_AliasesIgnoreUsernameWhenAliasExists() throws Exception {
        this.setApplication("aliases", "aliases");
        SOAPPrincipal[] principals = this.securityServerClient.searchPrincipals(new SearchRestriction[]{new SearchRestriction("principal.name", "user")});
        SecurityServerClientTest.assertContainsExactly(Arrays.asList(principals), "user2");
    }

    public void testSearchPrincipals_AliasesAll() throws Exception {
        this.setApplication("aliases", "aliases");
        SOAPPrincipal[] principals = this.securityServerClient.searchPrincipals(new SearchRestriction[]{new SearchRestriction("principal.name", "s")});
        SecurityServerClientTest.assertContainsExactly(Arrays.asList(principals), "alias1", "alias2", "user2");
    }

    private void setApplication(String applicationName, String password) {
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        sscProperties.setProperty("application.password", password);
        sscProperties.setProperty("application.name", applicationName);
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }
}

