/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.ArrayAssertions;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.Properties;

public class SecurityServerClientPrincipalTest
extends CrowdAcceptanceTestCase {
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;
    private Properties sscProperties;
    private static final String USER_1 = "user";
    private static final String USER_2 = "user2";
    private static final String USER1_ATTRIBUTE1_NAME = "colour";
    private static final String USER1_ATTRIBUTE2_NAME = "numbers";
    private static final SOAPAttribute USER1_ATTRIBUTE1_VALUE = new SOAPAttribute("colour", "green");
    private static final SOAPAttribute USER1_ATTRIBUTE2_VALUE = new SOAPAttribute("numbers", new String[]{"one", "two", "three"});
    private static final String USER2_ATTRIBUTE1_NAME = "animal";
    private static final String USER2_ATTRIBUTE2_NAME = "food";
    private static final String GIVEN_NAME = "givenName";
    private static final String LAST_NAME = "sn";
    private static final String DISPLAY_NAME = "displayName";
    private static final String MAIL = "mail";
    private static final String INVALID_PASSWORD_ATTEMPTS = "invalidPasswordAttempts";
    private static final String REQUIRES_PASSWORD_CHANGE = "requiresPasswordChange";
    private static final String PASSWORD_LAST_CHANGED = "passwordLastChanged";
    private static final String LAST_AUTHENTICATED = "lastAuthenticated";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("securityserverclienttest.xml");
        this.sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)this.sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testFindPrincipalByName() throws Exception {
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalByName(USER_1);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_1, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)4, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(GIVEN_NAME).getValues(), "Normal");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(LAST_NAME).getValues(), "User");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(DISPLAY_NAME).getValues(), "Normal User");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(MAIL).getValues(), "user@user.com");
    }

    public void testFindPrincipalWithAttributesByName() throws Exception {
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_1);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_1, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)8, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(INVALID_PASSWORD_ATTEMPTS).getValues(), "0");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(LAST_AUTHENTICATED).getValues(), "1241415635159");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(PASSWORD_LAST_CHANGED).getValues(), "1241415535781");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(REQUIRES_PASSWORD_CHANGE).getValues(), "false");
    }

    public void testFindPrincipalWithAttributesByNameCustomAttributes() throws Exception {
        this.intendToModifyData();
        this.securityServerClient.addAttributeToPrincipal(USER_1, USER1_ATTRIBUTE1_VALUE);
        this.securityServerClient.addAttributeToPrincipal(USER_1, USER1_ATTRIBUTE2_VALUE);
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_1);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_1, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)10, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE1_NAME).getValues(), "green");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE2_NAME).getValues(), "one", "two", "three");
    }

    public void testAddRemovePrincipalCustomAttributes() throws Exception {
        this.intendToModifyData();
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_1);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_1, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)8, (int)soapPrincipal.getAttributes().length);
        this.securityServerClient.addAttributeToPrincipal(USER_1, USER1_ATTRIBUTE1_VALUE);
        this.securityServerClient.addAttributeToPrincipal(USER_1, USER1_ATTRIBUTE2_VALUE);
        soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_1);
        SecurityServerClientPrincipalTest.assertEquals((int)10, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE1_NAME).getValues(), "green");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE2_NAME).getValues(), "one", "two", "three");
        this.securityServerClient.removeAttributeFromPrincipal(USER_1, USER1_ATTRIBUTE1_NAME);
        soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_1);
        SecurityServerClientPrincipalTest.assertEquals((int)9, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE2_NAME).getValues(), "one", "two", "three");
        SecurityServerClientPrincipalTest.assertNull((Object)soapPrincipal.getAttribute(USER1_ATTRIBUTE1_NAME));
    }

    public void testFindPrincipalByNameWithExistingCustomAttributes() throws Exception {
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalByName(USER_2);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_2, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)4, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(GIVEN_NAME).getValues(), "Normal");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(LAST_NAME).getValues(), "User2");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(DISPLAY_NAME).getValues(), "Normal User2");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(MAIL).getValues(), "user2@user.com");
    }

    public void testFindPrincipalWithAttributesByNameWithExistingCustomAttributes() throws Exception {
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_2);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_2, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)8, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(REQUIRES_PASSWORD_CHANGE).getValues(), "false");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(PASSWORD_LAST_CHANGED).getValues(), "1241415585824");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER2_ATTRIBUTE1_NAME).getValues(), "bear", "dog");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER2_ATTRIBUTE2_NAME).getValues(), "chocolate");
    }

    public void testAddRemovePrincipalCustomAttributesWithExistingCustomAttributes() throws Exception {
        this.intendToModifyData();
        SOAPPrincipal soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_2);
        SecurityServerClientPrincipalTest.assertEquals((String)USER_2, (String)soapPrincipal.getName());
        SecurityServerClientPrincipalTest.assertEquals((int)8, (int)soapPrincipal.getAttributes().length);
        this.securityServerClient.addAttributeToPrincipal(USER_2, USER1_ATTRIBUTE1_VALUE);
        this.securityServerClient.addAttributeToPrincipal(USER_2, USER1_ATTRIBUTE2_VALUE);
        soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_2);
        SecurityServerClientPrincipalTest.assertEquals((int)10, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE1_NAME).getValues(), "green");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE2_NAME).getValues(), "one", "two", "three");
        this.securityServerClient.removeAttributeFromPrincipal(USER_2, USER1_ATTRIBUTE1_NAME);
        soapPrincipal = this.securityServerClient.findPrincipalWithAttributesByName(USER_2);
        SecurityServerClientPrincipalTest.assertEquals((int)9, (int)soapPrincipal.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER1_ATTRIBUTE2_NAME).getValues(), "one", "two", "three");
        SecurityServerClientPrincipalTest.assertNull((Object)soapPrincipal.getAttribute(USER1_ATTRIBUTE1_NAME));
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(GIVEN_NAME).getValues(), "Normal");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(LAST_NAME).getValues(), "User2");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(DISPLAY_NAME).getValues(), "Normal User2");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(MAIL).getValues(), "user2@user.com");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(REQUIRES_PASSWORD_CHANGE).getValues(), "false");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(PASSWORD_LAST_CHANGED).getValues(), "1241415585824");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER2_ATTRIBUTE1_NAME).getValues(), "bear", "dog");
        ArrayAssertions.assertContainsElements(soapPrincipal.getAttribute(USER2_ATTRIBUTE2_NAME).getValues(), "chocolate");
    }
}

