/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.Collection;
import java.util.Properties;

public abstract class NestedGroupsBase
extends CrowdAcceptanceTestCase {
    protected SecurityServerClient securityServerClient;
    LDAPLoader loader = new LDAPLoader();
    private static final String USER_NAME = "myUser";
    private static final String GROUP_NAME = "myGroup";
    private static final String SUB_GROUP_NAME = "mySubGroup";
    private static final String SUB_USER_NAME = "mySubUser";
    private static final String ANOTHER_USER_NAME = "myOtherUser";

    protected void setupSecurityServer() throws Exception {
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
    }

    protected abstract void setupClientLibrary() throws Exception;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("clientlib.xml");
        this.setupSecurityServer();
        this.setupClientLibrary();
        this.loader.accessibleSetUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.loader.accessibleTearDown();
        CachingManagerFactory.getCache().flush();
        super.tearDown();
    }

    public void testUsersByGroupMatchesGroupsByUser() throws Exception {
        Collection usersInGroup = this.getUsersInGroup(GROUP_NAME);
        NestedGroupsBase.assertNotNull((Object)usersInGroup);
        NestedGroupsBase.assertEquals((String)"There should be two users in GROUP_NAME", (int)2, (int)usersInGroup.size());
        NestedGroupsBase.assertTrue((String)"USER_NAME should be in GROUP_NAME via getUsersInGroup", (boolean)this.isUserInList(usersInGroup, USER_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in GROUP_NAME via getUsersInGroup", (boolean)this.isUserInList(usersInGroup, SUB_USER_NAME));
        Collection usersInGroup2 = this.getUsersInGroup(SUB_GROUP_NAME);
        NestedGroupsBase.assertNotNull((Object)usersInGroup2);
        NestedGroupsBase.assertEquals((String)"There should be one user in SUB_GROUP_NAME", (int)1, (int)usersInGroup2.size());
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in SUB_GROUP_NAME via getUsersInGroup", (boolean)this.isUserInList(usersInGroup, SUB_USER_NAME));
        Collection groupsForUser = this.getGroupsForUser(SUB_USER_NAME);
        NestedGroupsBase.assertNotNull((Object)groupsForUser);
        NestedGroupsBase.assertEquals((String)"There should be two groups for SUB_USER_NAME", (int)2, (int)groupsForUser.size());
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in GROUP_NAME via getGroupsForUser", (boolean)this.isGroupInList(groupsForUser, GROUP_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_GROUP_NAME should be a group of SUB_USER_NAME", (boolean)this.isGroupInList(groupsForUser, SUB_GROUP_NAME));
        Collection groupsForUser2 = this.getGroupsForUser(USER_NAME);
        NestedGroupsBase.assertNotNull((Object)groupsForUser2);
        NestedGroupsBase.assertEquals((String)"There should be one group for USER_NAME", (int)1, (int)groupsForUser2.size());
        NestedGroupsBase.assertTrue((String)"GROUP_NAME should be a group of USER_NAME", (boolean)this.isGroupInList(groupsForUser2, GROUP_NAME));
    }

    public void testRemoveFromGroup_MemberOfSubGroup() throws Exception {
        NestedGroupsBase.assertTrue((String)"Sub user should be reported as being member of parent group", (boolean)this.isInGroup(SUB_USER_NAME, GROUP_NAME));
        NestedGroupsBase.assertFalse((String)"Sub-user removal from parent group should fail", (boolean)this.removeUserFromGroup(SUB_USER_NAME, GROUP_NAME));
        NestedGroupsBase.assertTrue((String)"Sub user should be reported as being member of parent group", (boolean)this.isInGroup(SUB_USER_NAME, GROUP_NAME));
    }

    public void testRemoveFromGroup_MemberOfGroup() throws Exception {
        this.intendToModifyData();
        NestedGroupsBase.assertTrue((String)"USER_NAME should be a member of GROUP_NAME", (boolean)this.isInGroup(USER_NAME, GROUP_NAME));
        NestedGroupsBase.assertTrue((String)"Removal of USER_NAME from GROUP_NAME should succeed", (boolean)this.removeUserFromGroup(USER_NAME, GROUP_NAME));
        NestedGroupsBase.assertFalse((String)"USER_NAME should not be a member of GROUP_NAME", (boolean)this.isInGroup(USER_NAME, GROUP_NAME));
        NestedGroupsBase.assertFalse((String)"USER_NAME should not be a member of GROUP_NAME using getGroupsForUser call", (boolean)this.isGroupInList(this.getGroupsForUser(USER_NAME), GROUP_NAME));
        NestedGroupsBase.assertFalse((String)"USER_NAME should not be in member list of GROUP_NAME", (boolean)this.isUserInList(this.getUsersInGroup(GROUP_NAME), USER_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in SUB_GROUP_NAME", (boolean)this.isInGroup(SUB_USER_NAME, SUB_GROUP_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in SUB_GROUP_NAME using getGroupsForUser call", (boolean)this.isGroupInList(this.getGroupsForUser(SUB_USER_NAME), SUB_GROUP_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in GROUP_NAME using getGroupsForUser call", (boolean)this.isGroupInList(this.getGroupsForUser(SUB_USER_NAME), GROUP_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in SUB_GROUP_NAME using getUsersForGroup call", (boolean)this.isUserInList(this.getUsersInGroup(SUB_GROUP_NAME), SUB_USER_NAME));
        NestedGroupsBase.assertTrue((String)"SUB_USER_NAME should be in GROUP_NAME using getUsersForGroup call", (boolean)this.isUserInList(this.getUsersInGroup(GROUP_NAME), SUB_USER_NAME));
    }

    public void testRemoveFromGroup_SubMemberOfSubGroup() throws Exception {
        this.intendToModifyData();
        NestedGroupsBase.assertTrue((boolean)this.isInGroup(SUB_USER_NAME, SUB_GROUP_NAME));
        NestedGroupsBase.assertTrue((boolean)this.removeUserFromGroup(SUB_USER_NAME, SUB_GROUP_NAME));
        NestedGroupsBase.assertFalse((boolean)this.isInGroup(SUB_USER_NAME, SUB_GROUP_NAME));
        NestedGroupsBase.assertFalse((boolean)this.isGroupInList(this.getGroupsForUser(SUB_USER_NAME), SUB_GROUP_NAME));
        NestedGroupsBase.assertFalse((boolean)this.isUserInList(this.getUsersInGroup(SUB_GROUP_NAME), SUB_USER_NAME));
    }

    public void testInGroup() throws Exception {
        NestedGroupsBase.assertTrue((boolean)this.isInGroup(USER_NAME, GROUP_NAME));
    }

    public void testInGroup_UserInSubGroup() throws Exception {
        NestedGroupsBase.assertTrue((boolean)this.isInGroup(SUB_USER_NAME, GROUP_NAME));
    }

    public void testInGroup_UserInParentGroup() throws Exception {
        NestedGroupsBase.assertFalse((boolean)this.isInGroup(USER_NAME, SUB_GROUP_NAME));
    }

    public void testInGroup_UserNotInGroup() throws Exception {
        NestedGroupsBase.assertFalse((boolean)this.isInGroup(ANOTHER_USER_NAME, GROUP_NAME));
    }

    public abstract Collection getAllGroupNames() throws Exception;

    public abstract Collection getUsersInGroup(String var1) throws Exception;

    public abstract Collection getGroupsForUser(String var1) throws Exception;

    public abstract boolean isInGroup(String var1, String var2) throws Exception;

    public abstract boolean removeUserFromGroup(String var1, String var2) throws Exception;

    public abstract boolean isGroupInList(Collection var1, String var2) throws Exception;

    public abstract boolean isUserInList(Collection var1, String var2) throws Exception;

    class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS102ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.FALSE.toString());
        }

        @Override
        protected void loadTestData() throws Exception {
            Long directoryId = this.directory.getId();
            DirectoryTestHelper.addUser(NestedGroupsBase.USER_NAME, directoryId, "secret", this.getRemoteDirectory());
            DirectoryTestHelper.addUser(NestedGroupsBase.SUB_USER_NAME, directoryId, "secret", this.getRemoteDirectory());
            DirectoryTestHelper.addUser(NestedGroupsBase.ANOTHER_USER_NAME, directoryId, "secret", this.getRemoteDirectory());
            DirectoryTestHelper.addGroup(NestedGroupsBase.GROUP_NAME, directoryId, this.getRemoteDirectory());
            DirectoryTestHelper.addGroup(NestedGroupsBase.SUB_GROUP_NAME, directoryId, this.getRemoteDirectory());
            this.getRemoteDirectory().addUserToGroup(NestedGroupsBase.USER_NAME, NestedGroupsBase.GROUP_NAME);
            this.getRemoteDirectory().addGroupToGroup(NestedGroupsBase.SUB_GROUP_NAME, NestedGroupsBase.GROUP_NAME);
            this.getRemoteDirectory().addUserToGroup(NestedGroupsBase.SUB_USER_NAME, NestedGroupsBase.SUB_GROUP_NAME);
        }

        @Override
        protected void removeTestData() throws DirectoryInstantiationException {
            DirectoryTestHelper.silentlyRemoveUser(NestedGroupsBase.USER_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveUser(NestedGroupsBase.SUB_USER_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveUser(NestedGroupsBase.ANOTHER_USER_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroup(NestedGroupsBase.GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroup(NestedGroupsBase.SUB_GROUP_NAME, this.getRemoteDirectory());
        }

        public void removeGroupFromGroup() throws Exception {
            this.getRemoteDirectory().removeUserFromGroup(NestedGroupsBase.USER_NAME, NestedGroupsBase.GROUP_NAME);
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

