/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.demo;

import com.atlassian.crowd.acceptance.tests.ApplicationAcceptanceTestCase;
import junit.framework.AssertionFailedError;

public class DemoAcceptanceTestCase
extends ApplicationAcceptanceTestCase {
    protected static final String TEST_USER = "user";
    protected static final String TEST_PW = "password";
    protected static final String DEMO_USER = "demo";
    protected static final String DEMO_PW = "password";
    protected static final String CROWD_USER = "immutable";
    protected static final String CROWD_PW = "password";

    protected void _loginAdminUser() {
        this.beginAt(this.baseUrl);
        this.assertKeyPresent("login.title");
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertLinkPresentWithKey("menu.logout.label");
    }

    protected void _logout() {
        this.gotoPage("/console/logoff.action");
        this.assertKeyPresent("login.title");
    }

    @Override
    protected String getResourceBundleName() {
        return "com.atlassian.crowd.security.demo.action.BaseAction";
    }

    @Override
    protected String getApplicationName() {
        return DEMO_USER;
    }

    @Override
    protected String getLocalTestPropertiesFileName() {
        return "localtest.properties";
    }

    protected void gotoViewUser(String username) {
        this.gotoPage("/secure/user/viewuser.action?name=" + username);
    }

    protected String loginToDemo(String username, String password) {
        this._logout();
        this.assertKeyPresent("login.title");
        this.setTextField("username", username);
        this.setTextField("password", password);
        this.submit();
        try {
            this.assertLinkPresentWithKey("menu.logout.label");
            return this.getElementTextByXPath("//span[@id='userFullName']");
        }
        catch (AssertionFailedError e) {
            return null;
        }
    }

    protected void logoutFromDemo() {
        this._logout();
    }

    protected String getCurrentlyLoggedInDemoUserFullName() {
        this.gotoPage("/");
        try {
            return this.getElementTextByXPath("//span[@id='userFullName']");
        }
        catch (AssertionFailedError e) {
            return null;
        }
    }
}

