/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.client;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.atlassian.crowd.acceptance.tests.applications.crowdid.client.CrowdIDClientAcceptanceTestCase;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import net.sourceforge.jwebunit.api.IElement;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;

public class OpenIDAuthenticationTest
extends CrowdIDClientAcceptanceTestCase {
    protected String OPENIDSERVER_LOGIN_URL_ADMIN;
    protected String OPENID_SERVER_URL;
    private String OPENID_CLIENT_REALM;
    protected static final String SERVER_NAME = "crowdid";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loginToCrowd();
        this.restoreCrowdFromXML("openidauthtest.xml");
        this.logoutFromCrowd();
        BaseUrlFromProperties props = BaseUrlFromProperties.withLocalTestProperties();
        this.OPENID_CLIENT_REALM = props.baseUrlFor(this.getApplicationName());
        this.OPENID_SERVER_URL = props.baseUrlFor(SERVER_NAME);
        this.OPENIDSERVER_LOGIN_URL_ADMIN = this.OPENID_SERVER_URL + "/users/" + "admin";
        this.tearDownApprovedSitesForAdmin();
    }

    public void tearDownApprovedSitesForAdmin() {
        this.gotoPage(this.OPENID_SERVER_URL + "/secure/interaction/editallowalways!default.action");
        this.assertTitleEquals("Atlassian CrowdID - Login");
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.setScriptingEnabled(true);
        this.submit();
        this.assertTitleEquals("Atlassian CrowdID - Approved Sites");
        List sites = this.getElementsByXPath("//img[@title='Remove approved site from profile.']");
        if (!sites.isEmpty()) {
            for (IElement e : sites) {
                String id = e.getAttribute("id");
                this.clickElementByXPath("id('" + id + "')");
            }
            this.clickButtonWithText("Apply");
            Assert.assertThat((Object)this.getElementTextByXPath("//p[@class='successBox']"), OpenIDAuthenticationTest.equalToIgnoringWhiteSpace("Update Successful."));
        }
        this.gotoPage(this.OPENID_SERVER_URL + "/logoff.action");
        this.assertTitleEquals("Atlassian CrowdID - Login");
    }

    protected void assertAtClientLoginPage() {
        this.assertKeyPresent("login.title");
        this.assertKeyNotPresent("menu.logout.label");
        this.assertKeyNotPresent("menu.profile.label");
    }

    protected void assertAtServerLoginPage() {
        this.assertTitleEquals("Atlassian CrowdID - Login");
    }

    Map<String, String> scrapeKeyValueTable(String id) {
        ImmutableMap.Builder mb = ImmutableMap.builder();
        for (List ls : this.scrapeTable(id, Functions.identity())) {
            OpenIDAuthenticationTest.assertEquals((int)2, (int)ls.size());
            mb.put(ls.get(0), ls.get(1));
        }
        return mb.build();
    }

    private static Matcher<String> equalToIgnoringWhiteSpace(String s) {
        return new IsEqualIgnoringWhiteSpace(s){

            public String stripSpace(String toBeStripped) {
                return toBeStripped.replaceAll("[\\s\u00a0]+", " ").trim();
            }
        };
    }

    protected void assertAtServerAllowDenyPage(String clientUrl, String serverUrl, String nickName, String fullName, String email) {
        this.assertTitleEquals("Atlassian CrowdID - OpenID Verification");
        Assert.assertThat((Object)this.getElementTextById("requestingSite"), OpenIDAuthenticationTest.equalToIgnoringWhiteSpace(clientUrl));
        Assert.assertThat((Object)this.getElementTextById("requestingIdentity"), OpenIDAuthenticationTest.equalToIgnoringWhiteSpace(serverUrl));
        Assert.assertThat((Object)this.getElementTextById("requestingAttributes"), OpenIDAuthenticationTest.equalToIgnoringWhiteSpace("nickname   email   fullname   dob   gender   postcode   country   language   timezone"));
        Map<String, String> attributeTable = this.scrapeKeyValueTable("attributeTable");
        Assert.assertThat(attributeTable, (Matcher)IsMapContaining.hasEntry((Object)"Nickname", (Object)nickName));
        Assert.assertThat(attributeTable, (Matcher)IsMapContaining.hasEntry((Object)"Full Name", (Object)fullName));
        Assert.assertThat(attributeTable, (Matcher)IsMapContaining.hasEntry((Object)"Email", (Object)email));
        Assert.assertThat(attributeTable, (Matcher)IsMapContaining.hasKey((Object)"Country"));
        Assert.assertThat(attributeTable, (Matcher)IsMapContaining.hasKey((Object)"Language"));
    }

    protected void assertAtClientProfilePage(String serverUrl, String userName, String email, String userFullName) {
        this.assertKeyNotPresent("login.title");
        this.assertKeyPresent("menu.logout.label");
        this.assertKeyPresent("menu.profile.label");
        IElement link = this.getElementByXPath("id('identifierTable')/tbody/tr/td/a");
        OpenIDAuthenticationTest.assertEquals((String)serverUrl, (String)link.getTextContent());
        OpenIDAuthenticationTest.assertEquals((String)serverUrl, (String)link.getAttribute("href"));
        OpenIDAuthenticationTest.assertEquals(this.scrapeKeyValueTable("identifierTable"), (Object)ImmutableMap.of((Object)"OpenID Identifier (URL)", (Object)serverUrl));
        Map<String, String> attributesTable = this.scrapeKeyValueTable("attributesTable");
        Assert.assertThat(attributesTable, (Matcher)IsMapContaining.hasEntry((Object)"nickname", (Object)userName));
        Assert.assertThat(attributesTable, (Matcher)IsMapContaining.hasEntry((Object)"email", (Object)email));
        Assert.assertThat(attributesTable, (Matcher)IsMapContaining.hasEntry((Object)"fullname", (Object)userFullName));
        Assert.assertThat(attributesTable, (Matcher)IsMapContaining.hasKey((Object)"language"));
        Assert.assertThat(attributesTable, (Matcher)IsMapContaining.hasKey((Object)"country"));
    }

    private void submitAndAssertAtServerLoginPage() {
        this.setScriptingEnabled(true);
        this.submit();
        this.assertAtServerLoginPage();
        this.setScriptingEnabled(false);
    }

    public void testOpenIDAuthenticationAllow() {
        this.log("Running testOpenIDAuthenticationAllow");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.setScriptingEnabled(true);
        this.submit();
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "Super User", "admin@example.com");
        this.setScriptingEnabled(false);
        this.clickLink("allow");
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
    }

    public void testOpenIDAuthenticationDeny() {
        this.log("Running testOpenIDAuthenticationDeny");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.setScriptingEnabled(true);
        this.submit();
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "Super User", "admin@example.com");
        this.setScriptingEnabled(false);
        this.clickLink("deny");
        this.assertAtClientLoginPage();
        this.assertTextPresent("Authentication Failed: Your OpenID provider was unable to authenticate the OpenID URL. Log in to your OpenID provider and try again.");
    }

    public void testOpenIDAuthenticationFailsWhenUsernamePaddedBeforeFinalSlash() {
        String loginUrlNotTheAdmin = this.OPENID_SERVER_URL + "/users/" + "not/the/admin";
        this.log("Running testOpenIDAuthenticationDeny");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", loginUrlNotTheAdmin);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertTextPresent("A request has been made to authenticate an OpenID identifier, different from the one you are logged in as.");
    }

    public void testOpenIDAuthenticationStateless() {
        this.log("Running testOpenIDAuthenticationStateless");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.OPENIDSERVER_LOGIN_URL_ADMIN);
        this.checkCheckbox("dummyMode");
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "Super User", "admin@example.com");
        this.clickLink("allow");
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
    }

    public void testOpenIDAuthenticationImmediate_fail() {
        this.log("Running testOpenIDAuthenticationImmediate_fail");
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.OPENIDSERVER_LOGIN_URL_ADMIN);
        this.checkCheckbox("checkImmediate");
        this.setScriptingEnabled(true);
        this.submit();
        this.assertAtClientLoginPage();
        this.setScriptingEnabled(false);
        this.assertTextPresent("Authentication Failed: Your OpenID provider was unable to authenticate the OpenID URL. Log in to your OpenID provider and try again.");
    }

    private void establishApproveAlwaysForAdmin() {
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "Super User", "admin@example.com");
        this.clickLink("allowAlways");
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
        this.gotoPage("/logoff.action");
    }

    public void testOpenIDAuthenticationImmediateSucceedsAfterAllowAlwaysApproval() {
        this.establishApproveAlwaysForAdmin();
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.OPENIDSERVER_LOGIN_URL_ADMIN);
        this.checkCheckbox("checkImmediate");
        this.setScriptingEnabled(true);
        this.submit();
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
        this.setScriptingEnabled(false);
    }

    public void testOpenIDClientShouldWorkWithUrlsWhichContainUTF8Characters() throws UnsupportedEncodingException {
        String serverUrl = this.OPENID_SERVER_URL + "/users/" + "john.t\u00f8stin\u00f3g\u00e9";
        this.assertIsAbleToAuthenticate("john.t\u00f8stin\u00f3g\u00e9", "john", serverUrl, "john@example.com", "John T\u00f8stin\u00f3g\u00e9", "/users/john.t%C3%B8stin%C3%B3g%C3%A9");
    }

    public void testOpenIDClientShouldWorkWithUrlInEncodedFormat() throws UnsupportedEncodingException {
        String serverUrl = this.OPENID_SERVER_URL + "/users/" + "john.t%C3%B8stin%C3%B3g%C3%A9";
        this.assertIsAbleToAuthenticate("john.t\u00f8stin\u00f3g\u00e9", "john", serverUrl, "john@example.com", "John T\u00f8stin\u00f3g\u00e9", "/users/john.t%C3%B8stin%C3%B3g%C3%A9");
    }

    public void testOpenIDTrimsUrlsBeforeAuthenticatingRequest() {
        this.gotoPage("/");
        String openidserver_login_url_admin = "  " + this.OPENIDSERVER_LOGIN_URL_ADMIN + "   ";
        this.setTextField("openid_identifier", openidserver_login_url_admin);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "Super User", "admin@example.com");
        this.clickLink("allow");
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
    }

    private void assertIsAbleToAuthenticate(String username, String password, String serverUrl, String email, String fullName, String relativeIdentifier) throws UnsupportedEncodingException {
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", serverUrl);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", username);
        this.setTextField("password", password);
        this.submit();
        String openIdUrl = this.OPENID_SERVER_URL + relativeIdentifier;
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, openIdUrl, username, fullName, email);
        this.clickLink("allow");
        this.assertAtClientProfilePage(openIdUrl, username, email, fullName);
    }

    private String getOpEndpointUrl() {
        return this.OPENID_SERVER_URL + "/op";
    }

    public void testServerSelectsIdentityForLoggedInUserWhenOpEndpointIsProvided() {
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.getOpEndpointUrl());
        this.setScriptingEnabled(true);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "Super User", "admin@example.com");
        this.clickLink("allow");
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
    }

    public void testServerSelectsIdentityForLoggedInUserWhenOpEndpointIsProvidedWithNonAdminUser() {
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.getOpEndpointUrl());
        this.setScriptingEnabled(true);
        this.submitAndAssertAtServerLoginPage();
        this.setTextField("username", "john.t\u00f8stin\u00f3g\u00e9");
        this.setTextField("password", "john");
        this.submit();
        String identity = this.OPENID_SERVER_URL + "/users/john.t%C3%B8stin%C3%B3g%C3%A9";
        this.assertAtServerAllowDenyPage(this.OPENID_CLIENT_REALM, identity, "john.t\u00f8stin\u00f3g\u00e9", "John T\u00f8stin\u00f3g\u00e9", "john@example.com");
        this.clickLink("allow");
        this.assertAtClientProfilePage(identity, "john.t\u00f8stin\u00f3g\u00e9", "john@example.com", "John T\u00f8stin\u00f3g\u00e9");
    }

    public void testServerSelectsIdentityForLoggedInUserWhenImmediateCheckIsMade() {
        this.establishApproveAlwaysForAdmin();
        this.gotoPage("/");
        this.assertAtClientLoginPage();
        this.setTextField("openid_identifier", this.getOpEndpointUrl());
        this.checkCheckbox("checkImmediate");
        this.setScriptingEnabled(true);
        this.submit();
        this.assertAtClientProfilePage(this.OPENIDSERVER_LOGIN_URL_ADMIN, "admin", "admin@example.com", "Super User");
        this.setScriptingEnabled(false);
    }

    public void testRequiredAttribsCorrectlyEscaped() throws UnsupportedEncodingException {
        String op = this.getOpEndpointUrl();
        String requiredAttribs = "<b>test</b>";
        String url = "/login!login.action?openid_identifier=" + URLEncoder.encode(op, "us-ascii") + "&requiredAttribs=" + requiredAttribs;
        String padding = "&requiredAttribs=" + StringUtils.repeat((char)'x', (int)2048);
        this.tester.setScriptingEnabled(false);
        this.gotoPage(url + padding);
        Assert.assertThat((Object)this.getPageSource(), (Matcher)CoreMatchers.not((Matcher)Matchers.containsString((String)"<b>test</b>")));
        Assert.assertThat((Object)this.getPageSource(), (Matcher)Matchers.containsString((String)"&lt;b&gt;test&lt;/b&gt;"));
    }

    public void testRequiredAttribsCorrectlyEscapedWhenRedirecting() throws MalformedURLException, IOException {
        String op = this.getOpEndpointUrl();
        String requiredAttribs = "<b>test</b>";
        String url = "/login!login.action?openid_identifier=" + URLEncoder.encode(op, "us-ascii") + "&requiredAttribs=" + requiredAttribs;
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getBaseUrl() + url).openConnection();
        connection.setInstanceFollowRedirects(false);
        OpenIDAuthenticationTest.assertEquals((int)302, (int)connection.getResponseCode());
        Assert.assertThat((Object)connection.getHeaderField("Location"), (Matcher)Matchers.containsString((String)"openid.sreg.required=%3Cb%3Etest%3C%2Fb%3E"));
    }

    public void testAbleToAuthenticateWithPlusInUsername() throws UnsupportedEncodingException {
        String serverUrl = this.OPENID_SERVER_URL + "/users/" + "user+tag";
        this.assertIsAbleToAuthenticate("user+tag", "user+tag", serverUrl, "user+tag@localhost", "User +Tag", "/users/user+tag");
    }
}

