/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.user;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCaseWithEmailServer;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class ResetPasswordTest
extends CrowdAcceptanceTestCaseWithEmailServer {
    private static final String USERNAME = "user";
    private static final String DIRECTORY_NAME = "Test Internal Directory";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("userconsoletest.xml");
        this._loginAdminUser();
        this._configureMailServer();
    }

    public void testUserCanLoginAfterResettingPassword() throws Exception {
        this.intendToModifyData();
        this._requestPasswordReset(USERNAME);
        this._logout();
        this._followResetLinkInEmail();
        this._resetPasswordTo("newPassword");
        this.assertKeyPresent("resetpassword.complete.label");
        this._loginAsUser(USERNAME, "newPassword");
    }

    public void testResetPasswordMaintainsPasswordHistory() throws Exception {
        this.intendToModifyData();
        this._loginAsUser(USERNAME, "password");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "password1");
        this.assertKeyPresent("passwordupdate.message");
        this._changePassword("password1", "password2");
        this.assertKeyPresent("passwordupdate.message");
        this._changePassword("password2", "password3");
        this.assertKeyPresent("passwordupdate.message");
        this._loginAdminUser();
        this._requestPasswordReset(USERNAME);
        this._logout();
        this._followResetLinkInEmail();
        this._resetPasswordTo("password2");
        this.assertKeyNotPresent("resetpassword.complete.label");
        this.assertTextPresent("Unable to update password since this password matches");
        this._resetPasswordTo("password3");
        this.assertKeyNotPresent("resetpassword.complete.label");
        this.assertTextPresent("Unable to update password since this password matches");
        this._resetPasswordTo("password1");
        this.assertKeyPresent("resetpassword.complete.label");
        this._loginAsUser(USERNAME, "password1");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password1", "password3");
        this.assertKeyNotPresent("passwordupdate.message");
        this.assertTextPresent("Unable to update password since this password matches");
        this._changePassword("password1", "password2");
        this.assertKeyPresent("passwordupdate.message");
    }

    public void testResetPasswordWithBadTokenShowsErrorMessage() {
        this._logout();
        long directoryId = 32769L;
        String queryWithBadToken = "username=user&directoryId=" + directoryId + "&token=bad-reset-password-token";
        this.gotoPage("/console/resetpassword.action?" + queryWithBadToken);
        this.assertKeyPresent("forgottenpassword.title");
        this.assertTextNotPresent("does not exist");
        this.assertKeyPresent("forgottenpassword.title");
        this.assertKeyPresent("forgottenlogindetails.error.expiredtoken");
    }

    private void _requestPasswordReset(String user) {
        this.gotoViewPrincipal(user, DIRECTORY_NAME);
        this.clickLink("reset-password-principal");
        this.submit();
    }

    private void _followResetLinkInEmail() throws InterruptedException, IOException, MessagingException {
        MimeMessage message = this.waitForExactlyOneMessage();
        Pattern pattern = Pattern.compile("/console/resetpassword\\.action\\?[\\S]+");
        Matcher matcher = pattern.matcher(message.getContent().toString());
        ResetPasswordTest.assertTrue((String)("Email message must contain reset link:" + message.getContent().toString()), (boolean)matcher.find());
        String url = matcher.group();
        this.gotoPage(url);
        this.assertKeyPresent("forgottenpassword.title");
    }

    private void _resetPasswordTo(String newPassword) {
        this.assertKeyPresent("forgottenpassword.title");
        this.setTextField("password", newPassword);
        this.setTextField("confirmPassword", newPassword);
        this.submit();
    }

    private void _changePassword(String oldPassword, String newPassword) {
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", oldPassword);
        this.setTextField("password", newPassword);
        this.setTextField("confirmPassword", newPassword);
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
    }
}

