/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.user;

import com.atlassian.crowd.acceptance.tests.applications.crowd.user.CrowdUserConsoleAcceptenceTestCase;

public class EditProfileTest
extends CrowdUserConsoleAcceptenceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.loadXmlOnSetUp("userconsoletest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testViewProfile() {
        this.log("Running testViewProfile");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertTextFieldEquals("firstname", "Test");
        this.assertTextFieldEquals("lastname", "User");
        this.assertTextFieldEquals("email", "user@example.com");
        this.assertTextPresent("user");
    }

    public void testUpdateProfileBlank() {
        this.log("Running testUpdateProfileBlank");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "");
        this.setTextField("lastname", "");
        this.setTextField("email", "");
        this.submit();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyPresent("principal.firstname.invalid");
        this.assertKeyPresent("principal.lastname.invalid");
        this.assertKeyPresent("principal.email.invalid");
    }

    public void testUpdateProfileBadEmail() {
        this.log("Running testUpdateProfileBadEmail");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.setTextField("email", "bad-email");
        this.submit();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyPresent("principal.email.invalid");
    }

    public void testUpdateProfileEmailWithTrailingWhitespace() {
        this.log("Running testUpdateProfileBadEmail");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.setTextField("email", " john@example.test ");
        this.submit();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyPresent("principal.email.whitespace");
    }

    public void testUpdateProfileSuccess() {
        this.intendToModifyData();
        this.log("Running testUpdateProfileSuccess");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "Test1");
        this.setTextField("lastname", "User1");
        this.setTextField("email", "user@example.com1");
        this.submit();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("firstname", "Test1");
        this.assertTextFieldEquals("lastname", "User1");
        this.assertTextFieldEquals("email", "user@example.com1");
    }

    public void testUpdateProfileCancel() {
        this.log("Running testUpdateProfileCancel");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "Test1");
        this.setTextField("lastname", "User1");
        this.setTextField("email", "user@example.com1");
        this.clickButton("cancel");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyNotPresent("updatesuccessful.label");
        this.assertTextFieldEquals("firstname", "Test");
        this.assertTextFieldEquals("lastname", "User");
        this.assertTextFieldEquals("email", "user@example.com");
    }

    public void testUpdateProfileNoPermissions() {
        this.log("Running testUpdateProfileNoPermissions");
        this._loginImmutableUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "Test1");
        this.setTextField("lastname", "User1");
        this.setTextField("email", "user@example.com1");
        this.submit();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyPresent("user.console.profile.permission.error");
    }

    public void testUpdateProfileSuccessAndLoginAgain() {
        this.intendToModifyData();
        this.log("Running testUpdateProfileSuccessAndLoginAgain");
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.setTextField("firstname", "Test1");
        this.setTextField("lastname", "User1");
        this.setTextField("email", "user@example.com1");
        this.submit();
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("firstname", "Test1");
        this.assertTextFieldEquals("lastname", "User1");
        this.assertTextFieldEquals("email", "user@example.com1");
        this._logout();
        this._loginTestUser();
        this.gotoPage("/console/user/viewprofile.action");
        this.assertKeyPresent("menu.user.console.editprofile.label");
        this.assertTextFieldEquals("firstname", "Test1");
        this.assertTextFieldEquals("lastname", "User1");
        this.assertTextFieldEquals("email", "user@example.com1");
    }
}

