/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import java.util.Properties;

public class ViewGroupLDAPTest
extends CrowdAcceptanceTestCase {
    private static final String DIRECTORY_NAME = "ApacheDS154";
    private static final long MAX_WAIT_FOR_SYNC_MS = 10000L;
    private static final String USER_NAME = "myUser";
    private static final String GROUP_NAME = "myGroup";
    private static final String SUB_GROUP_NAME = "mySubGroup";
    private static final String SUB_USER_NAME = "mySubUser";
    LDAPLoader loader;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loader = new LDAPLoader();
        this.loader.accessibleSetUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.loader.accessibleTearDown();
        this.loader = null;
        super.tearDown();
    }

    public void testViewNestedGroupMembers() {
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupMembers");
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-users", USER_NAME);
        this.assertTextNotInTable("view-group-users", SUB_USER_NAME);
        this.assertTextInTable("view-group-groups", SUB_GROUP_NAME);
        this.assertKeyPresent("group.nestedmembers.label");
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, DIRECTORY_NAME, 10000L);
    }

    public void testViewNestedGroupAllUsers() {
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupAllUsers");
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-nested-principals");
        this.assertTextInTable("view-group-nested-principals", USER_NAME);
        this.assertTextInTable("view-group-nested-principals", SUB_USER_NAME);
        this.assertTableNotPresent("view-group-groups");
        this.assertTextNotInTable("view-group-nested-principals", SUB_GROUP_NAME);
    }

    public void testViewNestedGroupMembersOnlyGroupsAssigned() throws Exception {
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupMembersOnlyGroupsAssigned");
        this.loader.removeGroupFromGroup();
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-groups", SUB_GROUP_NAME);
        this.assertKeyPresent("group.nestedmembers.label");
    }

    public void testViewNestedGroupAllMembersOnlyGroupsAssigned() throws Exception {
        this.intendToModifyData();
        this.log("Running: testViewNestedGroupAllMembersOnlyGroupsAssigned");
        this.loader.removeGroupFromGroup();
        this.synchroniseDirectory();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.clickLink("view-group-nested-principals");
        this.assertTextInTable("view-group-nested-principals", SUB_USER_NAME);
        this.assertTableNotPresent("view-group-groups");
        this.assertTextNotInTable("view-group-nested-principals", SUB_GROUP_NAME);
    }

    public void testViewGroupWithOneNonExistantMember() {
        this.log("Running: testViewGroupWithOneNonExistantMember");
        this.restoreCrowdFromXML("apachedsgrouptest.xml");
        DbCachingTestHelper.synchroniseDirectory(this.tester, "apacheds", 10000L);
        this.gotoViewGroup("groupA", "apacheds");
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-users", new String[]{"ldapusera", "ldapusera@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapuserb", "ldapuserb@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapuserc", "ldapuserc@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapuserd", "ldapuserd@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapusere", "ldapusere@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapuserf", "ldapuserf@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapuserg", "ldapuserg@testingarea.org", "true"});
        this.assertTextInTable("view-group-users", new String[]{"ldapuserh", "ldapuserh@testingarea.org", "true"});
    }

    class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.basedn", directorySettings.getProperty("test.integration.basedn"));
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.FALSE.toString());
        }

        @Override
        protected void loadTestData() throws Exception {
            UserTemplate user1 = new UserTemplate(ViewGroupLDAPTest.USER_NAME, this.directory.getId().longValue());
            user1.setFirstName("Bob");
            user1.setLastName("Smith");
            user1.setDisplayName("Bob Smith");
            user1.setEmailAddress("bob@example.com");
            this.getRemoteDirectory().addUser(user1, new PasswordCredential("password"));
            UserTemplate user2 = new UserTemplate(ViewGroupLDAPTest.SUB_USER_NAME, this.directory.getId().longValue());
            user2.setFirstName("Jane");
            user2.setLastName("Doe");
            user2.setDisplayName("Jane Doe");
            user2.setEmailAddress("jane@example.com");
            this.getRemoteDirectory().addUser(user2, new PasswordCredential("password"));
            GroupTemplate group = new GroupTemplate(ViewGroupLDAPTest.GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
            this.getRemoteDirectory().addGroup(group);
            GroupTemplate subGroup = new GroupTemplate(ViewGroupLDAPTest.SUB_GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
            this.getRemoteDirectory().addGroup(subGroup);
            this.getRemoteDirectory().addUserToGroup(ViewGroupLDAPTest.USER_NAME, ViewGroupLDAPTest.GROUP_NAME);
            this.getRemoteDirectory().addGroupToGroup(ViewGroupLDAPTest.SUB_GROUP_NAME, ViewGroupLDAPTest.GROUP_NAME);
            this.getRemoteDirectory().addUserToGroup(ViewGroupLDAPTest.SUB_USER_NAME, ViewGroupLDAPTest.SUB_GROUP_NAME);
        }

        @Override
        protected void removeTestData() throws DirectoryInstantiationException {
            DirectoryTestHelper.silentlyRemoveUserFromGroup(ViewGroupLDAPTest.USER_NAME, ViewGroupLDAPTest.GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroupFromGroup(ViewGroupLDAPTest.SUB_GROUP_NAME, ViewGroupLDAPTest.GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveUserFromGroup(ViewGroupLDAPTest.SUB_USER_NAME, ViewGroupLDAPTest.SUB_GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveUser(ViewGroupLDAPTest.USER_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveUser(ViewGroupLDAPTest.SUB_USER_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroup(ViewGroupLDAPTest.GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroup(ViewGroupLDAPTest.SUB_GROUP_NAME, this.getRemoteDirectory());
            this.sessionFactory.getCurrentSession().flush();
        }

        public void removeGroupFromGroup() throws Exception {
            this.getRemoteDirectory().removeUserFromGroup(ViewGroupLDAPTest.USER_NAME, ViewGroupLDAPTest.GROUP_NAME);
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

