/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.google.common.collect.Lists;

public class ViewDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String INTERNAL_DIRECTORY_NAME = "Second Directory";
    private static final String CROWD_DIRECTORY_NAME = "Remote Crowd Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_APACHEDS = "ApacheDS Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING = "ApacheDS Caching Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_GENERIC = "GenericLDAP Directory";
    private static final String CUSTOM_DIRECTORY_NAME = "Custom Directory";
    private static final String DELEGATED_DIRECTORY_NAME_APACHEDS = "ApacheDS Delegated Directory";
    private static final String DELEGATED_DIRECTORY_NAME_GENERIC = "Generic Delegated Directory";
    private static final String CONNECTOR_DIRECTORY_NAME_ACTIVE_DIRECTORY = "ActiveDirectory";
    private static final long ONE_MINUTE_IN_MILLIS = 60000L;
    private static final String INTERNAL_DIRECTORY_PASSWORD_COMPLEXITY_DESCRIPTION = "Test Complexity Description";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("viewdirectory.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testUpdateInternalDirectoryGeneralScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateInternalDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", INTERNAL_DIRECTORY_NAME);
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "Update Second Directory");
        this.setTextField("directoryDescription", "Update Second Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Second Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Second Directory Description");
    }

    public void testUpdateInternalDirectoryConfiguration() {
        this.intendToModifyData();
        this.log("Running: testUpdateInternalDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", INTERNAL_DIRECTORY_NAME);
        this.clickLink("internal-configuration");
        this.setWorkingForm("updateConfiguration");
        this.setTextField("passwordRegex", ".*");
        this.setTextField("passwordComplexityMessage", "AwesomeRegex");
        this.setTextField("passwordMaxAttempts", "10");
        this.setTextField("passwordMaxChangeTime", "15");
        this.setTextField("passwordHistoryCount", "20");
        this.submit();
        this.assertTextFieldEquals("passwordRegex", ".*");
        this.assertTextFieldEquals("passwordComplexityMessage", "AwesomeRegex");
        this.assertTextFieldEquals("passwordMaxAttempts", "10");
        this.assertTextFieldEquals("passwordMaxChangeTime", "15");
        this.assertTextFieldEquals("passwordHistoryCount", "20");
    }

    public void testUpdateInternalDirectoryPermissions() {
        this.intendToModifyData();
        this.log("Running: testUpdateInternalDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", INTERNAL_DIRECTORY_NAME);
        this.clickLink("internal-permissions");
        this.setWorkingForm("permissionForm");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.submit();
        this.setWorkingForm("permissionForm");
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
        this.setWorkingForm("permissionForm");
        this.checkCheckbox("permissionGroupAdd");
        this.checkCheckbox("permissionPrincipalAdd");
        this.submit();
        this.setWorkingForm("permissionForm");
        this.assertCheckboxSelected("permissionGroupAdd");
        this.assertCheckboxSelected("permissionPrincipalAdd");
    }

    public void testUpdateInternalDirectoryGeneralScreenError() {
        this.log("Running: testUpdateInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", INTERNAL_DIRECTORY_NAME);
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateInternalDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateInternalDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", INTERNAL_DIRECTORY_NAME);
        this.setTextField("name", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", DELEGATED_DIRECTORY_NAME_APACHEDS);
    }

    public void testUpdateInternalDirectoryConfigurationScreenErrors() {
        this.log("Running: testUpdateInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", INTERNAL_DIRECTORY_NAME);
        this.clickLink("internal-configuration");
        this.setWorkingForm("updateConfiguration");
        this.setTextField("passwordRegex", "[]");
        this.setTextField("passwordMaxAttempts", "-1");
        this.setTextField("passwordMaxChangeTime", "-2");
        this.setTextField("passwordHistoryCount", "-3");
        this.submit();
        this.assertTextPresent("Unclosed character class near index 1 [] ^");
        this.assertKeyPresent("directoryinternal.passwordmaxchangetime.invalid");
        this.assertKeyPresent("directoryinternal.passwordmaxattempts.invalid");
        this.assertKeyPresent("directoryinternal.passwordhistorycount.invalid");
    }

    public void testUpdateCrowdDirectoryGeneralScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateCrowdDirectoryGeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "Update Second Directory");
        this.setTextField("directoryDescription", "Update Second Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Second Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Second Directory Description");
    }

    public void testViewCrowdDirectorySynchroniseCache() throws Exception {
        this.intendToModifyData();
        this.log("running testViewCrowdDirectorySynchroniseCache");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("directory.caching.sync.never.label");
        DbCachingTestHelper.synchroniseDirectory(this.tester, CROWD_DIRECTORY_NAME, 60000L);
    }

    public void testUpdateCrowdDirectoryGeneralScreenError() {
        this.log("Running: testUpdateCrowdDirectoryGeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateCrowdDirectoryGeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateCrowdDirectoryGeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.setTextField("name", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", DELEGATED_DIRECTORY_NAME_APACHEDS);
    }

    public void testUpdateCrowdDirectoryConnectionScreen() {
        this.log("Running: testUpdateCrowdDirectoryConnectionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl() + "2");
        this.setTextField("applicationName", "jira2");
        this.setTextField("pollingIntervalInMin", "100");
        this.setTextField("httpTimeout", "12");
        this.setTextField("httpMaxConnections", "123");
        this.setTextField("httpProxyPort", "5432");
        this.setTextField("httpProxyUsername", "proxyuser");
        this.submit();
        this.assertTextFieldEquals("url", this.getBaseUrl() + "2");
        this.assertTextFieldEquals("applicationName", "jira2");
        this.assertTextFieldEquals("pollingIntervalInMin", "100");
        this.assertTextFieldEquals("httpTimeout", "12");
        this.assertTextFieldEquals("httpMaxConnections", "123");
        this.assertTextFieldEquals("httpProxyPort", "5432");
        this.assertTextFieldEquals("httpProxyUsername", "proxyuser");
    }

    public void testUpdateCrowdTestConnectionWithCredentials() {
        this.log("Running: testUpdateCrowdTestConnectionWithCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "jira");
        this.setTextField("applicationPassword", "password");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.success");
    }

    public void testUpdateCrowdTestConnectionInvalidNoPassword() {
        this.log("Running: testUpdateCrowdTestConnectionInvalidNoPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-connectiondetails");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.invalid");
    }

    public void testUpdateCrowdTestConnectionInvalidURL() {
        this.log("Running: testUpdateCrowdTestConnectionInvalidURL");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl() + "/invalidUrl");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.invalid");
    }

    public void testUpdateCrowdDirectoryConnectionScreenError() {
        this.log("Running: testUpdateCrowdDirectoryConnectionScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", "");
        this.setTextField("applicationName", "");
        this.submit();
        this.assertKeyPresent("directorycrowd.url.invalid");
        this.assertKeyPresent("directorycrowd.applicationname.invalid");
    }

    public void testUpdateCrowdDirectoryPermissionScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateCrowdDirectoryPermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
    }

    public void testUpdateConnectorDirectory_LocalUserStatusVisibleForActiveDirectory() {
        this.log("Running: testUpdateConnectorDirectory_LocalUserStatusVisibleForActiveDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_ACTIVE_DIRECTORY);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_ACTIVE_DIRECTORY);
        this.clickLink("connector-connectiondetails");
        this.assertCheckboxPresent("localUserStatusEnabled");
    }

    public void testUpdateConnectorDirectory_LocalUserStatusNotVisibleForDirectoriesOtherThanActiveDirectory() {
        this.log("Running: testUpdateConnectorDirectory_LocalUserStatusNotVisibleForDirectoriesOtherThanActiveDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.assertCheckboxNotPresent("localUserStatusEnabled");
    }

    public void testUpdateConnectorDirectory_GeneralScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_GeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "Update Second Directory");
        this.setTextField("directoryDescription", "Update Second Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Second Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Second Directory Description");
    }

    public void testViewConnectorDirectory_SynchroniseCache() throws Exception {
        this.intendToModifyData();
        this.log("running testViewConnectorDirectory_SynchroniseCache");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("directory.caching.sync.never.label");
        DbCachingTestHelper.synchroniseDirectory(this.tester, CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING, 60000L);
    }

    public void testUpdateConnectorDirectory_GeneralScreenError() {
        this.log("Running: testUpdateConnectorDirectory_GeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateConnectorDirectory_ExistingPasswordIsPreservedUnlessExplicitlyModified() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.submit();
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorDirectory_GeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateConnectorDirectory_GeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.setTextField("name", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", DELEGATED_DIRECTORY_NAME_APACHEDS);
    }

    public void testUpdateConnectorDirectory_ConnectionScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_ConnectionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.checkCheckbox("pagedResults");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
        this.assertCheckboxSelected("pagedResults");
    }

    public void testUpdateConnectorDirectory_ExistingPasswordIsNotRevealed() {
        this.log("Running: testUpdateConnectorDirectory_ExistingPasswordIsNotRevealed");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("ldapPassword", "");
    }

    public void testUpdateConnectorDirectory_NewPasswordIsRetainedAfterConnectionTest() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_NewPasswordIsRetainedAfterConnectionTest");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("ldapPassword", "invalid password");
        this.clickButton("test-connection");
        this.assertWarningPresent();
        this.assertTextPresent("LDAP: error code 49 - Bind failed");
        this.submit();
        this.assertWarningPresent();
        this.assertTextPresent("LDAP: error code 49 - Bind failed");
    }

    public void testUpdateConnectorDirectory_TestConnectionWithCredentials() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_TestConnectionWithCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorDirectory_TestConnectionWithAnonymousBind() {
        this.log("Running: testUpdateConnectorDirectory_TestConnectionWithAnonymousBind");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("userDN", "");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorDirectory_TestConnectionWithNoPasswordShouldUseTheSavedPassword() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_TestConnectionWithNoPasswordShouldUseTheSavedPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "");
        this.clickButton("test-connection");
        this.assertErrorNotPresent();
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorDirectory_TestConnectionWithoutAnyChanges() {
        this.log("Running: testUpdateConnectorDirectory_TestConnectionWithoutAnyChanges");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorDirectory_TestConnectionInvalidURL() {
        this.log("Running: testUpdateConnectorDirectory_TestConnectionInvalidURL");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateConnectorDirectory_TestConnectionInvalidUserDN() {
        this.log("Running: testUpdateConnectorDirectory_TestConnectionInvalidUserDN");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("userDN", "invalid user DN");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateConnectorDirectory_TestConnectionInvalidPassword() {
        this.log("Running: testUpdateConnectorDirectory_TestConnectionInvalidPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("ldapPassword", "invalid password");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateConnectorDirectory_PasswordIsForgottenWhenSwitchingToAnonymousBind() {
        this.log("Running: testUpdateConnectorDirectory_PasswordIsForgottenWhenSwitchingToAnonymousBind");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
        this.setTextField("userDN", "");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
        this.setTextField("ldapPassword", "secret");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateConnectorDirectory_ConnectionScreenWithPwdEncryption() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_ConnectionScreenWithPwdEncryption");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_GENERIC);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_GENERIC);
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.selectOption("userEncryptionMethod", "DES");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.checkCheckbox("useUserMembershipAttribute");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "DES");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
        this.assertCheckboxSelected("pagedResults");
        this.assertCheckboxSelected("useUserMembershipAttribute");
    }

    public void testUpdateConnectorDirectory_ConnectionScreenError() {
        this.log("Running: testUpdateConnectorDirectory_ConnectionScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid.blank");
    }

    public void testUpdateConnectorDirectory_ConnectionScreenErrorWithBadDn() {
        this.log("Running: testUpdateConnectorDirectory_ConnectionScreenErrorWithBadDn");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "invalid");
        this.submit();
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
    }

    public void testUpdateConnectorDirectory_ConfigurationScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_ConfigurationScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "1");
        this.setTextField("groupObjectClass", "2");
        this.setTextField("groupObjectFilter", "3");
        this.setTextField("groupNameAttr", "4");
        this.setTextField("groupDescriptionAttr", "5");
        this.setTextField("groupMemberAttr", "6");
        this.assertCheckboxNotPresent("rolesDisabled");
        this.setTextField("userDNaddition", "13");
        this.setTextField("userObjectClass", "14");
        this.setTextField("userObjectFilter", "15");
        this.setTextField("userNameAttr", "16");
        this.setTextField("userNameRdnAttr", "17");
        this.setTextField("userFirstnameAttr", "18");
        this.setTextField("userLastnameAttr", "19");
        this.setTextField("userMailAttr", "20");
        this.setTextField("userGroupMemberAttr", "21");
        this.setTextField("userPasswordAttr", "22");
        this.setTextField("userDisplayNameAttr", "23");
        this.submit();
        this.assertTextFieldEquals("groupDNaddition", "1");
        this.assertTextFieldEquals("groupObjectClass", "2");
        this.assertTextFieldEquals("groupObjectFilter", "3");
        this.assertTextFieldEquals("groupNameAttr", "4");
        this.assertTextFieldEquals("groupDescriptionAttr", "5");
        this.assertTextFieldEquals("groupMemberAttr", "6");
        this.assertCheckboxNotPresent("rolesDisabled");
        this.assertTextFieldEquals("userDNaddition", "13");
        this.assertTextFieldEquals("userObjectClass", "14");
        this.assertTextFieldEquals("userObjectFilter", "15");
        this.assertTextFieldEquals("userNameAttr", "16");
        this.assertTextFieldEquals("userNameRdnAttr", "17");
        this.assertTextFieldEquals("userFirstnameAttr", "18");
        this.assertTextFieldEquals("userLastnameAttr", "19");
        this.assertTextFieldEquals("userMailAttr", "20");
        this.assertTextFieldEquals("userGroupMemberAttr", "21");
        this.assertTextFieldEquals("userPasswordAttr", "22");
        this.assertTextFieldEquals("userDisplayNameAttr", "23");
    }

    public void testUpdateConnectorDirectory_ConfigurationScreenError() {
        this.log("Running: testUpdateConnectorDirectory_ConfigurationScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "");
        this.setTextField("groupObjectClass", "");
        this.setTextField("groupObjectFilter", "");
        this.setTextField("groupNameAttr", "");
        this.setTextField("groupDescriptionAttr", "");
        this.setTextField("groupMemberAttr", "");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userNameRdnAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userDisplayNameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.groupobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.groupobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.groupname.invalid");
        this.assertKeyPresent("directoryconnector.groupmember.invalid");
        this.assertKeyPresent("directoryconnector.groupdescription.invalid");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usernamerdnattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userdisplaynameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
    }

    public void testUpdateConnectorDirectory_ConfigurationSearchGroup() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_ConfigurationSearchGroup");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-configuration");
        this.setTextField("groupObjectClass", "groupOfNames");
        this.setTextField("groupObjectFilter", "(objectclass=groupOfNames)");
        this.setTextField("groupDNaddition", "");
        this.clickButton("test-search-group");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorDirectory_SearchPrincipal() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_SearchPrincipal");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-configuration");
        this.setTextField("userDNaddition", "");
        this.clickButton("test-search-principal");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorDirectory_SearchGroupInvalid() {
        this.log("Running: testUpdateConnectorDirectory_SearchGroupInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-configuration");
        this.setTextField("groupDNaddition", "ou=nonexistentgroup");
        this.clickButton("test-search-group");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorDirectory_SearchPrincipalInvalid() {
        this.log("Running: testUpdateConnectorDirectory_SearchPrincipalInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-configuration");
        this.setTextField("userDNaddition", "ou=nonexistentprincipal");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateConnectorDirectory_PermissionScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateConnectorDirectory_PermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
    }

    public void testUpdateDelegatedDirectory_GeneralScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_GeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.setTextField("name", "Update Delegated Directory");
        this.setTextField("directoryDescription", "Update Delegated Directory Description");
        this.submit();
        this.assertTextFieldEquals("name", "Update Delegated Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Delegated Directory Description");
    }

    public void testUpdateDelegatedDirectory_GeneralScreenError() {
        this.log("Running: testUpdateDelegatedDirectory_GeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateDelegatedDirectory_GeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateDelegatedDirectory_GeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", INTERNAL_DIRECTORY_NAME);
    }

    public void testUpdateDelegatedDirectory_ConnectionScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_ConnectionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertTextFieldEquals("ldapPassword", "");
        this.assertCheckboxNotSelected("secure");
        this.assertCheckboxNotSelected("referral");
        this.assertCheckboxNotSelected("updateUsers");
        this.assertCheckboxNotSelected("importGroups");
        this.setTextField("URL", "ldap://localhost:389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.checkCheckbox("updateUsers");
        this.checkCheckbox("importGroups");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
        this.assertCheckboxSelected("updateUsers");
        this.assertCheckboxSelected("importGroups");
    }

    public void testUpdateDelegatedDirectory_NestedGroupsCanBeEnabledAndDisabled() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_NestedGroupsCanBeEnabledAndDisabled");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.assertCheckboxNotSelected("useNestedGroups");
        this.checkCheckbox("useNestedGroups");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertCheckboxSelected("useNestedGroups");
        this.uncheckCheckbox("useNestedGroups");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertCheckboxNotSelected("useNestedGroups");
    }

    public void testUpdateDelegatedDirectory_ConnectionScreenWithPwdEncryption() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_ConnectionScreenWithPwdEncryption");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_GENERIC);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_GENERIC);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "ldap://localhost:389/");
        this.selectOption("userEncryptionMethod", "DES");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.checkCheckbox("secure");
        this.checkCheckbox("referral");
        this.submit();
        this.assertTextFieldEquals("URL", "ldap://localhost:389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "DES");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("secure");
        this.assertCheckboxSelected("referral");
    }

    public void testUpdateDelegatedDirectory_ConnectionScreenError() {
        this.log("Running: testUpdateDelegatedDirectory_ConnectionScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid.blank");
    }

    public void testUpdateDelegatedDirectory_ConnectionScreenInvalidPassword() {
        this.log("Running: testUpdateDelegatedDirectory_ConnectionScreenInvalidPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("ldapPassword", "invalid");
        this.submit();
        this.assertWarningPresent();
    }

    public void testUpdateDelegatedDirectory_TestConnectionWithCredentials() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_TestConnectionWithCredentials");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateDelegatedDirectory_TestConnectionWithAnonymousBind() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_TestConnectionWithAnonymousBind");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("userDN", "");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateDelegatedDirectory_TestConnectionWithNoPasswordShouldUseTheSavedPassword() {
        this.log("Running: testUpdateDelegatedDirectory_TestConnectionWithNoPasswordShouldUseTheSavedPassword");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateDelegatedDirectory_TestConnectionWithoutAnyChanges() {
        this.log("Running: testUpdateDelegatedDirectory_TestConnectionWithoutAnyChanges");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testUpdateDelegatedDirectory_TestConnectionInvalidURL() {
        this.log("Running: testUpdateDelegatedDirectory_TestConnectionInvalidURL");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-connectiondetails");
        this.setTextField("URL", "ldap://localhost:123/");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.invalid");
    }

    public void testUpdateDelegatedDirectory_SearchPrincipal() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_SearchPrincipal");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "");
        this.clickButton("test-search-principal");
        this.assertKeyNotPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateDelegatedDirectory_SearchPrincipalInvalid() {
        this.log("Running: testUpdateDelegatedDirectory_SearchPrincipalInvalid");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "ou=nonexistentprincipal");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testUpdateDelegatedDirectory_ConfigurationScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_ConfigurationScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "13");
        this.setTextField("userObjectClass", "14");
        this.setTextField("userObjectFilter", "15");
        this.setTextField("userNameAttr", "16");
        this.setTextField("userNameRdnAttr", "17");
        this.setTextField("userFirstnameAttr", "18");
        this.setTextField("userLastnameAttr", "19");
        this.setTextField("userMailAttr", "20");
        this.setTextField("userGroupMemberAttr", "21");
        this.setTextField("userDisplayNameAttr", "23");
        this.submit();
        this.assertTextFieldEquals("userDNaddition", "13");
        this.assertTextFieldEquals("userObjectClass", "14");
        this.assertTextFieldEquals("userObjectFilter", "15");
        this.assertTextFieldEquals("userNameAttr", "16");
        this.assertTextFieldEquals("userNameRdnAttr", "17");
        this.assertTextFieldEquals("userFirstnameAttr", "18");
        this.assertTextFieldEquals("userLastnameAttr", "19");
        this.assertTextFieldEquals("userMailAttr", "20");
        this.assertTextFieldEquals("userGroupMemberAttr", "21");
        this.assertTextFieldEquals("userDisplayNameAttr", "23");
    }

    public void testUpdateDelegatedDirectory_ConfigurationScreenError() {
        this.log("Running: testUpdateDelegatedDirectory_ConfigurationScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-configuration");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userNameRdnAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userDisplayNameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.submit();
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usernamerdnattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userdisplaynameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
    }

    public void testUpdateDelegatedDirectory_ConfigurationScreenWithoutGroupConfigurationNoErrors() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_ConfigurationScreenWithoutGroupConfigurationNoErrors");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-configuration");
        this.submit();
        this.assertKeyNotPresent("directoryconnector.update.invalid");
    }

    public void testUpdateDelegatedDirectory_PermissionScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateDelegatedDirectory_PermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.clickLink("delegated-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
    }

    public void testUpdateCustomDirectory_GeneralScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateCustomDirectory_GeneralScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.setTextField("name", "Update Custom Directory");
        this.setTextField("directoryDescription", "Update Custom Directory Description");
        this.uncheckCheckbox("active");
        this.submit();
        this.assertTextFieldEquals("name", "Update Custom Directory");
        this.assertTextFieldEquals("directoryDescription", "Update Custom Directory Description");
        this.assertCheckboxNotSelected("active");
    }

    public void testUpdateCustomDirectory_GeneralScreenError() {
        this.log("Running: testUpdateCustomDirectory_GeneralScreenError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.setTextField("name", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testUpdateCustomDirectory_GeneralScreenWithDuplicateDirectoryName() {
        this.log("Running: testUpdateCustomDirectory_GeneralScreenWithDuplicateDirectoryName");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("directory.name.nonunique.invalid", INTERNAL_DIRECTORY_NAME);
    }

    public void testUpdateCustomDirectory_AttributesAddNewAttribute() {
        this.intendToModifyData();
        this.log("Running: testUpdateCustomDirectory_AttributesAddNewAttribute");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.clickLink("custom-attributes");
        this.setTextField("attribute", "New Attribute");
        this.setTextField("value", "123");
        this.clickButton("add-attribute");
        this.assertTextInTable("attributesTable", new String[]{"New Attribute", "123"});
    }

    public void testUpdateCustomDirectory_AttributesWithError() {
        this.log("Running: testUpdateCustomDirectory_AttributesWithError");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.clickLink("custom-attributes");
        this.setTextField("attribute", "New Attribute");
        this.setTextField("value", "");
        this.clickButton("add-attribute");
        this.assertKeyPresent("directorycustom.attribute.invalid");
    }

    public void testUpdateCustomDirectory_AttributesRemovingAttribute() {
        this.intendToModifyData();
        this.log("Running: testUpdateCustomDirectory_AttributesRemovingAttribute");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.clickLink("custom-attributes");
        this.clickLink("remove-attribute-testattrib");
        this.assertTextNotInTable("attributesTable", new String[]{"testattrib"});
    }

    public void testUpdateCustomDirectory_PermissionScreen() {
        this.intendToModifyData();
        this.log("Running: testUpdateCustomDirectory_PermissionScreen");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", CUSTOM_DIRECTORY_NAME);
        this.clickLink("custom-permissions");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.submit();
        this.assertCheckboxNotSelected("permissionGroupAdd");
        this.assertCheckboxNotSelected("permissionPrincipalAdd");
    }

    public void testUpdatePagedResultsOnConnectorDirectoryWithInvalidAmount() {
        this.log("Running: testUpdatePagedResultsOnConnectorDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.uncheckCheckbox("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "");
        this.checkCheckbox("pagedResults");
        this.setTextField("pagedResultsSize", "99");
        this.submit();
        this.assertKeyPresent("directoryconnector.pagedresultscontrolsize.invalid");
    }

    public void testUpdatePagedResultsOnConnectorDirectoryWithValidAmount() {
        this.intendToModifyData();
        this.log("Running: testUpdatePagedResultsOnConnectorDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertKeyPresent("menu.viewdirectory.label", CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.clickLink("connector-connectiondetails");
        this.uncheckCheckbox("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "");
        this.checkCheckbox("pagedResults");
        this.setTextField("pagedResultsSize", "100");
        this.submit();
        this.assertKeyNotPresent("directoryconnector.pagedresultscontrolsize.invalid");
        this.assertTextFieldEquals("pagedResultsSize", "100");
    }

    public void testViewDelegatingNoGroupRoleDnOverlapWarning() {
        this.log("Running: testViewDelegatingNoGroupRoleDnOverlapWarning");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertWarningNotPresent();
    }

    public void testBaseDNMandatoryForNonGenericDirectory() {
        this.log("Running: testBaseDNMandatoryForAllExceptGeneric");
        this.attemptConfigureDirectoryWithEmptyBaseDN(CONNECTOR_DIRECTORY_NAME_APACHEDS);
        this.assertUnescapedKeyPresent("directoryconnector.basedn.invalid.blank");
    }

    public void testBaseDNNotMandatoryForGenericDirectory() {
        this.attemptConfigureDirectoryWithEmptyBaseDN(DELEGATED_DIRECTORY_NAME_APACHEDS);
        this.assertUnescapedKeyPresent("directoryconnector.basedn.invalid.blank");
    }

    public void testBaseDNNotMandatoryForGeneric() {
        this.attemptConfigureDirectoryWithEmptyBaseDN(CONNECTOR_DIRECTORY_NAME_GENERIC);
        this.assertUnescapedKeyNotPresent("directoryconnector.basedn.invalid.blank");
    }

    public void testBaseDNNotMandatoryForDelegatedGeneric() {
        this.attemptConfigureDirectoryWithEmptyBaseDN(DELEGATED_DIRECTORY_NAME_GENERIC);
        this.assertUnescapedKeyNotPresent("directoryconnector.basedn.invalid.blank");
    }

    private void attemptConfigureDirectoryWithEmptyBaseDN(String directoryName) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(directoryName);
        this.assertKeyPresent("menu.viewdirectory.label", directoryName);
        this.clickLinkWithExactText("Connector");
        this.setTextField("baseDN", "");
        this.submit();
    }

    @Override
    public void assertKeyPresent(String key, String ... args) {
        this.assertKeyPresent(key, Lists.newArrayList((Object[])args));
    }
}

