/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.Arrays;

public class UpdateApplicationDirectoryGroupTest
extends CrowdAcceptanceTestCase {
    private static final String APP_CROWD = "crowd";
    private static final String CROWD_ADMINISTRATORS = "crowd-administrators";
    private static final String GROUPA = "groupA";
    private static final String GROUPB = "groupB";
    private static final String GROUPC = "groupC";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        this.restoreCrowdFromXML("updateapplication_directorygroup.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testRemoveGroupsAllowAllAuthenticateTrue() {
        this.log("Running: testRemoveGroupsAllowAllAuthenticateTrue");
        this.gotoViewApplication(APP_CROWD);
        this.assertTextInElement("application-name", APP_CROWD);
        this.clickLink("application-groups");
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPA);
        this.clickLink("remove-groupC");
        this.assertKeyPresent("preventlockout.unassigngroup.label", Arrays.asList(GROUPC));
        this.assertMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
    }

    public void testRemoveNestedGroupLastAllowAllAuthenticateTrue() {
        this.log("Running: testNestedRemoveGroupLastAllowAllAuthenticateTrue");
        this._loginAsUser("user1", "password");
        this.gotoViewApplication(APP_CROWD);
        this.assertTextInElement("application-name", APP_CROWD);
        this.clickLink("application-groups");
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("preventlockout.unassigngroup.label", Arrays.asList(GROUPA));
        this.assertMatchInTable("groupsTable", GROUPA);
        this.clickButton("add-group");
    }

    public void testRemoveNestedGroupFirstAllowAllAuthenticateTrue() {
        this.log("Running: testNestedRemoveGroupFirstAllowAllAuthenticateTrue");
        this._loginAsUser("user1", "password");
        this.gotoViewApplication(APP_CROWD);
        this.assertTextInElement("application-name", APP_CROWD);
        this.clickLink("application-groups");
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPA);
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("preventlockout.unassigngroup.label", Arrays.asList(CROWD_ADMINISTRATORS));
        this.assertMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
    }

    public void testRemoveGroupsAllowAllAuthenticateFalse() {
        this.log("Running: testRemoveGroupsAllowAllAuthenticateFalse");
        this.gotoViewApplication(APP_CROWD);
        this.assertTextInElement("application-name", APP_CROWD);
        this.setAllowAllToAuthenticateToFalse();
        this.clickLink("application-groups");
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPA);
        this.clickLink("remove-groupC");
        this.assertKeyPresent("preventlockout.unassigngroup.label", Arrays.asList(GROUPC));
        this.assertMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
    }

    public void testRemoveNestedGroupLastAllowAllAuthenticateFalse() {
        this.log("Running: testNestedRemoveGroupLastAllowAllAuthenticateFalse");
        this._loginAsUser("user1", "password");
        this.gotoViewApplication(APP_CROWD);
        this.assertTextInElement("application-name", APP_CROWD);
        this.setAllowAllToAuthenticateToFalse();
        this.clickLink("application-groups");
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("preventlockout.unassigngroup.label", Arrays.asList(GROUPA));
        this.assertMatchInTable("groupsTable", GROUPA);
        this.clickButton("add-group");
    }

    public void testRemoveNestedGroupFirstAllowAllAuthenticateFalse() {
        this.log("Running: testNestedRemoveGroupFirstAllowAllAuthenticateFalse");
        this._loginAsUser("user1", "password");
        this.gotoViewApplication(APP_CROWD);
        this.assertTextInElement("application-name", APP_CROWD);
        this.setAllowAllToAuthenticateToFalse();
        this.clickLink("application-groups");
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPA);
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("preventlockout.unassigngroup.label", Arrays.asList(CROWD_ADMINISTRATORS));
        this.assertMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
    }

    public void testRemoveGroupsFromDemoAllowAllAuthenticateTrue() {
        this.log("Running: testRemoveGroupsAllowAllAuthenticateTrue");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.clickLink("application-groups");
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPA);
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
    }

    public void testRemoveGroupsFromDemoAllowAllAuthenticateFalse() {
        this.log("Running: testRemoveGroupsAllowAllAuthenticateFalse");
        this.gotoViewApplication("demo");
        this.assertTextInElement("application-name", "demo");
        this.setAllowAllToAuthenticateToFalse();
        this.clickLink("application-groups");
        this.clickLink("remove-crowd-administrators");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", CROWD_ADMINISTRATORS);
        this.clickLink("remove-groupA");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPA);
        this.clickLink("remove-groupC");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPC);
        this.clickLink("remove-groupB");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertNoMatchInTable("groupsTable", GROUPB);
    }

    private void setAllowAllToAuthenticateToFalse() {
        this.clickLink("application-directories");
        this.selectOptionByValue("directory1-allowAll", "false");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }
}

