/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class SynchroniseCrowdDirectoryTest
extends CrowdAcceptanceTestCase {
    protected static final String LOCAL_DIRECTORY_NAME = "Loop";
    private static final String REMOTE_DIRECTORY1_NAME = "Test Internal Directory";
    private static final String REMOTE_DIRECTORY2_NAME = "Test Second Internal Directory";
    private static final String APPLICATION_NAME = "loop";
    private static final long LOOP_APPLICATION_ID = 4L;
    private static final String HOST2_PATH = new BaseUrlFromProperties(specProperties).baseUrlFor("crowd2");
    private static final long MAX_SYNC_WAIT_TIME_MS = 60000L;
    private final SynchronisationMode expectedMode;
    private DbCachingTestHelper dbCachingTestHelper;

    public SynchroniseCrowdDirectoryTest() {
        this(SynchronisationMode.INCREMENTAL);
    }

    public SynchroniseCrowdDirectoryTest(SynchronisationMode expectedMode) {
        this.expectedMode = expectedMode;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.dbCachingTestHelper = new DbCachingTestHelper(this.tester);
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("crowdwithcrowd.xml");
        this.intendToModifyData();
        this._switchToCrowdAt(HOST2_PATH);
        this.restoreCrowdFromXML("crowdwithcrowdremote.xml");
        this.intendToModifyData();
        this._switchToCrowdAt(HOST_PATH);
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        this.dbCachingTestHelper = null;
        super.tearDown();
    }

    protected void _doInitialSync() {
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    private void _switchToCrowdAt(String hostPath) {
        this.getTestContext().setBaseUrl(hostPath);
        this.log("Switching to URL: " + hostPath);
        this._loginAdminUser();
    }

    public void testSynchroniseChanges_CreateUniqueActiveRemoteUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.checkCheckbox("active");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", REMOTE_DIRECTORY1_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("testuser", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("email", "testuser@atlassian.com");
        this.assertCheckboxSelected("active");
        this.assertTextInElement("firstname", "Test");
        this.assertTextInElement("lastname", "User");
    }

    public void testSynchroniseChanges_CreateUniqueInactiveRemoteUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.uncheckCheckbox("active");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", REMOTE_DIRECTORY1_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("testuser", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("email", "testuser@atlassian.com");
        this.assertCheckboxNotSelected("active");
        this.assertTextInElement("firstname", "Test");
        this.assertTextInElement("lastname", "User");
    }

    public void testSynchroniseChanges_CreateUniqueActiveLocalUser() {
        this._doInitialSync();
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.checkCheckbox("active");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", LOCAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("testuser", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("email", "testuser@atlassian.com");
        this.assertCheckboxSelected("active");
        this.assertTextInElement("firstname", "Test");
        this.assertTextInElement("lastname", "User");
    }

    public void testSynchroniseChanges_CreateUniqueInactiveLocalUser() {
        this._doInitialSync();
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.uncheckCheckbox("active");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", LOCAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("testuser", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("email", "testuser@atlassian.com");
        this.assertCheckboxNotSelected("active");
        this.assertTextInElement("firstname", "Test");
        this.assertTextInElement("lastname", "User");
    }

    public void testSynchroniseChanges_CreateMaskingUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddPrincipal();
        this.setTextField("email", "existinguser3@atlassian.com");
        this.setTextField("name", "existinguser3");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", REMOTE_DIRECTORY1_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("existinguser3");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser3", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "existinguser3@atlassian.com");
    }

    public void testSynchroniseChanges_CreateMaskedUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddPrincipal();
        this.setTextField("email", "existinguser1dir2@atlassian.com");
        this.setTextField("name", "existinguser1");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User in Dir 2");
        this.selectOption("directoryID", REMOTE_DIRECTORY2_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("existinguser1");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "existinguser1@atlassian.com");
    }

    public void testSynchroniseChanges_UpdateApplicationForcesFullSync() {
        this._switchToCrowdAt(HOST2_PATH);
        this._enableAliasingForApplication(APPLICATION_NAME);
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseChanges_ChangeUserAliasForcesFullSync() {
        this._switchToCrowdAt(HOST2_PATH);
        this._enableAliasingForApplication(APPLICATION_NAME);
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertNotNull((Object)this.synchroniseDirectory());
        this._switchToCrowdAt(HOST2_PATH);
        this._setUserAliasForApplication("existinguser1", "useralias", REMOTE_DIRECTORY1_NAME, 4L);
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("useralias", LOCAL_DIRECTORY_NAME);
        this.assertWarningAndErrorNotPresent();
        this.assertTextInElement("email", "existinguser1@atlassian.com");
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.assertWarningPresent();
    }

    public void testSynchroniseChanges_RemoveAliasedUserForcesFullSync() {
        this._switchToCrowdAt(HOST2_PATH);
        this._enableAliasingForApplication(APPLICATION_NAME);
        this._setUserAliasForApplication("existinguser1", "useralias", REMOTE_DIRECTORY1_NAME, 4L);
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertNotNull((Object)this.synchroniseDirectory());
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("remove-principal");
        this.setWorkingForm("remove-user-form");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.assertWarningPresent();
        this.gotoViewPrincipal("useralias", LOCAL_DIRECTORY_NAME);
        this.assertWarningPresent();
    }

    public void testSynchroniseChanges_RemoveUniqueRemoteUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("remove-principal");
        this.setWorkingForm("remove-user-form");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.assertWarningPresent();
    }

    public void testSynchroniseChanges_RemoveMaskingUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY1_NAME);
        this.clickLink("remove-principal");
        this.setWorkingForm("remove-user-form");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "existinguser2dir2@atlassian.com");
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"existinggroup2", "dir2group"}));
    }

    public void testSynchroniseChanges_RemoveMaskedUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY2_NAME);
        this.clickLink("remove-principal");
        this.setWorkingForm("remove-user-form");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "existinguser2@atlassian.com");
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"existinggroup2", "dir1group"}));
    }

    public void testSynchroniseChanges_UpdateUniqueRemoteUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("email", "updateduser@atlassian.com");
        this.uncheckCheckbox("active");
        this.setTextField("firstname", "Updated");
        this.setTextField("lastname", "Lastname");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "updateduser@atlassian.com");
        this.assertCheckboxNotSelected("active");
        this.assertTextFieldEquals("firstname", "Updated");
        this.assertTextFieldEquals("lastname", "Lastname");
    }

    public void testSynchroniseChanges_UpdateUniqueLocalUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST_PATH);
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("email", "updateduser@atlassian.com");
        this.uncheckCheckbox("active");
        this.setTextField("firstname", "Updated");
        this.setTextField("lastname", "Lastname");
        this.submit();
        this.assertErrorNotPresent();
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.assertTextFieldEquals("email", "updateduser@atlassian.com");
        this.assertCheckboxNotSelected("active");
        this.assertTextFieldEquals("firstname", "Updated");
        this.assertTextFieldEquals("lastname", "Lastname");
    }

    public void testSynchroniseChanges_UpdateMaskingUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY1_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("email", "updateduser@atlassian.com");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "updateduser@atlassian.com");
    }

    public void testSynchroniseChanges_UpdateMaskedUser() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY2_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("email", "updateduser@atlassian.com");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("email", "existinguser2@atlassian.com");
    }

    public void testSynchroniseChanges_CreateUniqueRemoteGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddGroup();
        this.setTextField("name", "test-group");
        this.setTextField("description", "Crowd Test Group");
        this.selectOption("directoryID", REMOTE_DIRECTORY1_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("test-group");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("test-group", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Crowd Test Group");
    }

    public void testSynchroniseChanges_CreateUniqueLocalGroup() {
        this._doInitialSync();
        this.gotoAddGroup();
        this.setTextField("name", "test-group");
        this.setTextField("description", "Crowd Test Group");
        this.selectOption("directoryID", LOCAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("test-group");
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("test-group", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Crowd Test Group");
    }

    public void testSynchroniseChanges_CreateMaskingGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddGroup();
        this.setTextField("name", "existinggroup3");
        this.setTextField("description", "Dir1");
        this.selectOption("directoryID", REMOTE_DIRECTORY1_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("existinggroup3");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.searchAllGroups();
        this.gotoViewGroup("existinggroup3", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Dir1");
    }

    public void testSynchroniseChanges_CreateMaskedGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoAddGroup();
        this.setTextField("name", "existinggroup1");
        this.setTextField("description", "Dir2");
        this.selectOption("directoryID", REMOTE_DIRECTORY2_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("existinggroup1");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup1", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Dir1");
    }

    public void testSynchroniseChanges_RemoveUniqueRemoteGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("dir1group", REMOTE_DIRECTORY1_NAME);
        this.clickLink("remove-group");
        this.setWorkingForm(0);
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("dir1group", LOCAL_DIRECTORY_NAME);
        this.assertWarningPresent();
    }

    public void testSynchroniseChanges_RemoveMaskingGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY1_NAME);
        this.clickLink("remove-group");
        this.setWorkingForm(0);
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Dir2");
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"sharedgroup", "dir2group"}));
        this.gotoViewGroup("existinggroup1", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTableNotPresent("view-group-groups");
    }

    public void testSynchroniseChanges_RemoveMaskedGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY2_NAME);
        this.clickLink("remove-group");
        this.setWorkingForm(0);
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Dir1");
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"sharedgroup", "dir1group"}));
        this.gotoViewGroup("existinggroup3", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTableNotPresent("view-group-groups");
    }

    public void testSynchroniseChanges_UpdateUniqueRemoteGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup1", REMOTE_DIRECTORY1_NAME);
        this.setWorkingForm("groupForm");
        this.setTextField("description", "Updated");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup1", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Updated");
    }

    public void testSynchroniseChanges_UpdateMaskingGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY1_NAME);
        this.setWorkingForm("groupForm");
        this.setTextField("description", "Updated");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Updated");
    }

    public void testSynchroniseChanges_UpdateMaskedGroup() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY2_NAME);
        this.setWorkingForm("groupForm");
        this.setTextField("description", "Updated");
        this.submit();
        this.assertErrorNotPresent();
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.assertTextInElement("description", "Dir1");
    }

    public void testSynchroniseChanges_CreateUniqueRemoteUserMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup2");
        this.submit("searchButton");
        this.waitForElementById("existinggroup2");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup2");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "existinggroup2");
    }

    public void testSynchroniseChanges_CreateMaskingUserMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "sharedgroup");
        this.submit("searchButton");
        this.waitForElementById("sharedgroup");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "sharedgroup");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dir1group", "dir2group", "existinggroup2", "sharedgroup"}));
    }

    public void testSynchroniseChanges_CreateMaskedUserMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY2_NAME);
        this.clickLink("user-groups-tab");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "sharedgroup");
        this.submit("searchButton");
        this.waitForElementById("sharedgroup");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "sharedgroup");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dir1group", "dir2group", "existinggroup2", "sharedgroup"}));
    }

    public void testSynchroniseChanges_RemoveUniqueRemoteUserMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup1");
        this.submit("searchButton");
        this.waitForElementById("existinggroup1");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup1");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dir1group"}));
    }

    public void testSynchroniseChanges_RemoveUniqueRemoteUserMembershipAndRecreateUniqueRemoteUserMembership() throws Exception {
        Preconditions.checkState((this.expectedMode == SynchronisationMode.INCREMENTAL ? 1 : 0) != 0);
        String groupName = "existinggroup1";
        String userName = "existinguser1";
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "existinggroup1");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup1");
        this.submit("searchButton");
        this.waitForElementById("existinggroup1");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup1");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.assertTextNotInTable("groupsTable", "existinggroup1");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup1");
        this.submit("searchButton");
        this.waitForElementById("existinggroup1");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup1");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this.gotoViewPrincipal("existinguser1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "existinggroup1");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((String)"Incremental synchronisation should fail due to CWD-3182 and fallback to a full synchronisation", (Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser1", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", "existinggroup1");
        SynchroniseCrowdDirectoryTest.assertEquals((String)"Subsequent synchronisations should be incremental again", (Object)this.expectedMode, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseChanges_RemoveMaskingUserMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY1_NAME);
        this.clickLink("user-groups-tab");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.submit("searchButton");
        this.waitForElementById("existinggroup2");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "dir1group");
        this.checkCheckbox("selectedEntityNames", "existinggroup2");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"existinggroup2", "dir2group"}));
    }

    public void testSynchroniseChanges_RemoveMaskedUserMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewPrincipal("existinguser2", REMOTE_DIRECTORY2_NAME);
        this.clickLink("user-groups-tab");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.submit("searchButton");
        this.waitForElementById("existinggroup2");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "dir2group");
        this.checkCheckbox("selectedEntityNames", "existinggroup2");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewPrincipal("existinguser2", LOCAL_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        Assert.assertThat(SynchroniseCrowdDirectoryTest.namesOf(this.getGroupTableContents()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"existinggroup2", "dir1group"}));
    }

    public void testSynchroniseChanges_CreateUniqueRemoteGroupMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("view-group-users");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup4");
        this.submit("searchButton");
        this.waitForElementById("existinggroup4");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup4");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this.assertTextPresent(this.getText("updatesuccessful.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup1", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"existinggroup2", "existinggroup4"}));
    }

    public void testSynchroniseChanges_CreateMaskingGroupMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY1_NAME);
        this.clickLink("view-group-users");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup4");
        this.submit("searchButton");
        this.waitForElementById("existinggroup4");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup4");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this.assertTextPresent(this.getText("updatesuccessful.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dir1group", "dir2group", "sharedgroup", "existinggroup4"}));
    }

    public void testSynchroniseChanges_CreateMaskedGroupMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY2_NAME);
        this.clickLink("view-group-users");
        this.clickButton("addGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup3");
        this.submit("searchButton");
        this.waitForElementById("existinggroup3");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup3");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this.assertTextPresent(this.getText("updatesuccessful.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"dir1group", "dir2group", "sharedgroup", "existinggroup3"}));
    }

    public void testSynchroniseChanges_RemoveUniqueRemoteGroupMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup1", REMOTE_DIRECTORY1_NAME);
        this.clickLink("view-group-users");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.setTextField("searchString", "existinggroup2");
        this.submit("searchButton");
        this.waitForElementById("existinggroup2");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "existinggroup2");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup1", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        this.assertTableNotPresent("view-group-groups");
    }

    public void testSynchroniseChanges_RemoveMaskedGroupMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY1_NAME);
        this.clickLink("view-group-users");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.submit("searchButton");
        this.waitForElementById("sharedgroup");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "sharedgroup");
        this.checkCheckbox("selectedEntityNames", "dir1group");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"sharedgroup", "dir2group"}));
    }

    public void testSynchroniseChanges_RemoveMaskingGroupMembership() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewGroup("existinggroup2", REMOTE_DIRECTORY2_NAME);
        this.clickLink("view-group-users");
        this.clickButton("removeGroups");
        this.waitForElementById("browseentities");
        this.setWorkingForm("browseentities");
        this.submit("searchButton");
        this.waitForElementById("sharedgroup");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames", "sharedgroup");
        this.checkCheckbox("selectedEntityNames", "dir2group");
        this.clickButtonWithText(this.getText("picker.removeselected.groups.label"));
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)this.expectedMode, (Object)this.synchroniseDirectory());
        this.gotoViewGroup("existinggroup2", LOCAL_DIRECTORY_NAME);
        this.clickLink("view-group-users");
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"sharedgroup", "dir1group"}));
    }

    public void testSynchroniseAll_ClientDirectoryConfigurationChanged() throws Exception {
        this._doInitialSync();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(LOCAL_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", Arrays.asList(LOCAL_DIRECTORY_NAME));
        this.clickButtonWithText(this.getText("update.label") + " \u00bb");
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseAll_ServerDirectoryConfigurationChanged() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(REMOTE_DIRECTORY2_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", Arrays.asList(REMOTE_DIRECTORY2_NAME));
        this.clickButtonWithText(this.getText("update.label") + " \u00bb");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseAll_ServerDirectoryDeleted() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(REMOTE_DIRECTORY2_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", Arrays.asList(REMOTE_DIRECTORY2_NAME));
        this.clickLinkWithKey("directory.remove.title");
        this.clickButtonWithText(this.getText("continue.label") + " \u00bb");
        this.assertKeyPresent("updatesuccessful.label");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseAll_ServerXMLRestored() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.restoreCrowdFromXML("crowdwithcrowdremote.xml");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseAll_ServerApplicationDirectoryAdded() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewApplication(APPLICATION_NAME);
        this.clickLink("application-directories");
        this.clickButton("add-directory");
        this.assertKeyPresent("updatesuccessful.label");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseAll_ServerApplicationDirectoryRemoved() throws Exception {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.gotoViewApplication(APPLICATION_NAME);
        this.clickLink("application-directories");
        this.clickLink("down-32769");
        this.assertKeyPresent("updatesuccessful.label");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    public void testSynchroniseAll_ServerApplicationHasUncachedDirectory() {
        this._doInitialSync();
        this._switchToCrowdAt(HOST2_PATH);
        this.restoreCrowdFromXML("crowdwithcrowdremoteuncached.xml");
        this._switchToCrowdAt(HOST_PATH);
        SynchroniseCrowdDirectoryTest.assertEquals((Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
        SynchroniseCrowdDirectoryTest.assertEquals((String)"Subsequent synchronisation was not full when application contains an uncache directory", (Object)SynchronisationMode.FULL, (Object)this.synchroniseDirectory());
    }

    private void searchAllGroups() {
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", LOCAL_DIRECTORY_NAME);
        this.submit();
    }

    private void _setUserAliasForApplication(String username, String alias, String directoryName, long applicationId) {
        this.gotoViewPrincipal(username, directoryName);
        this.clickLink("user-applications-tab");
        this.setTextField("alias-appid-" + applicationId, alias);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent(alias);
    }

    private void _enableAliasingForApplication(String applicationName) {
        this.gotoViewApplication(applicationName);
        this.clickLink("application-options");
        this.checkCheckbox("aliasingEnabled");
        this.submit();
    }

    private SynchronisationMode synchroniseDirectory() {
        return this.dbCachingTestHelper.synchroniseDirectory(LOCAL_DIRECTORY_NAME, 60000L).getMode();
    }

    private List<String> getGroupMemberGroupNames() {
        return this.scrapeTable("view-group-groups", (List<String>)ImmutableList.of((Object)"Group Name", (Object)"Description", (Object)"Active"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
    }
}

