/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.Arrays;
import java.util.Collections;

public class SetupCrowdTest
extends CrowdAcceptanceTestCase {
    private static final String USE_DEVELOPER_LICENSE_PROPERTY_KEY = "crowd.developer.license";

    public void testSetup() throws Exception {
        this.setScriptingEnabled(true);
        this._testAboutScreen();
        this._testLicenseScreen();
        this._testNoLicense();
        this._testInvalidLicense();
        this._testInvalidLicenseWithExpiredMaintence();
        this._testLicenseSuccess();
        this._testInstallScreen();
        this._testInstallNew();
        this._testDatabaseScreen();
        this._testDatabaseBlank();
        this._testDatabaseNothingSelected();
        this._testDatabaseDriverClassNotFound();
        this._testDatabaseDialectClassNotFound();
        this._testDatabaseJavascriptSelection();
        this._testDatabaseSelectEmbedded();
        this._testOptionsScreen();
        this._testOptionsBlank();
        this._testOptionsSessionTimeInvalid();
        this._testOptionsBaseURLInvalid();
        this._testOptionsBaseURLUnavailable();
        this._testOptionsSuccess();
        this._testMailServerScreen();
        this._testMailServerScreenSSLPort();
        this._testMailServerBlank();
        this._testMailServerInvalidEmail();
        this._testMailServerSuccess();
        this._testInternalDirectoryScreen();
        this._testInternalDirectoryBlank();
        this._testInternalDirectoryAllErrors();
        this._testInternalDirectorySuccess();
        this._testDefaultAdminScreen();
        this._testDefaultAdminBlank();
        this._testDefaultAdminUsernameAndEmailWithTrailingWhitespace();
        this._testDefaultAdminEmailAndPwConfirmErrors();
        this._testDefaultAdminSuccess();
        this._testConfigureIntegratedApps();
        this._testCompleteSetup();
        this.setScriptingEnabled(false);
        this._testConfigureIntegratedAppsPresent();
        this._testAboutScreen();
    }

    private void _testAboutScreen() {
        this.gotoPage("/about.jsp");
        this.assertKeyPresent("about.title");
    }

    private void _testLicenseScreen() {
        this.gotoPage("/");
        this.log("Running _testLicenseScreen");
        this.assertKeyPresent("license.title");
        this.assertKeyPresent("license.serverid.label");
    }

    private void _testNoLicense() {
        this.log("Running _testNoLicense");
        this.submit();
        this.assertKeyPresent("license.title");
        this.assertKeyPresent("license.serverid.label");
        this.assertKeyPresent("license.key.error.required");
    }

    private void _testInvalidLicense() {
        this.log("Running _testInvalidLicense");
        this.setTextField("key", "fake_license_key");
        this.submit();
        this.assertKeyPresent("license.title");
        this.assertKeyPresent("license.serverid.label");
        this.assertKeyPresent("license.key.error.invalid");
    }

    private void _testInvalidLicenseWithExpiredMaintence() {
        this.log("Running _testInvalidLicenseWithExpiredMaintence");
        this.setTextField("key", "AAABFw0ODAoPeNp9kFFLwzAQx9/zKQI+t7TbZGUQEJc4CnWdrlMRX2J607A0LZe0um9vu3UgPvh4x\n/1+97+7eoaSbqGh0ZTGk8VssrieUrEt6CSKEsLBKdSN17VlS6y/yrcF5dCBqRtAooZOKJXXHTCPL\nZAlghyGufTAesM8iJIgismytr6fW8sKmDISD+EBrL8ppTbHxkgLPlR1NQozrcA6KI4NnAAunkSWb\n8TjRSPue+4/j+ikaU9B2F4aB6QHrAcrrQLx3Wg8XgImY8AcP6TV7szwQUc3Jx/ZAnaAKWe3xWwVr\nHbpXfCSP8yDnL+mY+B1W70D5vudA3QsiMl4QQ9lKb9Uvxa31uhKeyjJpkX1KR38fdgPj3SKEjAsA\nhQDnIHlSx5Ug4jClePbHxCPTYAwnQIUeTzFHGkn0bRuxJZNK5uaXO7y+uU=X02e6");
        this.submit();
        this.assertKeyPresent("license.title");
        this.assertKeyPresent("license.serverid.label");
        this.assertKeyPresent("license.key.error.maintenance.expired");
    }

    private void _testLicenseSuccess() {
        this.log("Running _testLicenseSuccess");
        if (SetupCrowdTest.useDeveloperLicense()) {
            this.setTextField("key", "AAABgQ0ODAoPeNp1kstuwjAQRff5CktdB4XXAqQsIHELLS+RQCvUjWMGcBvsaJxA+fuaQNQkopJX1\n9d3zsz4aaokCSAhzQ5pdvutVr/dJTQISctxelbEjpFSjYngIDXQrUiFki6dhXS5WI4Dau2EPsAFC\nkd4ScB9Nhq9wGef+HCCWCWAFo/VCbBi83Kp4pplxwhwvltpQO12La7krsF4Kk7gppiBtciQH5gGn\n6XgXgltc5odq5Q7Y0dwfbqmk/mCLosb+pMIvOTPFu1R0Vc5OgA0OGPfHb70Qvtjte7Yb5vNyB46z\nXfrSyCrwL+OlwNCZQqYoNC1Xq/UlU6NEGcg+QNf0bIXZ9qkzdQWtOvUBp+nDHPpv6Jlwgd74phxE\ncXVRXl3sRI0ZcJUkMzQ1obGUZ23tQCjVF7fb80YV/JbqrO05rhnUmiWEw3SmGktmPwDKu/AQ8h99\nfXeKpedxb8raz5ojiLJC4WgUxLfYMhOIUnibC8k2Rak+jax8vv7Hy1Lv3FyG1gwLAIUHEP4zbqEf\n1DeOWKb7SpxQ1MEd8ACFGxZV5doE27OtsuNDT50k2xIhAozX02im");
        } else {
            this.setTextField("key", "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm");
        }
        this.submit();
        this.assertKeyNotPresent("license.title");
    }

    public static boolean useDeveloperLicense() {
        return Boolean.parseBoolean(System.getProperty(USE_DEVELOPER_LICENSE_PROPERTY_KEY));
    }

    private void _testInstallScreen() {
        this.log("Running _testInstallScreen");
        this.assertKeyPresent("install.title");
        this.assertKeyPresent("install.new.label");
        this.assertKeyPresent("install.upgrade.xml.label");
        this.assertKeyNotPresent("install.upgrade.db.label");
    }

    private void _testInstallNew() {
        this.log("Running _testInstallNew");
        this.clickRadioOption("installOption", "install.new");
        this.submit();
        this.assertKeyNotPresent("install.title");
    }

    private void _testDatabaseScreen() {
        this.log("Running _testDatabaseScreen");
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.embedded.label");
        this.assertKeyPresent("database.jdbc.label");
        this.assertKeyPresent("database.datasource.label");
    }

    private void _testDatabaseNothingSelected() {
        this.log("Running _testDatabaseNothingSelected");
        this.clickRadioOption("databaseOption", "db.jdbc");
        this.selectOptionByValue("jdbcDatabaseType", "other");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.driver.blank");
        this.assertKeyPresent("database.jdbc.url.blank");
        this.assertKeyPresent("database.username.blank");
        this.assertKeyPresent("database.dialect.blank");
        this.clickRadioOption("databaseOption", "db.datasource");
        this.selectOptionByValue("datasourceDatabaseType", "other");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.jndi.blank");
        this.assertKeyPresent("database.dialect.blank");
    }

    private void _testDatabaseBlank() {
        this.log("Running _testDatabaseBlank");
        this.clickRadioOption("databaseOption", "db.jdbc");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.select.blank");
        this.clickRadioOption("databaseOption", "db.datasource");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.select.blank");
    }

    private void _testDatabaseDriverClassNotFound() {
        this.log("Running _testDatabaseDriverClassNotFound");
        this.clickRadioOption("databaseOption", "db.jdbc");
        this.setTextField("jdbcDriverClassName", "some.non.existent.Driver");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.driver.notfound");
    }

    private void _testDatabaseDialectClassNotFound() {
        this.log("Running _testDatabaseDialectClassNotFound");
        this.clickRadioOption("databaseOption", "db.jdbc");
        this.setTextField("jdbcDriverClassName", "some.non.existent.Dialect");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.dialect.notfound");
        this.clickRadioOption("databaseOption", "db.datasource");
        this.setTextField("jdbcHibernateDialect", "some.non.existent.Dialect");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyNotPresent("database.dialect.notfound");
        this.clickRadioOption("databaseOption", "db.datasource");
        this.setTextField("datasourceHibernateDialect", "some.non.existent.Dialect");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertKeyPresent("database.dialect.notfound");
    }

    private void _testDatabaseJavascriptSelection() {
        this.log("Running _testDatabaseJavascriptSelection");
        this.clickRadioOption("databaseOption", "db.jdbc");
        this.selectOptionByValue("jdbcDatabaseType", "postgresql");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertTextFieldEquals("jdbcDriverClassName", "org.postgresql.Driver");
        this.assertTextFieldEquals("jdbcUrl", "jdbc:postgresql://localhost:5432/crowd");
        this.assertTextFieldEquals("jdbcHibernateDialect", "org.hibernate.dialect.PostgreSQLDialect");
        this.clickRadioOption("databaseOption", "db.datasource");
        this.selectOptionByValue("datasourceDatabaseType", "mysql");
        this.submit();
        this.assertKeyPresent("database.title");
        this.assertTextFieldEquals("datasourceHibernateDialect", "org.hibernate.dialect.MySQL5InnoDBDialect");
    }

    private void _testDatabaseSelectEmbedded() {
        this.log("Running _testDatabaseSelectEmbedded");
        this.clickRadioOption("databaseOption", "db.embedded");
        this.submit();
        this.assertKeyNotPresent("database.title");
    }

    private void _testOptionsScreen() {
        this.log("Running _testOptionsScreen");
        this.assertKeyPresent("options.title");
        this.assertKeyPresent("options.title.label");
        this.assertKeyPresent("session.sessiontime.label");
    }

    private void _testOptionsBlank() {
        this.log("Running _testOptionsBlank");
        this.setTextField("title", "");
        this.setTextField("sessionTime", "");
        this.setTextField("baseURL", "");
        this.submit();
        this.assertKeyPresent("options.title.invalid");
        this.assertKeyPresent("options.base.url.invalid", Collections.singletonList(HOST_PATH));
        this.assertKeyPresent("session.sessiontime.invalid");
    }

    private void _testOptionsSessionTimeInvalid() {
        this.log("Running _testOptionsSessionTimeInvalid");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "-1");
        this.submit();
        this.assertKeyNotPresent("options.title.invalid");
        this.assertKeyPresent("session.sessiontime.invalid");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "-muhahaha!");
        this.submit();
        this.assertKeyNotPresent("options.title.invalid");
        this.assertKeyPresent("session.sessiontime.invalid");
    }

    private void _testOptionsBaseURLInvalid() {
        this.log("Running _testOptionsbaseURLInvalid");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "20");
        this.setTextField("baseURL", HOST_PATH + "\\\\");
        this.submit();
        this.assertKeyNotPresent("options.title.invalid");
        this.assertKeyNotPresent("session.sessiontime.invalid");
        this.assertKeyPresent("options.base.url.invalid", Collections.singletonList(HOST_PATH));
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "-muhahaha!");
        this.submit();
        this.assertKeyNotPresent("options.title.invalid");
        this.assertKeyPresent("session.sessiontime.invalid");
    }

    private void _testOptionsBaseURLUnavailable() {
        this.log("Running _testOptionsbaseURLInvalid");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "20");
        this.setTextField("baseURL", HOST_PATH + "/not-there");
        this.submit();
        this.assertKeyNotPresent("options.title.invalid");
        this.assertKeyNotPresent("session.sessiontime.invalid");
        this.assertKeyPresent("options.base.url.unavailable", Arrays.asList("404", HOST_PATH));
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "-muhahaha!");
        this.submit();
        this.assertKeyNotPresent("options.title.invalid");
        this.assertKeyPresent("session.sessiontime.invalid");
    }

    private void _testOptionsSuccess() {
        this.log("Running _testOptionsSuccess");
        this.setTextField("title", "Test Deployment");
        this.setTextField("sessionTime", "20");
        this.setTextField("baseURL", HOST_PATH);
        this.submit();
        this.assertKeyNotPresent("options.title");
    }

    private void _testMailServerScreen() {
        this.log("Running _testMailServerScreen");
        this.assertKeyPresent("mailserver.title");
        this.assertKeyPresent("mailserver.postpone.question.label");
        this.assertKeyPresent("mailserver.postpone.during.setup1");
        this.assertKeyPresent("mailserver.postpone.during.setup2");
        this.assertKeyNotPresent("mailserver.notification.label");
        this.assertKeyNotPresent("mailserver.from.label");
        this.assertKeyNotPresent("mailserver.prefix.label");
        this.assertKeyNotPresent("mailserver.host.label");
        this.assertKeyNotPresent("mailserver.jndilocation.label");
        this.clickRadioOption("postponeConfiguration", "false");
        this.assertKeyNotPresent("mailserver.postpone.during.setup1");
        this.assertKeyNotPresent("mailserver.postpone.during.setup2");
        this.assertKeyPresent("mailserver.notification.label");
        this.assertKeyPresent("mailserver.from.label");
        this.assertKeyPresent("mailserver.prefix.label");
        this.assertKeyPresent("mailserver.host.label");
        this.assertKeyPresent("mailserver.username.label");
        this.assertKeyPresent("mailserver.password.label");
    }

    private void _testMailServerScreenSSLPort() {
        this.log("Running _testMailServerScreenSSLPort");
        this.checkCheckbox("useSSL");
        this.assertTextInElement("port", "465");
        this.uncheckCheckbox("useSSL");
        this.assertTextInElement("port", "25");
    }

    private void _testMailServerBlank() {
        this.log("Running _testMailServerBlank");
        this.submit();
        this.assertKeyPresent("mailserver.notification.invalid");
        this.assertKeyPresent("mailserver.from.invalid");
        this.assertKeyPresent("mailserver.host.invalid");
        this.clickRadioOption("jndiMailActive", "true");
        this.assertRadioOptionSelected("jndiMailActive", "true");
        this.submit();
        this.assertKeyPresent("mailserver.jndiLocation.invalid");
    }

    private void _testMailServerInvalidEmail() {
        this.log("Running _testMailServerInvalidEmail");
        this.setTextField("notificationEmail", "invalid");
        this.setTextField("host", "localhost");
        this.setTextField("from", "invalid");
        this.submit();
        this.assertKeyPresent("mailserver.notification.invalid");
        this.assertKeyPresent("mailserver.from.invalid");
        this.assertKeyNotPresent("mailserver.host.invalid");
    }

    private void _testMailServerSuccess() {
        this.log("Running _testMailServerSuccess");
        this.clickRadioOption("jndiMailActive", "false");
        this.setTextField("notificationEmail", "user@example.com");
        this.setTextField("host", "localhost");
        this.setTextField("from", "security@example.com");
        this.submit();
        this.assertKeyNotPresent("mailserver.notification.label");
    }

    private void _testInternalDirectoryScreen() {
        this.log("Running _testInternalDirectoryScreen");
        this.assertSelectedOptionEquals("userEncryptionMethod", "ATLASSIAN-SECURITY");
        this.assertKeyPresent("directoryinternal.title");
        this.assertKeyPresent("directoryinternal.name.label");
        this.assertKeyPresent("directoryinternal.description.label");
        this.assertKeyPresent("directoryinternal.passwordmaxchangetime.label");
        this.assertKeyPresent("directoryinternal.passwordmaxattempts.label");
        this.assertKeyPresent("directoryinternal.passwordhistorycount.label");
        this.assertKeyPresent("directoryinternal.passwordregex.label");
        this.assertKeyPresent("directoryinternal.passwordcomplexity.help.label");
        this.assertKeyPresent("directoryconnector.userencryptionmethod.label");
    }

    private void _testInternalDirectoryBlank() {
        this.log("Running _testInternalDirectoryBlank");
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.setTextField("passwordRegex", "");
        this.setTextField("passwordComplexityMessage", "");
        this.setTextField("passwordMaxAttempts", "");
        this.setTextField("passwordMaxChangeTime", "");
        this.setTextField("passwordHistoryCount", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.assertKeyNotPresent("directoryinternal.passwordmaxchangetime.invalid");
        this.assertKeyNotPresent("directoryinternal.passwordmaxattempts.invalid");
        this.assertKeyNotPresent("directoryinternal.passwordhistorycount.invalid");
        this.assertKeyNotPresent("directoryinternal.passwordregex.invalid");
    }

    private void _testInternalDirectoryAllErrors() {
        this.log("Running _testInternalDirectoryAllErrors");
        this.setTextField("name", "");
        this.setTextField("description", "blah");
        this.setTextField("passwordRegex", "?");
        this.setTextField("passwordMaxAttempts", "-1");
        this.setTextField("passwordMaxChangeTime", "-1");
        this.setTextField("passwordHistoryCount", "-1");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.assertKeyPresent("directoryinternal.passwordmaxchangetime.invalid");
        this.assertKeyPresent("directoryinternal.passwordmaxattempts.invalid");
        this.assertKeyPresent("directoryinternal.passwordhistorycount.invalid");
        this.assertTextPresent("Dangling meta");
    }

    private void _testInternalDirectorySuccess() {
        this.log("Running _testInternalDirectorySuccess");
        this.setTextField("name", "Test Internal Directory");
        this.setTextField("description", "");
        this.setTextField("passwordRegex", "");
        this.setTextField("passwordComplexityMessage", "");
        this.setTextField("passwordMaxAttempts", "");
        this.setTextField("passwordMaxChangeTime", "");
        this.setTextField("passwordHistoryCount", "");
        this.selectOptionByValue("userEncryptionMethod", "atlassian-security");
        this.submit();
        this.assertKeyNotPresent("directoryinternal.title");
    }

    private void _testDefaultAdminScreen() {
        this.log("Running _testDefaultAdminScreen");
        this.assertKeyPresent("defaultadmin.title");
        this.assertKeyPresent("principal.name.label");
        this.assertKeyPresent("principal.password.label");
        this.assertKeyPresent("principal.passwordconfirm.label");
        this.assertKeyPresent("principal.firstname.label");
        this.assertKeyPresent("principal.lastname.label");
        this.assertKeyPresent("principal.email.label");
    }

    private void _testDefaultAdminBlank() {
        this.log("Running _testDefaultAdminBlank");
        this.setTextField("name", "");
        this.setTextField("email", "");
        this.setTextField("firstname", "");
        this.setTextField("lastname", "");
        this.submit();
        this.assertKeyPresent("principal.name.invalid");
        this.assertKeyPresent("principal.password.invalid");
        this.assertKeyPresent("principal.firstname.invalid");
        this.assertKeyPresent("principal.lastname.invalid");
        this.assertKeyPresent("principal.email.invalid");
    }

    private void _testDefaultAdminUsernameAndEmailWithTrailingWhitespace() {
        this.log("Running _testDefaultAdminUsernameAndEmailWithTrailingWhitespace");
        this.setTextField("email", " john@example.test ");
        this.setTextField("name", " admin ");
        this.submit();
        this.assertKeyPresent("invalid.whitespace");
        this.assertKeyPresent("principal.email.whitespace");
    }

    private void _testDefaultAdminEmailAndPwConfirmErrors() {
        this.log("Running _testDefaultAdminEmailAndPwConfirmErrors");
        this.setTextField("email", "fake");
        this.setTextField("name", "admin");
        this.setTextField("password", "admin");
        this.setTextField("passwordConfirm", "not same");
        this.setTextField("firstname", "Super");
        this.setTextField("lastname", "User");
        this.submit();
        this.assertKeyPresent("principal.passwordconfirm.nomatch");
        this.assertKeyPresent("principal.email.invalid");
    }

    private void _testDefaultAdminSuccess() {
        this.log("Running _testDefaultAdminSuccess");
        this.setTextField("email", "admin@example.com");
        this.setTextField("name", "admin");
        this.setTextField("password", "admin");
        this.setTextField("passwordConfirm", "admin");
        this.setTextField("firstname", "Super");
        this.setTextField("lastname", "User");
        this.submit();
        this.assertKeyNotPresent("defaultadmin.title");
    }

    private void _testConfigureIntegratedApps() {
        this.log("Running _testConfigureIntegratedApps");
        this.assertKeyPresent("integration.title");
        this.setRadioButton("configureOpenIDServer", Boolean.TRUE.toString());
        this.setRadioButton("configureDemoApp", Boolean.FALSE.toString());
        this.submit();
    }

    private void _testCompleteSetup() {
        this.log("Running _testCompleteSetup");
        this.assertKeyPresent("login.title");
        this.assertKeyPresent("setupcomplete.text", "admin");
    }

    private void _testConfigureIntegratedAppsPresent() {
        this.log("Running _testConfigureIntegratedAppsPresent");
        this._loginAdminUser();
        this.gotoBrowseApplications();
        this.assertTextNotPresent("demo");
        this.assertTextPresent("crowd-openid-server");
        this.assertTextPresent("google-apps");
    }
}

