/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import java.util.Properties;

public class RemoveGroupLDAPTest
extends CrowdAcceptanceTestCase {
    private static final String DIRECTORY_NAME = "ApacheDS154";
    private static final long MAX_WAIT_TIME_MS = 10000L;
    private static final String GROUP_NAME = "myGroup";
    private static final String SUB_GROUP_NAME = "mySubGroup";
    LDAPLoader loader = new LDAPLoader();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loader.accessibleSetUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
        this.synchroniseDirectory();
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, DIRECTORY_NAME, 10000L);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.loader.accessibleTearDown();
    }

    public void testRemoveRemoteGroupWhenLocalGroupsAreDisabled() {
        this.log("Running testRemoveRemoteGroupWhenLocalGroupsAreDisabled");
        this.intendToModifyData();
        this.intendToModifyLdapData();
        this.disableLocalGroups();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent(GROUP_NAME);
        this.clickLink("remove-group");
        this.assertKeyPresent("group.remove.text");
        this.assertTextPresent(GROUP_NAME);
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotPresent(GROUP_NAME);
    }

    public void testRemoveRemoteGroupWhenLocalGroupsAreEnabledShouldFail() {
        this.log("Running testRemoveRemoteGroupWhenLocalGroupsAreEnabledShouldFail");
        this.intendToModifyData();
        this.enableLocalGroups();
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent(GROUP_NAME);
        this.clickLink("remove-group");
        this.assertKeyPresent("group.remove.text");
        this.assertTextPresent(GROUP_NAME);
        this.submit();
        this.assertWarningPresent();
        this.assertTextPresent("Group <myGroup> is read-only and cannot be updated");
        this.gotoViewGroup(GROUP_NAME, DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent(GROUP_NAME);
    }

    private void enableLocalGroups() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DIRECTORY_NAME);
        this.clickLink("connector-connectiondetails");
        this.checkCheckbox("localGroupsEnabled");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertCheckboxSelected("localGroupsEnabled");
    }

    private void disableLocalGroups() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DIRECTORY_NAME);
        this.clickLink("connector-connectiondetails");
        this.uncheckCheckbox("localGroupsEnabled");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertCheckboxNotSelected("localGroupsEnabled");
    }

    class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.basedn", directorySettings.getProperty("test.integration.basedn"));
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.FALSE.toString());
        }

        @Override
        protected void loadTestData() throws Exception {
            GroupTemplate group = new GroupTemplate(RemoveGroupLDAPTest.GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
            this.getRemoteDirectory().addGroup(group);
            GroupTemplate subGroup = new GroupTemplate(RemoveGroupLDAPTest.SUB_GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
            this.getRemoteDirectory().addGroup(subGroup);
            this.getRemoteDirectory().addGroupToGroup(RemoveGroupLDAPTest.SUB_GROUP_NAME, RemoveGroupLDAPTest.GROUP_NAME);
        }

        @Override
        protected void removeTestData() throws DirectoryInstantiationException {
            DirectoryTestHelper.silentlyRemoveGroup(RemoveGroupLDAPTest.GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroup(RemoveGroupLDAPTest.SUB_GROUP_NAME, this.getRemoteDirectory());
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

