/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class DirectoryPermissionUserTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("directorypermissionusertest.xml");
    }

    public void testUnableToAddUser() {
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "newtestuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyNotPresent("menu.viewprincipal.label");
        this.assertTextPresent("Directory does not allow adding of users");
    }

    public void testUnableToModifyUser() {
        this.gotoViewPrincipal("testuser", "Test Internal Directory");
        this.setTextField("email", "newemailaddress@atlassian.com");
        this.submit();
        this.assertTextPresent("Directory does not allow user modification");
    }

    public void testUnableToRemoveUser() {
        this.gotoViewPrincipal("testuser", "Test Internal Directory");
        this.clickLink("remove-principal");
        this.setWorkingForm("remove-user-form");
        this.submit();
        this.assertTextPresent("Directory does not allow user removal");
    }
}

