/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class DirectoryPermissionGroupTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("directorypermissiongrouptest.xml");
    }

    public void testUnableToModifyGroup() {
        this.gotoViewGroup("tester-group", "Test Internal Directory");
        this.setWorkingForm("groupForm");
        this.setTextField("description", "A new Group description");
        this.submit();
        this.assertTextPresent("Directory does not allow group modifications");
    }

    public void testUnableToModifyGroupMembers() {
        this.gotoViewGroup("tester-group", "Test Internal Directory");
        this.clickLink("view-group-users");
        this.assertButtonNotPresent("removeUsers");
        this.assertKeyPresent("group.modify.disabled");
    }

    public void testUnableToDeleteGroup() {
        this.gotoViewGroup("tester-group", "Test Internal Directory");
        this.clickLink("remove-group");
        this.submit();
        this.assertTextPresent("Directory does not allow group removal");
    }

    public void testUnableToAddGroup() {
        this.gotoAddGroup();
        this.setTextField("name", "tester-group-to-add");
        this.setTextField("description", "Crowd Acceptance Test Group");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertTextPresent("Directory does not allow adding of groups");
    }
}

