/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;

public class DirectoryConfigurationReadFromFileTest
extends CrowdAcceptanceTestCase {
    public static final String DIRECTORY_TABLE_ID = "directory-table";
    public static final ImmutableList<String> DIRECTORY_TABLE_HEADERS = ImmutableList.of((Object)"Name", (Object)"Active", (Object)"Type", (Object)"Action");
    public static final Function<List<String>, String> MAP_DIRECTORY_NAME = new Function<List<String>, String>(){

        public String apply(@Nullable List<String> input) {
            return input.get(0);
        }
    };

    public void testBrowseAllDirectories() {
        this.log("Running: testBrowseAllDirectories");
        this._loginAdminUser();
        this.gotoBrowseDirectories();
        List<String> directories = this.scrapeTable(DIRECTORY_TABLE_ID, (List<String>)DIRECTORY_TABLE_HEADERS, MAP_DIRECTORY_NAME);
        Assert.assertThat(directories, (Matcher)IsCollectionContaining.hasItems((Object[])new String[]{"Directory One From File", "Directory Two From File"}));
    }

    public void testFilterDirectoriesByName() {
        this.log("Running: testFilterDirectoriesByName");
        this._loginAdminUser();
        this.gotoBrowseDirectories();
        this.setTextField("name", "One");
        this.submit();
        this.assertWarningPresent();
    }

    public void testCannotAddNewDirectory() {
        this.log("Running: testCannotAddNewDirectory");
        this._loginAdminUser();
        this.gotoCreateDirectory();
        this.clickButton("create-internal");
        this.setWorkingForm("directoryinternal");
        this.setTextField("name", "New directory");
        this.submit();
        this.assertWarningPresent();
    }

    public void testCannotUpdateDirectory() {
        this.log("Running: testCannotAddNewDirectory");
        this._loginAdminUser();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Directory One From File");
        this.setWorkingForm("updateGeneral");
        this.setTextField("name", "New name");
        this.submit();
        this.assertWarningPresent();
    }
}

