/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class DelegatedDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String DELEGATED_DIRECTORY_NAME = "ApacheDS Delegated Directory";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("delegatedtest.xml");
    }

    public void testDelegatedDirectoryAuthenticateCreatesUserInUnderlyingInternalDirectory() {
        this.log("Running testDelegatedDirectoryAuthenticateCreatesUserInUnderlyingInternalDirectory");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        this.assertTableRowCountEquals("user-details", 1);
        this.gotoViewApplication("crowd");
        this.clickLink("application-authtest");
        this.setWorkingForm("app-auth-test-form");
        this.setTextField("testUsername", "jdoe");
        this.setTextField("testPassword", "jdoe");
        this.submit();
        this.assertTextPresent("Successful verification");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        this.assertTableRowCountEquals("user-details", 2);
        this.assertUserInTable("jdoe", "John Doe", "jdoe@testingarea.org");
    }

    public void testDelegatedDirectoryImportLocalGroup() {
        this.log("Running testDelegatedDirectoryImportLocalGroup");
        this.gotoViewGroup("imported_group", DELEGATED_DIRECTORY_NAME);
        this.assertTextInElement("groupName", "imported_group");
        this.assertKeyInElement("groupLocation", "group.location.local");
        this.assertTextInElement("groupDirectory", DELEGATED_DIRECTORY_NAME);
        this.assertTextInElement("groupDirectory", "Delegated Authentication Directory");
    }

    public void testDelegatedDirectoryAddLocalGroup() {
        this.log("Running testDelegatedDirectoryAddLocalGroup");
        this.gotoAddGroup();
        this.setWorkingForm("addGroupForm");
        this.setTextField("name", "test_local_group");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        this.assertTextInElement("groupName", "test_local_group");
        this.assertKeyInElement("groupLocation", "group.location.local");
        this.assertTextInElement("groupDirectory", DELEGATED_DIRECTORY_NAME);
        this.assertTextInElement("groupDirectory", "Delegated Authentication Directory");
    }
}

