/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.BasicHttpParams;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class CrowdXsrfProtectionTest
extends CrowdAcceptanceTestCase {
    private static final List<String> ACTIONS = Arrays.asList("console/secure/application/addapplicationconfirmation!completeStep.action", "console/secure/application/update!update.action", "console/secure/application/updatedirectory!update.action", "console/secure/application/updatedirectory!addDirectory.action", "console/secure/application/updatedirectory!removeDirectory.action", "console/secure/application/updatedirectory!up.action", "console/secure/application/updatedirectory!down.action", "console/secure/application/updategroups!addGroup.action", "console/secure/application/updategroups!removeGroup.action", "console/secure/application/updatePermissions!doUpdate.action?tab=4", "console/secure/application/updateaddresses!addAddress.action?tab=5", "console/secure/application/updateaddresses!removeAddress.action?tab=5", "console/secure/application/updateoptional!updateOptional.action", "console/secure/application/remove!update.action", "console/secure/user/add!update.action", "console/secure/user/update!updateGeneral.action", "console/secure/user/updateattributes!updateAttributes.action", "console/secure/user/updateattributes!addAttribute.action", "console/secure/user/updateattributes!removeAttribute.action", "console/secure/user/updategroups!addGroups.action", "console/secure/user/updategroups!removeGroups.action", "console/secure/user/updateroles!addRole.action", "console/secure/user/updateroles!removeRole.action", "console/secure/user/updatealiases!update.action", "console/secure/dataimport/importatlassian!import.action", "console/secure/dataimport/importjive!update.action", "console/secure/dataimport/importdirectory!importdirectory.action", "console/secure/dataimport/directoryconfirmation!doExecute.action", "console/secure/user/resetpassword!update.action", "console/secure/user/remove!update.action", "console/secure/group/add!update.action", "console/secure/group/update!updateGeneral.action", "console/secure/group/updatemembers!addUsers.action", "console/secure/group/updatemembers!removeUsers.action", "console/secure/group/updatemembers!addGroups.action", "console/secure/group/updatemembers!removeGroups.action", "console/secure/group/remove!update.action", "console/secure/role/add!update.action", "console/secure/role/update!updateGeneral.action", "console/secure/role/remove!update.action", "console/secure/directory/createinternal!update.action", "console/secure/directory/createdelegated!update.action", "console/secure/directory/createconnector!update.action", "console/secure/directory/createremotecrowd!update.action", "console/secure/directory/createcustom!update.action", "console/secure/directory/synchronisedirectorycache!default.action", "console/secure/directory/updateinternal.action", "console/secure/directory/updateinternalconfiguration!update.action", "console/secure/directory/updateinternalpermissions!update.action", "console/secure/directory/updateinternaloptions!addDefaultGroups.action", "console/secure/directory/updateinternaloptions!removeDefaultGroup.action", "console/secure/directory/updatedelegated.action", "console/secure/directory/updatedelegatedconnection!update.action", "console/secure/directory/updatedelegatedconfiguration!update.action", "console/secure/directory/updatedelegatedpermissions!update.action", "console/secure/directory/updatedelegatedoptions!addDefaultGroups.action", "console/secure/directory/updatedelegatedoptions!removeDefaultGroup.action", "console/secure/directory/updateconnector.action", "console/secure/directory/synchconnectorcache!default.action", "console/secure/directory/updateconnectorconnection!update.action", "console/secure/directory/updateconnectorconfiguration!update.action", "console/secure/directory/updateconnectorpermissions!update.action", "console/secure/directory/updateconnectoroptions!addDefaultGroups.action", "console/secure/directory/updateconnectoroptions!removeDefaultGroup.action", "console/secure/directory/updateremotecrowd.action", "console/secure/directory/syncremotecrowdcache!default.action", "console/secure/directory/updateremotecrowdconnection!update.action", "console/secure/directory/updateremotecrowdpermissions!update.action", "console/secure/directory/updateremotecrowdoptions!addDefaultGroups.action", "console/secure/directory/updateremotecrowdoptions!removeDefaultGroup.action", "console/secure/directory/updatecustom.action", "console/secure/directory/updatecustomattributes!addAttribute.action", "console/secure/directory/updatecustomattributes!update.action", "console/secure/directory/updatecustomattributes!removeAttribute.action", "console/secure/directory/updatecustompermissions!update.action", "console/secure/directory/remove!update.action", "console/secure/admin/general!update.action", "console/secure/admin/licensing!update.action", "console/secure/admin/mailserver!update.action", "console/secure/admin/mailtemplate!update.action", "console/secure/admin/sessionconfig!update.action", "console/secure/session/removeusersession!removePrincipalSession.action", "console/secure/session/removesessionapplication!removeApplicationSession.action", "console/secure/admin/updatetrustedproxies!addAddress.action", "console/secure/admin/updatetrustedproxies!removeAddress.action", "console/secure/admin/backup!export.action", "console/secure/admin/restore!import.action", "console/secure/admin/loggingProfiling!updateProfiling.action", "console/secure/admin/loggingProfiling!updateLogging.action", "console/secure/admin/connectionpool!update.action", "console/user/updateprofile.action", "console/user/changepassword.action", "console/license!update.action", "console/resetpassword!update.action", "console/forgottenlogindetails!update.action");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.tester.setIgnoreFailingStatusCodes(true);
    }

    @Override
    public void tearDown() throws Exception {
        this.tester.setIgnoreFailingStatusCodes(false);
        super.tearDown();
    }

    public void testXsrfProtection() {
        String tokenMissingMessage = this.getMessage("atlassian.xwork.xsrf.notoken");
        ArrayList<String> unprotectedActions = new ArrayList<String>();
        for (String action : ACTIONS) {
            this.gotoPage(action);
            if (this.getPageSource().contains("warningBox") && this.isTextPresent(tokenMissingMessage)) continue;
            unprotectedActions.add(action);
            this.log("Page source for '" + action + "':\n" + this.tester.getPageSource());
        }
        CrowdXsrfProtectionTest.assertTrue((String)("The following actions are not XSRF protected: " + unprotectedActions), (boolean)unprotectedActions.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoginXsrfProtection() throws Exception {
        String cookie;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost(this.getBaseUrl() + "/console/j_security_check");
        httpPost.setParams(new BasicHttpParams().setParameter("j_username", (Object)"invalid").setParameter("j_password", (Object)"invalid"));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)302));
            Assert.assertThat((Object)response.getLastHeader("Location").getValue(), (Matcher)Matchers.endsWith((String)"/console/login.action?error=true"));
            cookie = response.getLastHeader("Set-Cookie").getValue();
            Assert.assertThat((Object)cookie, (Matcher)Matchers.containsString((String)"JSESSIONID="));
        }
        finally {
            httpPost.releaseConnection();
        }
        HttpGet httpGet = new HttpGet(this.getBaseUrl() + "/console/login.action?error=true");
        httpGet.setHeader((Header)new BasicHeader("Cookie", cookie));
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            String responseContent = IOUtils.toString((InputStream)response.getEntity().getContent());
            Assert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)this.getMessage("atlassian.xwork.xsrf.notoken")));
        }
        finally {
            httpGet.releaseConnection();
        }
    }
}

