/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.PropertyUtils;
import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.atlassian.crowd.acceptance.tests.TestDataState;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.CrowdWebTestCase;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdAcceptanceTestCase
extends CrowdWebTestCase {
    public static String HOST_PATH;
    protected static final String ADMIN_GROUP = "administrators";
    protected static final String ADMIN_USER = "admin";
    protected static final String ADMIN_PW = "admin";
    protected static final String ADMIN_FULL_NAME = "Super User";
    protected static final String ADMIN_EMAIL = "crowd@example.com";
    protected static final Properties specProperties;
    protected static String URL_HOME;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ResourceBundle i18n;
    protected static final String WORKGROUP_LICENSE_KEY = "NONnnbGCEhMXASCOrPtIvuKpmrMdafAvINOGBPKfEUbSSwn\nmj2KLPN2K78vDnn5CiW4DEM72L0Mz2ZyRhyyclcRGZjv03C\npqmUvmorqMooooNMNmvvmqOMPOnPQPrNrtwwStVwwWusPSU\nUwxwSVMWuuwtUXwspOsmvUUnnvrtnnommmmmUUnnvrtnnom\nmmmmUU1qiXppfXkWJlcqtXobWJvpqbjpUUrm";
    protected static final String UNLIMITED_LICENSE_KEY = "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm";
    protected static final String EXPIRED_MAINTENANCE_KEY = "AAABFw0ODAoPeNp9kFFLwzAQx9/zKQI+t7TbZGUQEJc4CnWdrlMRX2J607A0LZe0um9vu3UgPvh4x\n/1+97+7eoaSbqGh0ZTGk8VssrieUrEt6CSKEsLBKdSN17VlS6y/yrcF5dCBqRtAooZOKJXXHTCPL\nZAlghyGufTAesM8iJIgismytr6fW8sKmDISD+EBrL8ppTbHxkgLPlR1NQozrcA6KI4NnAAunkSWb\n8TjRSPue+4/j+ikaU9B2F4aB6QHrAcrrQLx3Wg8XgImY8AcP6TV7szwQUc3Jx/ZAnaAKWe3xWwVr\nHbpXfCSP8yDnL+mY+B1W70D5vudA3QsiMl4QQ9lKb9Uvxa31uhKeyjJpkX1KR38fdgPj3SKEjAsA\nhQDnIHlSx5Ug4jClePbHxCPTYAwnQIUeTzFHGkn0bRuxJZNK5uaXO7y+uU=X02e6";
    protected static final String DEVELOPER_LICENSE_KEY = "AAABgQ0ODAoPeNp1kstuwjAQRff5CktdB4XXAqQsIHELLS+RQCvUjWMGcBvsaJxA+fuaQNQkopJX1\n9d3zsz4aaokCSAhzQ5pdvutVr/dJTQISctxelbEjpFSjYngIDXQrUiFki6dhXS5WI4Dau2EPsAFC\nkd4ScB9Nhq9wGef+HCCWCWAFo/VCbBi83Kp4pplxwhwvltpQO12La7krsF4Kk7gppiBtciQH5gGn\n6XgXgltc5odq5Q7Y0dwfbqmk/mCLosb+pMIvOTPFu1R0Vc5OgA0OGPfHb70Qvtjte7Yb5vNyB46z\nXfrSyCrwL+OlwNCZQqYoNC1Xq/UlU6NEGcg+QNf0bIXZ9qkzdQWtOvUBp+nDHPpv6Jlwgd74phxE\ncXVRXl3sRI0ZcJUkMzQ1obGUZ23tQCjVF7fb80YV/JbqrO05rhnUmiWEw3SmGktmPwDKu/AQ8h99\nfXeKpedxb8raz5ojiLJC4WgUxLfYMhOIUnibC8k2Rak+jax8vv7Hy1Lv3FyG1gwLAIUHEP4zbqEf\n1DeOWKb7SpxQ1MEd8ACFGxZV5doE27OtsuNDT50k2xIhAozX02im";
    private static final Pattern DETAILS;
    private static final Pattern DETAILS_WITH_ALIAS;

    public String getBaseUrl() {
        return HOST_PATH;
    }

    public String getCrowdHome() {
        String crowdHome = System.getProperty("crowd.home");
        if (crowdHome == null) {
            this.gotoSystemInfo();
            String path = this.getElementTextByXPath("//*[@id=\"home-path\"]");
            File homePath = new File(path);
            if (homePath.exists() && homePath.isDirectory()) {
                try {
                    return homePath.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return crowdHome;
    }

    public String getCrowdApplicationPassword() {
        return SoapClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)new ResourceLocator(){

            public String getResourceLocation() {
                return CrowdAcceptanceTestCase.this.getCrowdHome() + File.separator + this.getResourceName();
            }

            public String getResourceName() {
                return "crowd.properties";
            }

            public Properties getProperties() {
                return PropertyUtils.getPropertiesFromFile((File)new File(this.getResourceLocation()));
            }
        }).getApplicationPassword();
    }

    public void _loginAdminUser() {
        this._loginAsUser("admin", "admin");
    }

    public void _loginAsUser(String username, String password) {
        this._logout();
        this.submitLoginForm(username, password);
    }

    public void submitLoginFormAsAdminUser() {
        this.submitLoginForm("admin", "admin");
    }

    public void submitLoginForm(String username, String password) {
        this.assertKeyPresent("login.title");
        this.setTextField("j_username", username);
        this.setTextField("j_password", password);
        this.submit();
        this.assertLinkPresentWithKey("menu.logout.label");
    }

    public void _logout() {
        this.gotoPage("/console/logoff.action");
        this.assertKeyPresent("login.title");
    }

    public void intendToModifyData() {
        TestDataState.INSTANCE.intendToModify(this.getTestContext().getBaseUrl());
    }

    public void intendToModifyLdapData() {
    }

    public void restoreCrowdFromXML(String xmlfilename) {
        if (TestDataState.INSTANCE.isRestoredXml(this.getTestContext().getBaseUrl(), xmlfilename)) {
            this._loginAdminUser();
            return;
        }
        if (this.getPageText().contains(this.getText("setup.text"))) {
            this.setTextField("key", UNLIMITED_LICENSE_KEY);
            this.submit();
            this.clickRadioOption("installOption", "install.xml");
            this.submit();
            this.clickRadioOption("databaseOption", "db.embedded");
            this.submit();
            this.setTextField("filePath", AcceptanceTestHelper.getResourcePath("xml/" + xmlfilename));
            this.submit();
            this.assertKeyPresent("setupcomplete.title");
            this.clickElementByXPath("//input[@id='continueButton']");
            this.assertKeyPresent("login.title");
        } else {
            this.restoreCrowdFromXMLWithoutReloggingIn(xmlfilename);
        }
        TestDataState.INSTANCE.setRestoredXml(this.getTestContext().getBaseUrl(), xmlfilename);
        this._loginAdminUser();
    }

    private void restoreCrowdFromXMLWithoutReloggingIn(String xmlfilename) {
        this.restoreCrowdFromXMLWithoutReloggingIn(xmlfilename, true);
    }

    void restoreCrowdFromXMLWithoutReloggingIn(String xmlfilename, boolean checkForError) {
        TestDataState.INSTANCE.intendToModify(this.getTestContext().getBaseUrl());
        String absolutePathfileLocation = AcceptanceTestHelper.getResourcePath("xml/" + xmlfilename);
        this._loginAdminUser();
        this.gotoRestore();
        this.setTextField("importFilePath", absolutePathfileLocation);
        this.logger.info("Restoring Crowd from: " + absolutePathfileLocation);
        this.submit("import-submit");
        if (checkForError) {
            this.assertErrorNotPresent();
        }
    }

    public void restoreBaseSetup() {
        this.restoreCrowdFromXML("basesetup.xml");
    }

    public void gotoAddApplication() {
        this.gotoPage("/console/secure/application/addapplicationdetails.action");
    }

    public void gotoCreateDirectory() {
        this.gotoPage("/console/secure/directory/create.action");
    }

    public void gotoAddGroup() {
        this.gotoPage("/console/secure/group/add.action");
    }

    public void gotoViewPrincipal(String principalName, String directoryName) {
        this.gotoPage("/console/secure/user/view.action?name=" + principalName + "&directoryName=" + directoryName);
        this.assertKeyPresent("menu.viewprincipal.label");
    }

    public void gotoRemovePrincipal(String principalName, String directoryName) {
        this.gotoPage("/console/secure/user/remove.action?name=" + principalName + "&directoryName=" + directoryName);
        this.assertKeyPresent("menu.removeprincipal.label");
    }

    public void gotoViewGroup(String groupName, String directoryName) {
        this.gotoPage("/console/secure/group/view.action?name=" + groupName + "&directoryName=" + directoryName);
    }

    public void gotoAddPrincipal() {
        this.gotoPage("/console/secure/user/add.action");
    }

    public void gotoBrowseApplications() {
        this.gotoPage("/console/secure/application/browse.action");
        this.assertKeyPresent("browser.application.title");
    }

    public void gotoBrowsePrincipals() {
        this.gotoPage("/console/secure/user/browse.action");
        this.assertKeyPresent("browser.principal.title");
    }

    public void gotoBrowsePrincipals(int resultsStart) {
        this.gotoPage("/console/secure/user/browse.action?resultsStart=" + resultsStart);
        this.assertKeyPresent("browser.principal.title");
    }

    public void gotoBrowseGroups() {
        this.gotoPage("/console/secure/group/browse.action");
        this.assertKeyPresent("browser.group.title");
    }

    public void gotoBrowseGroups(int resultsStart) {
        this.gotoPage("/console/secure/group/browse.action?resultsStart=" + resultsStart);
        this.assertKeyPresent("browser.group.title");
    }

    public void gotoBrowseDirectories() {
        this.gotoPage("/console/secure/directory/browse.action");
    }

    public void gotoImporters() {
        this.gotoPage("/console/secure/dataimport/importtype.action");
    }

    public void gotoSystemInfo() {
        this.gotoPage("/console/secure/admin/systeminfo.action");
        this.assertKeyPresent("systeminfo.title");
    }

    @Override
    protected void log(String message) {
        this.logger.info(message);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.i18n = ResourceBundle.getBundle("com.atlassian.crowd.console.action.BaseAction");
        this.getTestContext().setBaseUrl(HOST_PATH);
        this.getTestContext().setResourceBundleName("com.atlassian.crowd.console.action.BaseAction");
        this.log("Starting at URL: " + HOST_PATH);
        this.beginAt(URL_HOME);
    }

    public String getText(String key) {
        return this.i18n.getString(key);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.tester = null;
    }

    public void gotoGeneral() {
        this.gotoPage("/console/secure/admin/general.action");
    }

    public void gotoLicensing() {
        this.gotoPage("/console/secure/admin/licensing.action");
    }

    public void gotoMailServer() {
        this.gotoPage("/console/secure/admin/mailserver.action");
    }

    public void gotoMailTemplate() {
        this.gotoPage("/console/secure/admin/mailtemplate.action");
    }

    public void gotoSessionConfig() {
        this.gotoPage("/console/secure/admin/sessionconfig.action");
        this.assertKeyPresent("menu.sessionconfig.label");
    }

    public void gotoCurrentApplicationSessions() {
        this.gotoPage("/console/secure/session/browseapplicationsessions.action");
    }

    public void gotoCurrentPrincipalSessions() {
        this.gotoPage("/console/secure/session/browseusersessions.action");
    }

    public void gotoTrustedProxies() {
        this.gotoPage("/console/secure/admin/viewtrustedproxies.action");
    }

    public void gotoLoggingProfiling() {
        this.gotoPage("/console/secure/admin/loggingProfiling.action");
    }

    public void gotoBackup() {
        this.gotoPage("/console/secure/admin/backup.action");
        this.assertKeyPresent("administration.backup.text");
    }

    public void gotoRestore() {
        this.gotoPage("/console/secure/admin/restore.action");
    }

    public void gotoViewApplication(String applicationName) {
        this.gotoPage("/console/secure/application/viewdetails.action?name=" + applicationName);
    }

    public void gotoSAMLConfig() {
        this.gotoPage("/console/secure/application/samlconfig.action");
    }

    public void gotoLdapConnectionPool() {
        this.gotoPage("/console/secure/admin/connectionpool.action");
    }

    public void assertUserInTable(String username, String fullname, String email) {
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)CoreMatchers.hasItem(this.userWithDetails(username, fullname, email)));
    }

    public void assertUserNotInTable(String username, String fullname, String email) {
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.hasItem(this.userWithDetails(username, fullname, email))));
    }

    public void assertUserInTable(String username, String fullname, String email, String alias) {
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)CoreMatchers.hasItem(this.userWithDetailsAndAlias(username, fullname, email, alias)));
    }

    public void assertUnescapedKeyNotPresent(String key) {
        String message = this.getMessage(key);
        this.assertTextNotPresent(MessageFormat.format(message, new Object[0]));
    }

    public void assertUnescapedKeyPresent(String key) {
        String message = this.getMessage(key);
        this.assertTextPresent(MessageFormat.format(message, new Object[0]));
    }

    List<User> getUserDetailsTableContents() {
        return this.scrapeTable("user-details", (List<String>)ImmutableList.of((Object)"Name", (Object)"Details"), new Function<List<String>, User>(){

            public User apply(List<String> input) {
                UserWithAlias user;
                String email;
                String fullName = input.get(0);
                String details = input.get(1);
                java.util.regex.Matcher m = DETAILS_WITH_ALIAS.matcher(details);
                if (m.matches()) {
                    String username = m.group(1);
                    email = m.group(2);
                    String alias = m.group(3);
                    user = new UserWithAlias(username, alias);
                } else {
                    m = DETAILS.matcher(details);
                    if (!m.matches()) {
                        throw new RuntimeException("Unable to match details: " + details);
                    }
                    String username = m.group(1);
                    email = m.group(2);
                    user = new UserTemplate(username);
                }
                user.setDisplayName(fullName);
                user.setEmailAddress(email);
                return user;
            }
        });
    }

    Matcher<User> userWithDetails(final String username, final String fullname) {
        return new TypeSafeMatcher<User>(User.class){

            public void describeTo(Description desc) {
                desc.appendText("a User with username '" + username + "' and full name '" + fullname + "'");
            }

            protected boolean matchesSafely(User u) {
                return username.equals(u.getName()) && fullname.equals(u.getDisplayName());
            }
        };
    }

    Matcher<User> userWithDetails(final String username, final String fullname, final String email) {
        return new TypeSafeMatcher<User>(User.class){

            public void describeTo(Description desc) {
                desc.appendText("a User with username '" + username + "', full name '" + fullname + "' and email '" + email + "'");
            }

            protected boolean matchesSafely(User u) {
                return username.equals(u.getName()) && fullname.equals(u.getDisplayName()) && email.equals(u.getEmailAddress());
            }
        };
    }

    public void gotoAdministrationPage() {
        this.gotoPage("console/secure/admin/general.action");
    }

    private Matcher<UserWithAlias> userWithDetailsAndAlias(final String username, final String fullname, final String email, final String alias) {
        return new TypeSafeMatcher<UserWithAlias>(UserWithAlias.class){

            public void describeTo(Description desc) {
                desc.appendText("a User with username '" + username + "', full name '" + fullname + "', email '" + email + "' and alias '" + alias + "'");
            }

            protected boolean matchesSafely(UserWithAlias u) {
                return username.equals(u.getName()) && fullname.equals(u.getDisplayName()) && email.equals(u.getEmailAddress()) && alias.equals(u.getAlias());
            }
        };
    }

    List<Group> getGroupTableContents() {
        return this.scrapeTable("groupsTable", (List<String>)ImmutableList.of((Object)"Group", (Object)"Description", (Object)"Active"), new Function<List<String>, Group>(){

            public Group apply(List<String> input) {
                String groupName = input.get(0);
                String description = input.get(1);
                String active = input.get(2);
                GroupTemplate group = new GroupTemplate(groupName, -1L);
                group.setDescription(description);
                group.setActive(Boolean.parseBoolean(active));
                return group;
            }
        });
    }

    static List<String> namesOf(Iterable<? extends DirectoryEntity> entities) {
        ArrayList<String> names = new ArrayList<String>();
        for (DirectoryEntity directoryEntity : entities) {
            names.add(directoryEntity.getName());
        }
        return names;
    }

    static {
        URL_HOME = "/console/secure/console.action";
        specProperties = AcceptanceTestHelper.loadProperties("localtest.properties");
        HOST_PATH = new BaseUrlFromProperties(specProperties).baseUrlFor("crowd");
        DETAILS = Pattern.compile("Username: (.*)\nEmail Address: ?(.*)");
        DETAILS_WITH_ALIAS = Pattern.compile("Username: (.*)\nEmail Address: ?(.*)\nAlias: (.*)");
    }

    private static class UserWithAlias
    extends UserTemplate {
        private final String alias;

        UserWithAlias(String username, String alias) {
            super(username);
            this.alias = alias;
        }

        String getAlias() {
            return this.alias;
        }

        public String toString() {
            return super.toString() + " and alias '" + this.alias + "'";
        }
    }
}

