/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;

public class BrowsePrincipalsTest
extends CrowdAcceptanceTestCase {
    private static final long MAX_WAIT_TIME_MS = 10000L;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("searchdirectories.xml");
        this.synchroniseDirectory();
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Apache DS", 10000L);
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Apache DS 1.5.4", 10000L);
    }

    public void testBrowseInternalDirectoryUsers() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertUserInTable("admin", "Justin Koke", "admin@test.org");
        this.assertUserInTable("justin", "Justin Koke", "justin@test.org");
    }

    public void testBrowseApacheDSUsers() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS");
        this.submit("submit-search");
        this.assertUserInTable("jdoe", "John Doe", "jdoe@testingarea.org");
        this.assertUserInTable("ldapusera", "LDAP User A", "ldapusera@testingarea.org");
        this.assertUserInTable("ldapuserb", "LDAP User B", "ldapuserb@testingarea.org");
        this.assertUserInTable("ldapuserc", "LDAP User C", "ldapuserc@testingarea.org");
        this.assertUserInTable("ldapuserd", "LDAP User D", "ldapuserd@testingarea.org");
        this.assertUserInTable("ldapusere", "LDAP User E", "ldapusere@testingarea.org");
        this.assertUserInTable("ldapuserf", "LDAP User F", "ldapuserf@testingarea.org");
        this.assertUserInTable("ldapuserg", "LDAP User G", "ldapuserg@testingarea.org");
        this.assertUserInTable("ldapuserh", "LDAP User H", "ldapuserh@testingarea.org");
    }

    public void testSearchForSpecificUsersByUsernameInApacheDS154() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.setTextField("search", "aeinstein");
        this.submit("submit-search");
        this.assertUserInTable("aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserNotInTable("mplanck", "Max Planck", "mplanck@example.com");
    }

    public void testSearchForSpecificUsersByEmailInApacheDS154() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.setTextField("search", "@example.com");
        this.submit("submit-search");
        this.assertUserInTable("aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserInTable("mplanck", "Max Planck", "mplanck@example.com");
        this.assertUserInTable("nbohr", "Neils Bohr", "nbohr@example.com");
        this.assertUserInTable("mborn", "Max Born", "mborn@example.com");
        this.assertUserInTable("wpauli", "Wolfgang Pauli", "wpauli@example.com");
        this.assertUserInTable("mcurie", "Marie Curie", "mcurie@example.com");
    }

    public void testSearchForSpecificUsersByUsernameInInternalDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("search", "admin");
        this.submit("submit-search");
        this.assertUserInTable("admin", "Justin Koke", "admin@test.org");
        this.assertUserNotInTable("justin", "Justin Koke", "justin@test.org");
    }

    public void testSearchForSpecificUsersByEmailInInternalDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("search", "admin@test.org");
        this.submit("submit-search");
        this.assertUserInTable("admin", "Justin Koke", "admin@test.org");
        this.assertUserNotInTable("justin", "Justin Koke", "justin@test.org");
    }

    public void testSearchForInactiveUsersWithNoSearchText() {
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Inactive");
        this.submit("submit-search");
        this.assertUserInTable("inactive", "Inactive User", "inactive@example.com");
        this.assertUserNotInTable("user", "Test User", "user@example.com");
        this.assertUserNotInTable("admin", "Shihab Hamid", "shihab@gmai.com");
    }

    public void testSearchForActiveUsersWithSearchText() {
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Active");
        this.setTextField("search", "user");
        this.submit("submit-search");
        this.assertUserInTable("user", "Test User", "user@example.com");
        this.assertUserNotInTable("inactive", "Inactive User", "inactive@example.com");
        this.assertUserNotInTable("admin", "Shihab Hamid", "shihab@gmai.com");
    }

    public void testNoDirectoryIsSelectedByDefault() {
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
    }

    public void testDirectorySelectionIsSaved() {
        this.gotoBrowsePrincipals();
        this.selectOption("directoryID", "Second Directory");
        this.submit("submit-search");
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", "Second Directory");
        this.assertSelectOptionNotPresent("directoryID", this.getText("selectdirectory.label"));
    }

    public void testNonExistingDirectorySelection() {
        this.intendToModifyData();
        this.gotoBrowsePrincipals();
        this.selectOption("directoryID", "Second Directory");
        this.submit("submit-search");
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
        this.assertWarningAndErrorNotPresent();
    }

    public void testOnlyDirectoryIsSelected() {
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Apache DS");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Apache DS 1.5.4");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowsePrincipals();
        this.assertSelectedOptionEquals("directoryID", "Test Internal Directory");
    }
}

