/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import java.util.Properties;

public class AddGroupLDAPTest
extends CrowdAcceptanceTestCase {
    private static final String DIRECTORY_NAME = "ApacheDS154";
    private static final String GROUP_NAME = "myGroup";
    private static final String SUB_GROUP_NAME = "mySubGroup";
    LDAPLoader loader = new LDAPLoader();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.loader.accessibleSetUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.loader.accessibleTearDown();
    }

    public void testAddGroupToLDAPDirectory() {
        this.log("Running testAddGroupToLDAPDirectory");
        this.gotoAddGroup();
        this.setTextField("name", GROUP_NAME);
        this.setTextField("description", "Crowd LDAP Test Group");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent(GROUP_NAME);
    }

    public void testAddRemoteGroupTwice() {
        this.log("Running testAddRemoteGroupTwice");
        this.intendToModifyLdapData();
        String groupName = "Test-RemoteGroup";
        this.gotoAddGroup();
        this.setTextField("name", "Test-RemoteGroup");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-RemoteGroup");
        this.assertKeyPresent("group.location.remote");
        this.gotoAddGroup();
        this.setTextField("name", "Test-RemoteGroup");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertErrorPresentWithKey("invalid.namealreadyexist");
        this.assertKeyPresent("menu.addgroup.label");
        this.assertKeyNotPresent("menu.viewgroup.label");
        this.gotoBrowseGroups();
        this.clickLinkWithExactText("Test-RemoteGroup");
        this.clickLink("remove-group");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("group-details", "Test-RemoteGroup");
    }

    public void testAddLocalGroupTwice() {
        this.log("Running testAddLocalGroupTwice");
        this.intendToModifyData();
        this.enableLocalGroups();
        this.gotoAddGroup();
        String groupName = "Test-LocalGroup";
        this.setTextField("name", "Test-LocalGroup");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-LocalGroup");
        this.assertKeyPresent("group.location.local");
        this.gotoAddGroup();
        this.setTextField("name", "Test-LocalGroup");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertErrorPresentWithKey("invalid.namealreadyexist");
        this.assertKeyPresent("menu.addgroup.label");
        this.assertKeyNotPresent("menu.viewgroup.label");
    }

    public void testAddLocalGroupWithTheSameNameAsRemoteGroup() {
        this.log("Running testAddLocalGroupTwice");
        this.intendToModifyData();
        this.intendToModifyLdapData();
        String groupName = "Test-LocalAndRemoteGroup";
        this.gotoAddGroup();
        this.setTextField("name", "Test-LocalAndRemoteGroup");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-LocalAndRemoteGroup");
        this.assertKeyPresent("group.location.remote");
        this.enableLocalGroups();
        this.gotoAddGroup();
        this.setTextField("name", "Test-LocalAndRemoteGroup");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.assertErrorPresentWithKey("invalid.namealreadyexist");
        this.assertKeyPresent("menu.addgroup.label");
        this.assertKeyNotPresent("menu.viewgroup.label");
        this.gotoBrowseGroups();
        this.clickLinkWithExactText("Test-LocalAndRemoteGroup");
        this.clickLink("remove-group");
        this.submit();
        this.assertWarningPresent();
        this.assertTextPresent(new ReadOnlyGroupException("Test-LocalAndRemoteGroup").getMessage());
        this.disableLocalGroups();
        this.gotoBrowseGroups();
        this.clickLinkWithExactText("Test-LocalAndRemoteGroup");
        this.clickLink("remove-group");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("group-details", "Test-LocalAndRemoteGroup");
    }

    private void enableLocalGroups() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DIRECTORY_NAME);
        this.clickLink("connector-connectiondetails");
        this.checkCheckbox("localGroupsEnabled");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertCheckboxSelected("localGroupsEnabled");
    }

    private void disableLocalGroups() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(DIRECTORY_NAME);
        this.clickLink("connector-connectiondetails");
        this.uncheckCheckbox("localGroupsEnabled");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertCheckboxNotSelected("localGroupsEnabled");
    }

    class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS154ConfigFileName());
        }

        @Override
        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("ldap.basedn", directorySettings.getProperty("test.integration.basedn"));
        }

        @Override
        protected void loadTestData() throws Exception {
            GroupTemplate subGroup = new GroupTemplate(AddGroupLDAPTest.SUB_GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
            this.getRemoteDirectory().addGroup(subGroup);
        }

        @Override
        protected void removeTestData() throws DirectoryInstantiationException {
            DirectoryTestHelper.silentlyRemoveGroup(AddGroupLDAPTest.GROUP_NAME, this.getRemoteDirectory());
            DirectoryTestHelper.silentlyRemoveGroup(AddGroupLDAPTest.SUB_GROUP_NAME, this.getRemoteDirectory());
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

