/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.core.util.ClassLoaderUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class AcceptanceTestHelper {
    private static final Logger log = Logger.getLogger(AcceptanceTestHelper.class);
    private static final String IT_TEST_RESOURCES = "target/it-classes";

    protected static File loadFileFromClasspath(String source) throws Exception {
        File testFile = AcceptanceTestHelper.getResource(source);
        if (!testFile.exists()) {
            throw new Exception("Could not find an existing file on filesystem to match:" + source);
        }
        return testFile;
    }

    public static File generateLargeAttachment(String filename, long bytes) {
        File dummyAttachment = new File(filename);
        try {
            BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dummyAttachment));
            for (long count = 0L; count < bytes; ++count) {
                ((OutputStream)fos).write((int)(Math.random() * 127.0));
            }
            ((OutputStream)fos).close();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return dummyAttachment;
    }

    public static File generateAttachment(String filename, String text) {
        File attachmentsDir = new File(new File(System.getProperty("java.io.tmpdir")), "crowd-acceptance-test-temp");
        if (!attachmentsDir.exists()) {
            attachmentsDir.mkdirs();
        }
        attachmentsDir.deleteOnExit();
        File dummyAttachment = new File(attachmentsDir, filename);
        dummyAttachment.deleteOnExit();
        try {
            FileOutputStream fos = new FileOutputStream(dummyAttachment);
            fos.write(text.getBytes());
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        return dummyAttachment;
    }

    protected static File copyIntoTemporaryFile(String source, String fileName) throws Exception {
        File f;
        FileInputStream is = new FileInputStream(new File(AcceptanceTestHelper.getTestResourcesLocation(), source));
        if (is == null && (f = new File(source)).exists()) {
            is = new FileInputStream(f);
        }
        if (is == null) {
            throw new Exception("Could not locate " + fileName + " on the classpath or on the file system");
        }
        File temp = File.createTempFile(fileName, null);
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        String content = IOUtils.toString((InputStream)is);
        out.write(content);
        out.close();
        return temp;
    }

    public static String getTestResourcesLocation() {
        return IT_TEST_RESOURCES;
    }

    public static InputStream getResourceAsStream(String fileName) throws Exception {
        File resource = new File(AcceptanceTestHelper.getTestResourcesLocation(), fileName);
        if (resource.exists()) {
            return new FileInputStream(resource);
        }
        URL classpathResource = ClassLoaderUtils.getResource((String)fileName, AcceptanceTestHelper.class);
        return classpathResource.openStream();
    }

    public static File getResource(String fileName) {
        File fileResource = new File(AcceptanceTestHelper.getTestResourcesLocation(), fileName);
        if (fileResource.exists()) {
            return fileResource;
        }
        URL classpathResource = ClassLoaderUtils.getResource((String)fileName, AcceptanceTestHelper.class);
        if (classpathResource != null) {
            try {
                return new File(classpathResource.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("File does not exist: " + fileName);
    }

    public static String getResourcePath(String fileName) {
        return AcceptanceTestHelper.getResource(fileName).getAbsolutePath();
    }

    public static Properties loadProperties(String fileName) {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtils.getResource((String)fileName, AcceptanceTestHelper.class).openStream();
            if (inputStream != null) {
                props.load(inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties file: " + fileName, e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return props;
    }
}

