/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.manager.directory;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.encoder.PlaintextPasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryManagerGenericNestedGroupsTest
extends BaseSpringTestCase {
    private static final long DIRECTORY_ID = 1L;
    private static final String groupName0 = "group-0";
    private static final String groupName1 = "group-1";
    private static final String groupName2 = "group-2";
    private static final String groupName3 = "group-3";
    private static final String groupName4 = "group-4";
    private static final String groupName5 = "group-5";
    private static final String userNameA = "user-a";
    private static final String userNameB = "user-b";
    private static final String userNameC = "user-c";
    private static final String userNameD = "user-d";
    private static final String userNameE = "user-e";
    private static final String userNameF = "user-f";
    private static final String userNameG = "user-g";
    protected final String firstName = "First";
    protected final String surName = "Last";
    protected final String password = "secret-password";
    private DirectoryManager directoryManager;
    private PasswordEncoderFactory passwordEncoderFactory;

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }

    @Override
    protected String[] getConfigLocations() {
        ArrayList<String> configs = new ArrayList<String>(Arrays.asList(super.getConfigLocations()));
        configs.add("classpath:/applicationContext-CrowdManagers.xml");
        configs.add("classpath:/applicationContext-CrowdUtils.xml");
        configs.add("classpath:/applicationContext-internaldirectoryloader-config.xml");
        return configs.toArray(new String[configs.size()]);
    }

    @Override
    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.passwordEncoderFactory.addEncoder((PasswordEncoder)new PlaintextPasswordEncoder());
        this.addUser(userNameA);
        this.addUser(userNameB);
        this.addUser(userNameC);
        this.addUser(userNameD);
        this.addUser(userNameE);
        this.addUser(userNameF);
        this.addUser(userNameG);
        this.addGroup(groupName0);
        this.addGroup(groupName1);
        this.addGroup(groupName2);
        this.addGroup(groupName3);
        this.addGroup(groupName4);
        this.addGroup(groupName5);
        this.directoryManager.addUserToGroup(1L, userNameA, groupName1);
        this.directoryManager.addUserToGroup(1L, userNameB, groupName2);
        this.directoryManager.addUserToGroup(1L, userNameC, groupName3);
        this.directoryManager.addUserToGroup(1L, userNameD, groupName3);
        this.directoryManager.addUserToGroup(1L, userNameE, groupName4);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName1);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName2);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName3);
        this.directoryManager.addUserToGroup(1L, userNameF, groupName5);
        this.directoryManager.addGroupToGroup(1L, groupName1, groupName0);
        this.directoryManager.addGroupToGroup(1L, groupName2, groupName1);
        this.directoryManager.addGroupToGroup(1L, groupName3, groupName2);
        this.directoryManager.addGroupToGroup(1L, groupName1, groupName3);
        this.directoryManager.addGroupToGroup(1L, groupName4, groupName3);
        this.directoryManager.addGroupToGroup(1L, groupName5, groupName4);
    }

    protected void addGroup(String name) throws Exception {
        GroupTemplate group = new GroupTemplate(name, 1L, GroupType.GROUP);
        this.directoryManager.addGroup(1L, group);
    }

    protected void addUser(String name) throws Exception {
        UserTemplate user = new UserTemplate(name, 1L);
        user.setFirstName("Bob");
        user.setLastName("Smith");
        user.setDisplayName("Bob Smith");
        user.setEmailAddress("bsmith@example.com");
        this.directoryManager.addUser(1L, user, new PasswordCredential("password"));
    }

    private void assertContainsExactly(List<String> results, String ... values) {
        DirectoryManagerGenericNestedGroupsTest.assertEquals((int)values.length, (int)results.size());
        for (String value : values) {
            DirectoryManagerGenericNestedGroupsTest.assertTrue((String)("Results " + results.toString() + " does not contain: " + value), (boolean)results.contains(value));
        }
    }

    public void testFindDirectoryById() throws Exception {
        Directory directory = this.directoryManager.findDirectoryById(1L);
        DirectoryManagerGenericNestedGroupsTest.assertEquals((String)"directory1", (String)directory.getName());
        DirectoryManagerGenericNestedGroupsTest.assertEquals((Object)DirectoryType.INTERNAL, (Object)directory.getType());
    }

    public void testSearchDirectUserMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        this.assertContainsExactly(names, userNameA, userNameF);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        this.assertContainsExactly(names, userNameB, userNameF);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        this.assertContainsExactly(names, userNameC, userNameD, userNameF);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        this.assertContainsExactly(names, userNameE);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        this.assertContainsExactly(names, userNameF);
    }

    public void testSearchDirectGroupMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        this.assertContainsExactly(names, groupName2);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        this.assertContainsExactly(names, groupName3);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1, groupName4);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        this.assertContainsExactly(names, groupName5);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
    }

    public void testSearchDirectGroupMembershipsOfUser() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameA).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameB).returningAtMost(-1));
        this.assertContainsExactly(names, groupName2);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameC).returningAtMost(-1));
        this.assertContainsExactly(names, groupName3);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameD).returningAtMost(-1));
        this.assertContainsExactly(names, groupName3);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameE).returningAtMost(-1));
        this.assertContainsExactly(names, groupName4);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameF).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1, groupName2, groupName3, groupName5);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(userNameG).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
    }

    public void testSearchDirectGroupMembershipsOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group());
        List names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName3);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        this.assertContainsExactly(names, groupName2);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        this.assertContainsExactly(names, groupName3);
        names = this.directoryManager.searchDirectGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        this.assertContainsExactly(names, groupName4);
    }

    public void testSearchNestedGroupMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1, groupName2, groupName3, groupName4, groupName5);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        this.assertContainsExactly(names, groupName2, groupName3, groupName4, groupName5);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1, groupName3, groupName4, groupName5);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        this.assertContainsExactly(names, groupName1, groupName2, groupName4, groupName5);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        this.assertContainsExactly(names, groupName5);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
    }

    public void testSearchNestedUserMembersOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        this.assertContainsExactly(names, userNameA, userNameB, userNameC, userNameD, userNameE, userNameF);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        this.assertContainsExactly(names, userNameA, userNameB, userNameC, userNameD, userNameE, userNameF);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        this.assertContainsExactly(names, userNameA, userNameB, userNameC, userNameD, userNameE, userNameF);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        this.assertContainsExactly(names, userNameA, userNameB, userNameC, userNameD, userNameE, userNameF);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        this.assertContainsExactly(names, userNameE, userNameF);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        this.assertContainsExactly(names, userNameF);
    }

    public void testSearchNestedGroupMembershipsOfGroup() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName0).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName1).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName3, groupName2);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName2).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName3);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName3).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName4).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(groupName5).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3, groupName4);
    }

    public void testSearchNestedGroupMembershipsOfUser() throws Exception {
        QueryBuilder.PartialMembershipQueryWithEntityToMatch query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user());
        List names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameA).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameB).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameC).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameD).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameE).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3, groupName4);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameF).returningAtMost(-1));
        this.assertContainsExactly(names, groupName0, groupName1, groupName2, groupName3, groupName4, groupName5);
        names = this.directoryManager.searchNestedGroupRelationships(1L, query.withName(userNameG).returningAtMost(-1));
        this.assertContainsExactly(names, new String[0]);
    }

    public void testIsUserDirectGroupMember() throws Exception {
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameA, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameB, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameC, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameD, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameE, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameF, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserDirectGroupMember(1L, userNameG, groupName5));
    }

    public void testIsUserNestedGroupMember() throws Exception {
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameA, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameB, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameC, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameD, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameE, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameF, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isUserNestedGroupMember(1L, userNameG, groupName5));
    }

    public void testIsGroupDirectGroupMember() throws Exception {
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName0, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName1, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName2, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName3, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName4, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupDirectGroupMember(1L, groupName5, groupName5));
    }

    public void testIsGroupNestedGroupMember() throws Exception {
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName0));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName1));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName2));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName3));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertTrue((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName4));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName0, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName1, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName2, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName3, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName4, groupName5));
        DirectoryManagerGenericNestedGroupsTest.assertFalse((boolean)this.directoryManager.isGroupNestedGroupMember(1L, groupName5, groupName5));
    }

    public void testAddGroupToGroupCycleCreationFail() throws Exception {
        try {
            this.directoryManager.addGroupToGroup(1L, groupName0, groupName0);
            DirectoryManagerGenericNestedGroupsTest.fail((String)"InvalidMembershipException expected");
        }
        catch (InvalidMembershipException invalidMembershipException) {
            // empty catch block
        }
    }

    public void testRemoveGroupFromGroupCycleDeletionFail() throws Exception {
        try {
            this.directoryManager.removeGroupFromGroup(1L, groupName0, groupName0);
            DirectoryManagerGenericNestedGroupsTest.fail((String)"InvalidMembershipException expected");
        }
        catch (InvalidMembershipException invalidMembershipException) {
            // empty catch block
        }
    }

    public void testRemoveGroupFromGroup() throws Exception {
        DirectoryManagerGenericNestedGroupsTest.assertEquals((int)2, (int)this.directoryManager.searchDirectGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
        DirectoryManagerGenericNestedGroupsTest.assertEquals((int)4, (int)this.directoryManager.searchNestedGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
        this.directoryManager.removeGroupFromGroup(1L, groupName1, groupName3);
        DirectoryManagerGenericNestedGroupsTest.assertEquals((int)1, (int)this.directoryManager.searchDirectGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
        DirectoryManagerGenericNestedGroupsTest.assertEquals((int)2, (int)this.directoryManager.searchNestedGroupRelationships(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName3).returningAtMost(-1)).size());
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }
}

