/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.token;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.util.persistence.PersistenceException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public abstract class TokenDAOTester
extends BaseSpringTestCase {
    protected static final String TOKEN_KEY = "oFpXcZ2lfvtc0YQBgE1EeA00";
    protected TokenDAO tokenDAO;
    protected static final long DIRECTORY_ID = 1L;
    protected static final long RANDOM_NUMBER = 123456L;
    protected static final Long TOKEN_ID = 491522L;

    public void testAdd() throws PersistenceException {
        Token token = new Token(1L, "admin", "hash", 123456L, TOKEN_KEY);
        Token returnedToken = this.tokenDAO.add(token);
        TokenDAOTester.assertNotNull((Object)returnedToken);
    }

    public void testUpdate() throws Exception {
        Token token = this.tokenDAO.findByRandomHash(TOKEN_KEY);
        Date originalDate = new Date(token.getLastAccessedDate().getTime());
        Token returnedToken = this.tokenDAO.update(token);
        TokenDAOTester.assertNotNull((Object)returnedToken);
        Date nextMillisecondFromNow = new Date(System.currentTimeMillis() + 1L);
        TokenDAOTester.assertTrue((String)("now: " + nextMillisecondFromNow.getTime() + ", lastAccessed:" + returnedToken.getLastAccessedDate().getTime()), (boolean)returnedToken.getLastAccessedDate().before(nextMillisecondFromNow));
        TokenDAOTester.assertTrue((String)("originalDate: " + originalDate + ", lastAccessed:" + returnedToken.getLastAccessedDate()), (boolean)returnedToken.getLastAccessedDate().after(originalDate));
    }

    public void testRemove() throws PersistenceException {
        Token token = null;
        try {
            token = this.tokenDAO.findByRandomHash(TOKEN_KEY);
        }
        catch (ObjectNotFoundException e) {
            // empty catch block
        }
        this.tokenDAO.remove(token);
        try {
            token = this.tokenDAO.findByRandomHash(TOKEN_KEY);
            TokenDAOTester.fail((String)"The token should of been removed");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveByName() {
        this.tokenDAO.remove(1L, "admin");
        List list = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.NAME).exactlyMatching((Object)"admin")).returningAtMost(10));
        TokenDAOTester.assertTrue((String)("List size: " + list.size()), (boolean)list.isEmpty());
    }

    public void testSearch() throws PersistenceException {
        List tokens = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(10));
        TokenDAOTester.assertNotNull((Object)tokens);
        TokenDAOTester.assertFalse((boolean)tokens.isEmpty());
    }

    public void testSearchForPrincipalTokensByDirectoryId() {
        List list = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)1L)).returningAtMost(10));
        TokenDAOTester.assertNotNull((Object)list);
        TokenDAOTester.assertEquals((int)2, (int)list.size());
        boolean correctTokens = false;
        for (Token token : list) {
            correctTokens = "admin".equals(token.getName()) || "user".equals(token.getName());
        }
        TokenDAOTester.assertTrue((boolean)correctTokens);
    }

    public void testSearchForApplicationTokens() {
        List list = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)-1L)).returningAtMost(10));
        TokenDAOTester.assertNotNull((Object)list);
        TokenDAOTester.assertEquals((int)1, (int)list.size());
        boolean correctTokens = false;
        for (Token token : list) {
            correctTokens = "crowd".equals(token.getName());
        }
        TokenDAOTester.assertTrue((boolean)correctTokens);
    }

    public void testSearchForPrincipalTokenByName() {
        EntityQuery query = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)TokenTermKeys.NAME).exactlyMatching((Object)"admin"), Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).greaterThan((Object)-1L)})).returningAtMost(10);
        List list = this.tokenDAO.search(query);
        TokenDAOTester.assertNotNull((Object)list);
        TokenDAOTester.assertEquals((int)1, (int)list.size());
        TokenDAOTester.assertEquals((String)"admin", (String)((Token)list.get(0)).getName());
    }

    public void testSearchByExpirationDate() throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        EntityQuery query = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.LAST_ACCESSED_DATE).lessThan((Object)sdf.parse("25-01-2009 11:30:00"))).returningAtMost(10);
        List list = this.tokenDAO.search(query);
        TokenDAOTester.assertNotNull((Object)list);
        TokenDAOTester.assertEquals((int)2, (int)list.size());
    }

    public void testSearchWithIndexConstraints() {
        List tokenList = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1));
        TokenDAOTester.assertNotNull((Object)tokenList);
        TokenDAOTester.assertEquals((int)1, (int)tokenList.size());
    }

    public void testSearchWithIndexConstraintsSkippingTheFirstResult() {
        List tokenList = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).startingAt(1).returningAtMost(20));
        TokenDAOTester.assertNotNull((Object)tokenList);
        TokenDAOTester.assertEquals((int)2, (int)tokenList.size());
    }

    public void testSearchForTokenBySecretNumber() {
        List tokenList = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.RANDOM_NUMBER).exactlyMatching((Object)1234567890L)).returningAtMost(10));
        TokenDAOTester.assertNotNull((Object)tokenList);
        TokenDAOTester.assertEquals((int)1, (int)tokenList.size());
        TokenDAOTester.assertEquals((long)1234567890L, (long)((Token)tokenList.get(0)).getRandomNumber());
    }

    public void testSearchForSecretNumberWhereSecretNumberIsEmpty() {
        List tokenList = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.RANDOM_NUMBER).exactlyMatching((Object)0L)).returningAtMost(10));
        TokenDAOTester.assertNotNull((Object)tokenList);
        TokenDAOTester.assertEquals((int)1, (int)tokenList.size());
        TokenDAOTester.assertEquals((String)"user", (String)((Token)tokenList.get(0)).getName());
    }

    public void testRemoveAllByDirectory() {
        this.tokenDAO.removeAll(1L);
        List tokenList = this.tokenDAO.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)1L)).returningAtMost(10));
        TokenDAOTester.assertEquals((int)0, (int)tokenList.size());
    }

    public void testFindByID() throws Exception {
        Token token = this.tokenDAO.findByID(TOKEN_ID.longValue());
        TokenDAOTester.assertNotNull((Object)token);
        TokenDAOTester.assertEquals((Object)TOKEN_ID, (Object)token.getId());
    }

    public void testFindByKey() throws Exception {
        Token token = this.tokenDAO.findByRandomHash(TOKEN_KEY);
        TokenDAOTester.assertNotNull((Object)token);
        TokenDAOTester.assertEquals((String)TOKEN_KEY, (String)token.getRandomHash());
    }

    protected void setTokenDAO(TokenDAO tokenDAO) {
        this.tokenDAO = tokenDAO;
    }
}

