/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.application;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.application.ApplicationDAOHibernate;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.ApplicationTermKeys;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.hibernate.exception.ConstraintViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDAOHibernateTest
extends BaseSpringTestCase {
    private ApplicationDAOHibernate applicationDAO;
    private DirectoryDAOHibernate directoryDAO;
    private static final long APPLICATION_ID = 1L;
    private static final String APPLICATION_NAME_1 = "Crowd";
    private static final String APPLICATION_NAME_2 = "Application Too";
    private static final String APPLICATION_NAME_3 = "Third One";

    public void setApplicationDAO(ApplicationDAOHibernate applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public void setDirectoryDAO(DirectoryDAOHibernate directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    private Application buildBambooApplication() {
        return ApplicationImpl.newInstance((String)"Bamboo App", (ApplicationType)ApplicationType.BAMBOO);
    }

    public void testAddApplication() {
        Application application = this.buildBambooApplication();
        ApplicationImpl returnedApplication = this.applicationDAO.add(application, new PasswordCredential("hello", true));
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        ApplicationDAOHibernateTest.assertNotNull((Object)returnedApplication);
        ApplicationDAOHibernateTest.assertNotNull((Object)returnedApplication.getId());
        ApplicationDAOHibernateTest.assertTrue((boolean)returnedApplication.isActive());
        ApplicationDAOHibernateTest.assertEquals((Object)ApplicationType.BAMBOO, (Object)returnedApplication.getType());
        ApplicationDAOHibernateTest.assertEquals((String)"Bamboo App", (String)returnedApplication.getName());
        ApplicationDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"Bamboo App"), (String)returnedApplication.getLowerName());
        ApplicationDAOHibernateTest.assertNotNull((Object)returnedApplication.getCreatedDate());
        ApplicationDAOHibernateTest.assertNotNull((Object)returnedApplication.getUpdatedDate());
        ApplicationDAOHibernateTest.assertNull((Object)returnedApplication.getDescription());
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)returnedApplication.getAttributes().size());
        ApplicationDAOHibernateTest.assertTrue((boolean)returnedApplication.getDirectoryMappings().isEmpty());
        ApplicationDAOHibernateTest.assertTrue((boolean)returnedApplication.getRemoteAddresses().isEmpty());
    }

    public void testAddApplicationDuplicate() {
        ApplicationImpl application = ApplicationImpl.newInstance((String)APPLICATION_NAME_1, (ApplicationType)ApplicationType.CROWD);
        application.setActive(false);
        this.applicationDAO.add((Application)application, PasswordCredential.encrypted((String)"hello"));
        try {
            this.applicationDAO.getSessionFactory().getCurrentSession().flush();
            ApplicationDAOHibernateTest.fail((String)"ConstraintViolationException expected");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testAddApplicationIncomplete() {
        ApplicationImpl application = ApplicationImpl.newInstance((String)"some name", (ApplicationType)ApplicationType.GENERIC_APPLICATION);
        try {
            this.applicationDAO.add((Application)application, null);
            ApplicationDAOHibernateTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddApplicationIncorrectPassword() {
        Application application = this.buildBambooApplication();
        try {
            this.applicationDAO.add(application, new PasswordCredential("hello", false));
            ApplicationDAOHibernateTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUpdateApplicationCredential() throws Exception {
        this.applicationDAO.updateCredential((Application)this.applicationDAO.findById(1L), PasswordCredential.encrypted((String)"encrypted-string"));
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((String)"encrypted-string", (String)updatedApplication.getCredential().getCredential());
    }

    public void testUpdateApplicationWithUnEncryptedCredential() throws Exception {
        try {
            this.applicationDAO.updateCredential((Application)this.applicationDAO.findById(1L), PasswordCredential.unencrypted((String)"encrypted-string"));
            ApplicationDAOHibernateTest.fail((String)"Credentials can only be saved if they are encrypted");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddApplicationWithNoPassword() {
        Application application = this.buildBambooApplication();
        try {
            this.applicationDAO.add(application, null);
            ApplicationDAOHibernateTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindById() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertNotNull((Object)application.getId());
        ApplicationDAOHibernateTest.assertEquals((String)APPLICATION_NAME_1, (String)application.getName());
        ApplicationDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)APPLICATION_NAME_1), (String)application.getLowerName());
        ApplicationDAOHibernateTest.assertEquals((String)"Crowd Security Server and Console", (String)application.getDescription());
        ApplicationDAOHibernateTest.assertEquals((Object)ApplicationType.CROWD, (Object)application.getType());
        ApplicationDAOHibernateTest.assertTrue((boolean)application.isActive());
        ApplicationDAOHibernateTest.assertEquals((String)"h4$|-|3dp455w0r|)", (String)application.getCredential().getCredential());
        ApplicationDAOHibernateTest.assertEquals((String)"Ten", (String)application.getValue("Number"));
        ApplicationDAOHibernateTest.assertEquals((String)"Red", (String)application.getValue("color"));
        ApplicationDAOHibernateTest.assertEquals((int)2, (int)application.getKeys().size());
        ApplicationDAOHibernateTest.assertEquals((int)2, (int)application.getDirectoryMappings().size());
        for (DirectoryMapping mapping : application.getDirectoryMappings()) {
            if (mapping.getDirectory().getId() == 1L) {
                ApplicationDAOHibernateTest.assertEquals((int)3, (int)mapping.getAuthorisedGroups().size());
                for (GroupMapping groupMapping : mapping.getAuthorisedGroups()) {
                    ApplicationDAOHibernateTest.assertEquals((Object)application, (Object)groupMapping.getApplication());
                    ApplicationDAOHibernateTest.assertEquals((Object)new Long(1L), (Object)groupMapping.getDirectory().getId());
                    ApplicationDAOHibernateTest.assertTrue((boolean)Arrays.asList("administrators", "developers", "users").contains(groupMapping.getGroupName()));
                }
                ApplicationDAOHibernateTest.assertEquals((int)2, (int)mapping.getAllowedOperations().size());
                ApplicationDAOHibernateTest.assertTrue((boolean)mapping.getAllowedOperations().contains(OperationType.CREATE_GROUP));
                ApplicationDAOHibernateTest.assertTrue((boolean)mapping.getAllowedOperations().contains(OperationType.CREATE_USER));
                continue;
            }
            if (mapping.getDirectory().getId() == 2L) {
                ApplicationDAOHibernateTest.assertEquals((int)1, (int)mapping.getAuthorisedGroups().size());
                ApplicationDAOHibernateTest.assertEquals((int)0, (int)mapping.getAllowedOperations().size());
                continue;
            }
            ApplicationDAOHibernateTest.fail((String)"Directory mapping not found");
        }
        ApplicationDAOHibernateTest.assertEquals((int)3, (int)application.getRemoteAddresses().size());
        for (RemoteAddress remoteAddress : application.getRemoteAddresses()) {
            ApplicationDAOHibernateTest.assertTrue((boolean)Arrays.asList("127.0.0.1", "127.0.0.2", "127.0.0.3").contains(remoteAddress.getAddress()));
        }
    }

    public void testFindByIdNotFound() {
        try {
            this.applicationDAO.findById(-1L);
            ApplicationDAOHibernateTest.fail((String)"ApplicationNotFoundException expected");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
    }

    public void testFindByName() throws Exception {
        ApplicationImpl application = this.applicationDAO.findByName(APPLICATION_NAME_2.toUpperCase());
        ApplicationDAOHibernateTest.assertNotNull((Object)application.getId());
        ApplicationDAOHibernateTest.assertEquals((String)APPLICATION_NAME_2, (String)application.getName());
        ApplicationDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)APPLICATION_NAME_2), (String)application.getLowerName());
        ApplicationDAOHibernateTest.assertEquals((String)"Another Simple Application", (String)application.getDescription());
        ApplicationDAOHibernateTest.assertEquals((String)"hashmash", (String)application.getCredential().getCredential());
        ApplicationDAOHibernateTest.assertEquals((Object)ApplicationType.BAMBOO, (Object)application.getType());
        ApplicationDAOHibernateTest.assertFalse((boolean)application.isActive());
        ApplicationDAOHibernateTest.assertTrue((boolean)application.getAttributes().isEmpty());
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)application.getDirectoryMappings().size());
        ApplicationDAOHibernateTest.assertTrue((boolean)application.getRemoteAddresses().isEmpty());
    }

    public void testFindByNameNotFound() {
        try {
            this.applicationDAO.findByName("bogus");
            ApplicationDAOHibernateTest.fail((String)"ApplicationNotFoundException expected");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateApplication() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        application.setActive(false);
        application.setName("New Application");
        application.setCredential(new PasswordCredential("password", true));
        application.setType(ApplicationType.FISHEYE);
        application.setDescription(null);
        this.applicationDAO.update((Application)application);
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((String)"New Application", (String)updatedApplication.getName());
        ApplicationDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"New Application"), (String)updatedApplication.getLowerName());
        ApplicationDAOHibernateTest.assertNull((Object)updatedApplication.getDescription());
        ApplicationDAOHibernateTest.assertEquals((String)"password", (String)updatedApplication.getCredential().getCredential());
        ApplicationDAOHibernateTest.assertEquals((Object)ApplicationType.FISHEYE, (Object)updatedApplication.getType());
        ApplicationDAOHibernateTest.assertFalse((boolean)updatedApplication.isActive());
        ApplicationDAOHibernateTest.assertEquals((String)"Ten", (String)updatedApplication.getValue("Number"));
        ApplicationDAOHibernateTest.assertEquals((String)"Red", (String)updatedApplication.getValue("color"));
        ApplicationDAOHibernateTest.assertEquals((int)2, (int)updatedApplication.getKeys().size());
        ApplicationDAOHibernateTest.assertEquals((int)2, (int)updatedApplication.getDirectoryMappings().size());
        ApplicationDAOHibernateTest.assertEquals((int)3, (int)updatedApplication.getRemoteAddresses().size());
    }

    private DirectoryImpl loadDirectory(Long id) throws DirectoryNotFoundException {
        return this.directoryDAO.findById(id.longValue());
    }

    public void testUpdateApplicationWithBellsAndWhistles() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        application.setActive(false);
        application.setName("New Application");
        application.setType(ApplicationType.BAMBOO);
        application.setDescription(null);
        application.setAttribute("Number", "one");
        DirectoryImpl dir = this.loadDirectory(3L);
        application.getDirectoryMappings().add(new DirectoryMapping((Application)application, (Directory)dir, true));
        application.getDirectoryMapping(1L).getAuthorisedGroups().clear();
        application.getDirectoryMapping(1L).getAllowedOperations().add(OperationType.DELETE_USER);
        application.addRemoteAddress("10.0.0.1");
        this.applicationDAO.update((Application)application);
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        this.applicationDAO.getSessionFactory().getCurrentSession().clear();
        ApplicationImpl updatedApplication = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((String)"New Application", (String)updatedApplication.getName());
        ApplicationDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"New Application"), (String)updatedApplication.getLowerName());
        ApplicationDAOHibernateTest.assertNull((Object)updatedApplication.getDescription());
        ApplicationDAOHibernateTest.assertEquals((Object)ApplicationType.BAMBOO, (Object)updatedApplication.getType());
        ApplicationDAOHibernateTest.assertFalse((boolean)updatedApplication.isActive());
        ApplicationDAOHibernateTest.assertEquals((String)"one", (String)updatedApplication.getValue("Number"));
        ApplicationDAOHibernateTest.assertEquals((String)"Red", (String)updatedApplication.getValue("color"));
        ApplicationDAOHibernateTest.assertEquals((int)2, (int)updatedApplication.getKeys().size());
        ApplicationDAOHibernateTest.assertEquals((int)3, (int)updatedApplication.getDirectoryMappings().size());
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)updatedApplication.getDirectoryMapping(1L).getAuthorisedGroups().size());
        ApplicationDAOHibernateTest.assertEquals((int)3, (int)updatedApplication.getDirectoryMapping(1L).getAllowedOperations().size());
        ApplicationDAOHibernateTest.assertEquals((int)4, (int)updatedApplication.getRemoteAddresses().size());
    }

    public void testRemove() throws Exception {
        ApplicationImpl application = this.applicationDAO.findById(1L);
        this.applicationDAO.remove((Application)application);
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        try {
            this.applicationDAO.findById(1L);
            ApplicationDAOHibernateTest.fail((String)"ApplicationNotFoundException expected");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
    }

    public void testAddDirectoryMapping() throws Exception {
        this.applicationDAO.addDirectoryMapping(1L, 3L, true, new OperationType[]{OperationType.CREATE_GROUP, OperationType.CREATE_USER, OperationType.CREATE_ROLE});
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(3L);
        ApplicationDAOHibernateTest.assertNotNull((Object)directoryMapping);
        ApplicationDAOHibernateTest.assertNotNull((Object)directoryMapping.getId());
        ApplicationDAOHibernateTest.assertEquals((Object)new Long(3L), (Object)directoryMapping.getDirectory().getId());
        ApplicationDAOHibernateTest.assertTrue((boolean)directoryMapping.isAllowAllToAuthenticate());
        ApplicationDAOHibernateTest.assertEquals((int)3, (int)directoryMapping.getAllowedOperations().size());
        ApplicationDAOHibernateTest.assertTrue((boolean)directoryMapping.getAllowedOperations().containsAll(Sets.newHashSet((Object[])new OperationType[]{OperationType.CREATE_USER, OperationType.CREATE_ROLE})));
    }

    public void testAddGroupMapping() throws Exception {
        this.applicationDAO.addGroupMapping(1L, 2L, "testers");
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(2L);
        Set authorisedGroups = directoryMapping.getAuthorisedGroups();
        ApplicationDAOHibernateTest.assertEquals((int)2, (int)authorisedGroups.size());
        Collection groupNames = Collections2.transform((Collection)authorisedGroups, (Function)new Function<GroupMapping, String>(){

            public String apply(GroupMapping groupMapping) {
                Assert.assertNotNull((Object)groupMapping.getId());
                return groupMapping.getGroupName();
            }
        });
        ApplicationDAOHibernateTest.assertTrue((boolean)groupNames.containsAll(Sets.newHashSet((Object[])new String[]{"testers", "developers"})));
    }

    public void testRemoveDirectoryMappingFromApplication() throws Exception {
        this.applicationDAO.removeDirectoryMapping(1L, 2L);
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)application.getDirectoryMappings().size());
    }

    public void testRemoveDirectoryMappingFromApplicationMultipleApplications() throws Exception {
        this.applicationDAO.removeDirectoryMappings(2L);
        ApplicationImpl application1 = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)application1.getDirectoryMappings().size());
        ApplicationImpl application2 = this.applicationDAO.findById(2L);
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)application2.getDirectoryMappings().size());
    }

    public void testRemoveGroupMapping() throws Exception {
        this.applicationDAO.removeGroupMapping(1L, 1L, "users");
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertFalse((boolean)application.getDirectoryMapping(1L).isAuthorised("users"));
        ApplicationDAOHibernateTest.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("developers"));
        ApplicationDAOHibernateTest.assertTrue((boolean)application.getDirectoryMapping(1L).isAuthorised("administrators"));
    }

    public void testRemoveAllGroupMappingsForAGroup() throws Exception {
        this.applicationDAO.removeGroupMappings(2L, "developers");
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertFalse((boolean)application.getDirectoryMapping(2L).isAuthorised("developers"));
        ApplicationImpl application2 = this.applicationDAO.findById(2L);
        ApplicationDAOHibernateTest.assertFalse((boolean)application2.getDirectoryMapping(2L).isAuthorised("developers"));
    }

    public void testAddRemoteAddress() throws Exception {
        RemoteAddress remoteAddress = new RemoteAddress("192.168.1.1");
        this.applicationDAO.addRemoteAddress(1L, remoteAddress);
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertTrue((boolean)application.getRemoteAddresses().contains(remoteAddress));
    }

    public void testRemoveRemoteAddress() throws Exception {
        RemoteAddress remoteAddress = new RemoteAddress("127.0.0.1");
        this.applicationDAO.removeRemoteAddress(1L, remoteAddress);
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertFalse((boolean)application.getRemoteAddresses().contains(remoteAddress));
    }

    public void testUpdateDirectoryMappingPosition() throws Exception {
        this.applicationDAO.updateDirectoryMapping(1L, 2L, 0);
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        this.applicationDAO.getSessionFactory().getCurrentSession().clear();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((long)2L, (long)((DirectoryMapping)application.getDirectoryMappings().get(0)).getDirectory().getId());
        ApplicationDAOHibernateTest.assertEquals((long)1L, (long)((DirectoryMapping)application.getDirectoryMappings().get(1)).getDirectory().getId());
    }

    public void testUpdateDirectoryMappingPositionWithNegativePosition() throws Exception {
        this.applicationDAO.updateDirectoryMapping(1L, 2L, -1);
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        this.applicationDAO.getSessionFactory().getCurrentSession().clear();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((long)1L, (long)((DirectoryMapping)application.getDirectoryMappings().get(0)).getDirectory().getId());
        ApplicationDAOHibernateTest.assertEquals((long)2L, (long)((DirectoryMapping)application.getDirectoryMappings().get(1)).getDirectory().getId());
    }

    public void testUpdateDirectoryMappingPositionWithUnboundedPosition() throws Exception {
        this.applicationDAO.updateDirectoryMapping(1L, 1L, 3);
        this.applicationDAO.getSessionFactory().getCurrentSession().flush();
        this.applicationDAO.getSessionFactory().getCurrentSession().clear();
        ApplicationImpl application = this.applicationDAO.findById(1L);
        ApplicationDAOHibernateTest.assertEquals((long)1L, (long)((DirectoryMapping)application.getDirectoryMappings().get(0)).getDirectory().getId());
        ApplicationDAOHibernateTest.assertEquals((long)2L, (long)((DirectoryMapping)application.getDirectoryMappings().get(1)).getDirectory().getId());
    }

    public void testFindAuthorisedApplicationsMatchByGroup() {
        Long directoryId = 1L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("users"));
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)applications.size());
        ApplicationDAOHibernateTest.assertEquals((String)"crowd", (String)((ApplicationImpl)applications.get(0)).getLowerName());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("administrators"));
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)applications.size());
        ApplicationDAOHibernateTest.assertEquals((String)"crowd", (String)((ApplicationImpl)applications.get(0)).getLowerName());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("developers"));
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)applications.size());
        ApplicationDAOHibernateTest.assertEquals((String)"crowd", (String)((ApplicationImpl)applications.get(0)).getLowerName());
    }

    public void testFindAuthorisedApplicationsNoMatchByGroup() {
        Long directoryId = 1L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("bogus"));
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), new ArrayList());
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)applications.size());
    }

    public void testFindAuthorisedApplicationsMatchByDirectoryAllowAll() {
        Long directoryId = 2L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("bogus"));
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("administrators"));
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), new ArrayList());
        ApplicationDAOHibernateTest.assertEquals((int)1, (int)applications.size());
    }

    public void testFindAuthorisedApplicationsNoMatchByDirectoryAllowAll() {
        Long directoryId = 3L;
        List applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("bogus"));
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), Arrays.asList("administrators"));
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)applications.size());
        applications = this.applicationDAO.findAuthorisedApplications(directoryId.longValue(), new ArrayList());
        ApplicationDAOHibernateTest.assertEquals((int)0, (int)applications.size());
    }

    public void testSearchAll() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(10));
        this.assertContainsExactly(applications, APPLICATION_NAME_1, APPLICATION_NAME_2, APPLICATION_NAME_3);
    }

    public void testSearchByNameStartingWith() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.NAME).startingWith((Object)"application")).returningAtMost(10));
        this.assertContainsExactly(applications, APPLICATION_NAME_2);
    }

    public void testSearchByNameContaining() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.NAME).containing((Object)"d")).returningAtMost(10));
        this.assertContainsExactly(applications, APPLICATION_NAME_1, APPLICATION_NAME_3);
    }

    public void testSearchByActive() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(10));
        this.assertContains(applications, APPLICATION_NAME_1);
    }

    public void testSearchByType() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Restriction.on((Property)ApplicationTermKeys.TYPE).exactlyMatching((Object)ApplicationType.BAMBOO)).returningAtMost(10));
        this.assertContains(applications, APPLICATION_NAME_2);
    }

    public void testSearchNestedQuery() {
        List applications = this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)ApplicationTermKeys.NAME).startingWith((Object)"CR"), Restriction.on((Property)ApplicationTermKeys.ACTIVE).exactlyMatching((Object)true)}), Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)ApplicationTermKeys.ACTIVE).exactlyMatching((Object)false), Restriction.on((Property)ApplicationTermKeys.TYPE).exactlyMatching((Object)ApplicationType.BAMBOO)})})).returningAtMost(10));
        this.assertContainsExactly(applications, APPLICATION_NAME_1, APPLICATION_NAME_2);
    }

    private void assertContainsExactly(List<Application> applications, String ... applicationnames) {
        ApplicationDAOHibernateTest.assertEquals((int)applicationnames.length, (int)applications.size());
        for (String applicationname : applicationnames) {
            this.assertContains(applications, applicationname);
        }
    }

    private void assertContains(List<Application> applications, String applicationname) {
        ApplicationDAOHibernateTest.assertTrue((String)("Application " + applicationname + " not found in " + applications), (boolean)this.contains(applications, applicationname));
    }

    private boolean contains(List<Application> applications, String applicationname) {
        for (Application application : applications) {
            if (!application.getName().equals(applicationname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }
}

