/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.List;
import java.util.Properties;

public abstract class GroupRoleTest
extends BaseTest {
    private static final String GROUP_NAME = "group-group";
    private static final String ROLE_NAME = "group-role";
    private static final String USER_NAME = "mysupercooluser";

    protected void configureDirectory(Properties directorySettings) {
        super.configureDirectory(directorySettings);
        this.directory.setAttribute("ldap.roles.disabled", "false");
        this.directory.setAttribute("ldap.role.dn", "ou=roles");
        this.directory.setAttribute("ldap.group.dn", "ou=groups");
    }

    protected void removeTestData() {
        this.removeGroup(GROUP_NAME);
        this.removeRole(ROLE_NAME);
    }

    protected void loadTestData() throws Exception {
        GroupTemplate group = new GroupTemplate(GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
        Group addedGroup = this.directory.getImplementation().addGroup(group);
        GroupRoleTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)addedGroup.getDirectoryId());
        GroupRoleTest.assertEquals((String)group.getName(), (String)addedGroup.getName());
        GroupRoleTest.assertEquals((Object)group.getType(), (Object)addedGroup.getType());
        GroupTemplate role = new GroupTemplate(ROLE_NAME, this.directory.getId().longValue(), GroupType.LEGACY_ROLE);
        Group addedRole = this.directory.getImplementation().addGroup(role);
        GroupRoleTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)addedRole.getDirectoryId());
        GroupRoleTest.assertEquals((String)role.getName(), (String)addedRole.getName());
        GroupRoleTest.assertEquals((Object)role.getType(), (Object)addedRole.getType());
    }

    public void testFindGroupOfAnyType() throws Exception {
        Group group = this.directory.getImplementation().findGroupByName(GROUP_NAME);
        GroupRoleTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)group.getDirectoryId());
        GroupRoleTest.assertEquals((String)GROUP_NAME, (String)group.getName());
        GroupRoleTest.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
        Group role = this.directory.getImplementation().findGroupByName(ROLE_NAME);
        GroupRoleTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)role.getDirectoryId());
        GroupRoleTest.assertEquals((String)ROLE_NAME, (String)role.getName());
        GroupRoleTest.assertEquals((Object)GroupType.LEGACY_ROLE, (Object)role.getType());
        List containers = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group(null)).returningAtMost(-1));
        GroupRoleTest.assertEquals((int)2, (int)containers.size());
    }

    public void testFindGroupOfTypeRole() throws OperationFailedException {
        List roles = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).returningAtMost(-1));
        GroupRoleTest.assertEquals((int)1, (int)roles.size());
        Group role = (Group)roles.get(0);
        GroupRoleTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)role.getDirectoryId());
        GroupRoleTest.assertEquals((String)ROLE_NAME, (String)role.getName());
        GroupRoleTest.assertEquals((Object)GroupType.LEGACY_ROLE, (Object)role.getType());
    }

    public void testFindGroupOfTypeGroup() throws OperationFailedException {
        List groups = this.directory.getImplementation().searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        GroupRoleTest.assertEquals((int)1, (int)groups.size());
        Group group = (Group)groups.get(0);
        GroupRoleTest.assertEquals((long)this.directory.getImplementation().getDirectoryId(), (long)group.getDirectoryId());
        GroupRoleTest.assertEquals((String)GROUP_NAME, (String)group.getName());
        GroupRoleTest.assertEquals((Object)GroupType.GROUP, (Object)group.getType());
    }

    public void testAddGroupWithNoTypeFail() throws Exception {
        GroupTemplate group = new GroupTemplate("new group", this.directory.getId().longValue(), GroupType.GROUP);
        group.setType(null);
        try {
            this.directory.getImplementation().addGroup(group);
            GroupRoleTest.fail((String)"InvalidGroupException expected");
        }
        catch (InvalidGroupException e) {
            GroupRoleTest.assertTrue((boolean)true);
        }
    }
}

