/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.List;

public class DnRangeTest
extends BaseTest {
    private static final String LARGE_GROUP_NAME = "DnRangeTest-LargeGroup";
    private static final String SMALL_GROUP_NAME = "DnRangeTest-SmallGroup";
    private static final String PASSWORD = "Test-Password-123";
    private static final String USERNAME_PREFIX = "dnRange-user-";
    private static final int LARGE_GROUP_SIZE = 1600;
    private static final int SMALL_GROUP_SIZE = 30;

    public void testBrowseGroups() throws Exception {
        this._testBrowseLargeGroup();
        this._testBrowseSmallGroup();
    }

    public void _testBrowseLargeGroup() throws Exception {
        this.logger.info((Object)"Testing _testBrowseLargeGroup");
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(LARGE_GROUP_NAME).returningAtMost(-1);
        this.directory.setAttribute("ldap.usermembership.use", "false");
        this.syncIfCacheEnabled();
        List userMembersViaMemberDn = this.getRemoteDirectory().searchGroupRelationships(membershipQuery);
        this.directory.setAttribute("ldap.usermembership.use", "true");
        this.syncIfCacheEnabled();
        List userMembersViaMemberOf = this.getRemoteDirectory().searchGroupRelationships(membershipQuery);
        DnRangeTest.assertEquals((int)1600, (int)userMembersViaMemberDn.size());
        DnRangeTest.assertEquals((int)1600, (int)userMembersViaMemberOf.size());
    }

    public void _testBrowseSmallGroup() throws Exception {
        this.logger.info((Object)"Testing _testBrowseSmallGroup");
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(SMALL_GROUP_NAME).returningAtMost(-1);
        this.directory.setAttribute("ldap.usermembership.use", "false");
        this.syncIfCacheEnabled();
        List userMembersViaMemberDn = this.getRemoteDirectory().searchGroupRelationships(membershipQuery);
        this.directory.setAttribute("ldap.usermembership.use", "true");
        this.syncIfCacheEnabled();
        List userMembersViaMemberOf = this.getRemoteDirectory().searchGroupRelationships(membershipQuery);
        DnRangeTest.assertEquals((int)30, (int)userMembersViaMemberDn.size());
        DnRangeTest.assertEquals((int)30, (int)userMembersViaMemberOf.size());
    }

    private void syncIfCacheEnabled() throws OperationFailedException {
        if (this.getRemoteDirectory() instanceof SynchronisableDirectory) {
            this.setComplete();
            this.endTransaction();
            this.startNewTransaction();
            ((SynchronisableDirectory)this.getRemoteDirectory()).synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
        }
    }

    protected void removeTestData() {
        try {
            if (this.getRemoteDirectory().findGroupByName(LARGE_GROUP_NAME) != null) {
                for (int i = 0; i < 1600; ++i) {
                    this.removeUser(USERNAME_PREFIX + i);
                }
                this.removeGroup(LARGE_GROUP_NAME);
                this.removeGroup(SMALL_GROUP_NAME);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadTestData() throws Exception {
        int i;
        this.setComplete();
        this.endTransaction();
        this.startNewTransaction();
        GroupTemplate largeGroup = new GroupTemplate(LARGE_GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(largeGroup);
        GroupTemplate smallGroup = new GroupTemplate(SMALL_GROUP_NAME, this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(smallGroup);
        for (i = 0; i < 1600; ++i) {
            this.addUser(USERNAME_PREFIX + i, this.directory.getId(), PASSWORD);
            this.getRemoteDirectory().addUserToGroup(USERNAME_PREFIX + i, LARGE_GROUP_NAME);
        }
        for (i = 0; i < 30; ++i) {
            this.getRemoteDirectory().addUserToGroup(USERNAME_PREFIX + i, SMALL_GROUP_NAME);
        }
    }
}

