/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.utils.AbstractDbCachingLoadTest;
import com.atlassian.crowd.acceptance.utils.LoadStatWriter;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.OpenLDAP;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapperImpl;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelper;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelperImpl;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.password.factory.PasswordEncoderFactoryImpl;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslaterImpl;
import com.atlassian.crowd.util.InstanceFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.mockito.Mockito;

public class DbCachingLoadMutationTest
extends AbstractDbCachingLoadTest {
    private static final int SMALL_NUMBER_OF_USERS = 40;
    private static final int SMALL_NUMBER_OF_GROUPS = 30;
    private static final int SMALL_INITIAL_MEMBERSHIPS = 15;
    private static final int LARGE_NUMBER_OF_USERS = 80;
    private static final int LARGE_NUMBER_OF_GROUPS = 60;
    private static final int LARGE_INITIAL_MEMBERSHIPS = 30;
    private static final String MUTANT_USER_PREFIX = "mutant-user-";
    private static final String MUTANT_GROUP_PREFIX = "mutant-group-";
    private RemoteDirectory ldapDirectory;
    private LoadStatWriter statWriter;

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        this.ldapDirectory = this.createLDAPRemoteDirectory();
        this.statWriter = new LoadStatWriter(((Object)((Object)this)).getClass().getName());
    }

    public void tearDown() throws Exception {
        this.statWriter.close();
        this.restoreBaseSetup();
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testLargeMutations() throws Exception {
        this.logger.info((Object)"Running: testLargeMutations");
        this.createLoadTestingDirectory(CONNECTOR_URL, CONNECTOR_BASEDN, CONNECTOR_USERDN, CONNECTOR_USERPW);
        this.synchroniseDirectory("Perform initial sync after initial directory creation");
        long addLargeUsersGroupsMemberships = this._testAddLargeUsersGroupsMemberships();
        long removeLargeUsersGroupsMemberships = this._testRemoveLargeUsersGroupsMemberships();
        this.logger.info((Object)"");
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Mutating large set of users/groups within ou that contains 10k users, 1k groups");
        this.logger.info((Object)("#    Adding 80 users, 60 groups, 30 memberships per user took (in seconds):\t" + addLargeUsersGroupsMemberships));
        this.logger.info((Object)("#    Removing 80 users, 60 groups, 30 memberships per user took (in seconds):\t" + removeLargeUsersGroupsMemberships));
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"");
        this.statWriter.addPoint("testLargeMutations_adding_80_users_60_groups_30_memberships", addLargeUsersGroupsMemberships);
        this.statWriter.addPoint("testLargeMutations_removing_80_users_60_groups_30_memberships", removeLargeUsersGroupsMemberships);
    }

    private long _testAddLargeUsersGroupsMemberships() throws Exception {
        this.logger.info((Object)"Running _testAddLargeUsersGroupsMemberships");
        this.waitForExistingSyncToFinish();
        this.addUsersAndGroups(80, 60);
        this.createMemberships(80, 30);
        this._loginAdminUser();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        this.assertMutantUsersAndGroupsNotPresent();
        this.assertMembershipsNotPresent();
        long duration = this.synchroniseDirectory("Adding 80 users, 60 groups, 30 memberships");
        this.assertMutantUsersAndGroupsPresent();
        this.assertMembershipsPresent(30);
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        return duration;
    }

    private long _testRemoveLargeUsersGroupsMemberships() throws Exception {
        this.logger.info((Object)"Running _testRemoveLargeUsersGroupsMemberships");
        this.waitForExistingSyncToFinish();
        this.removeUsersAndGroups(80, 60);
        this._loginAdminUser();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        this.assertMutantUsersAndGroupsPresent();
        this.assertMembershipsPresent(30);
        long duration = this.synchroniseDirectory("Removing 80 users, 60 groups");
        this.assertMutantUsersAndGroupsNotPresent();
        this.assertMembershipsNotPresent();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        return duration;
    }

    public void testSmallMutations() throws Exception {
        this.logger.info((Object)"Running: testSmallMutations");
        this.createLoadTestingDirectory(CONNECTOR_URL, CONNECTOR_BASEDN, CONNECTOR_USERDN, CONNECTOR_USERPW);
        this.synchroniseDirectory("Perform initial sync after initial directory creation");
        long addUsersAndGroups = this._testAddUsersAndGroups();
        long addUserMemberships = this._testAddUserMemberships();
        long changeMemberships = this._testChangeUserMemberships();
        long removeUsersAndGroups = this._testRemoveUsersAndGroups();
        this.logger.info((Object)"");
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Mutating small set of users/groups within ou that contains 10k users, 1k groups");
        this.logger.info((Object)("#    Adding 40 users, 30 groups took (in seconds):\t\t" + addUsersAndGroups));
        this.logger.info((Object)("#    Adding users to 15 groups each took (in seconds):\t" + addUserMemberships));
        this.logger.info((Object)("#    Changing user memberships and user attributes took (in seconds):\t" + changeMemberships));
        this.logger.info((Object)("#    Removing 40 users, 30 groups took (in seconds):\t" + removeUsersAndGroups));
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"");
        this.statWriter.addPoint("testSmallMutations_adding_40_users_30_groups", addUsersAndGroups);
        this.statWriter.addPoint("testSmallMutations_adding_15_users", addUserMemberships);
        this.statWriter.addPoint("testSmallMutations_changing_user_memberships_and_user_attributes", changeMemberships);
        this.statWriter.addPoint("testSmallMutations_removing_40_users_30_groups", removeUsersAndGroups);
    }

    private long _testAddUsersAndGroups() throws Exception {
        this.logger.info((Object)"Running _testAddUsersAndGroups");
        this.waitForExistingSyncToFinish();
        this.addUsersAndGroups(40, 30);
        this._loginAdminUser();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        this.assertMutantUsersAndGroupsNotPresent();
        long duration = this.synchroniseDirectory("Adding 40 users, 30 groups");
        this.assertMutantUsersAndGroupsPresent();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        return duration;
    }

    private long _testAddUserMemberships() throws Exception {
        this.logger.info((Object)"Running _testAddUserMemberships");
        this.waitForExistingSyncToFinish();
        this.createMemberships(40, 15);
        this._loginAdminUser();
        this.assertMembershipsNotPresent();
        long duration = this.synchroniseDirectory("Adding users to 15 groups each");
        this.assertMembershipsPresent(15);
        return duration;
    }

    private long _testChangeUserMemberships() throws InterruptedException, MembershipNotFoundException, ReadOnlyGroupException, UserNotFoundException, GroupNotFoundException, OperationFailedException, InvalidUserException {
        int i;
        int groupIndex;
        int userIndex;
        this.logger.info((Object)"Running _testChangeUserMemberships");
        this.waitForExistingSyncToFinish();
        for (userIndex = 0; userIndex < 40; ++userIndex) {
            for (groupIndex = 0; groupIndex < 15; ++groupIndex) {
                this.ldapDirectory.removeUserFromGroup(MUTANT_USER_PREFIX + userIndex, MUTANT_GROUP_PREFIX + groupIndex);
            }
        }
        for (userIndex = 0; userIndex < 40; ++userIndex) {
            for (groupIndex = 15; groupIndex < 30; ++groupIndex) {
                this.ldapDirectory.addUserToGroup(MUTANT_USER_PREFIX + userIndex, MUTANT_GROUP_PREFIX + groupIndex);
            }
        }
        for (i = 0; i < 40; ++i) {
            User user = this.ldapDirectory.findUserByName(MUTANT_USER_PREFIX + i);
            UserTemplate userTemplate = new UserTemplate(user);
            userTemplate.setEmailAddress("new@example.com");
            userTemplate.setLastName("Mutated" + i);
            this.ldapDirectory.updateUser(userTemplate);
        }
        this._loginAdminUser();
        this.assertMembershipsPresent(15);
        for (i = 0; i < 40; ++i) {
            this.assertUserDetails(MUTANT_USER_PREFIX + i, "John", "Mutant" + i, "mutant" + i + "@example.com");
        }
        long duration = this.synchroniseDirectory("Removing users from 15 groups and adding to new 15 groups");
        this.assertMembershipsPresent(15);
        for (int i2 = 0; i2 < 10; ++i2) {
            this.assertUserDetails(MUTANT_USER_PREFIX + i2, "John", "Mutated" + i2, "new@example.com");
        }
        return duration;
    }

    private long _testRemoveUsersAndGroups() throws InterruptedException, ReadOnlyGroupException, UserNotFoundException, GroupNotFoundException, OperationFailedException {
        this.logger.info((Object)"Running _testRemoveUsersAndGroups");
        this.waitForExistingSyncToFinish();
        this.removeUsersAndGroups(40, 30);
        this._loginAdminUser();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        this.assertMutantUsersAndGroupsPresent();
        long duration = this.synchroniseDirectory("Removing 40 users, 30 groups");
        this.assertMutantUsersAndGroupsNotPresent();
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        return duration;
    }

    private void addUsersAndGroups(int numUsers, int numGroups) throws UserAlreadyExistsException, InvalidUserException, DirectoryNotFoundException, UserNotFoundException, InvalidCredentialException, OperationFailedException, InvalidGroupException, GroupNotFoundException {
        int i;
        for (i = 0; i < numUsers; ++i) {
            UserTemplate userTemplate = new UserTemplate(MUTANT_USER_PREFIX + i);
            userTemplate.setDisplayName("Mutant User" + i);
            userTemplate.setEmailAddress("mutant" + i + "@example.com");
            userTemplate.setFirstName("John");
            userTemplate.setLastName("Mutant" + i);
            this.ldapDirectory.addUser(userTemplate, new PasswordCredential("password"));
        }
        for (i = 0; i < numGroups; ++i) {
            this.ldapDirectory.addGroup(new GroupTemplate(MUTANT_GROUP_PREFIX + i));
        }
    }

    private void removeUsersAndGroups(int numUsers, int numGroups) throws UserNotFoundException, OperationFailedException, ReadOnlyGroupException, GroupNotFoundException {
        int i;
        for (i = 0; i < numUsers; ++i) {
            this.ldapDirectory.removeUser(MUTANT_USER_PREFIX + i);
        }
        for (i = 0; i < numGroups; ++i) {
            this.ldapDirectory.removeGroup(MUTANT_GROUP_PREFIX + i);
        }
    }

    private void createMemberships(int numUsers, int numMemberships) throws ReadOnlyGroupException, UserNotFoundException, GroupNotFoundException, OperationFailedException {
        for (int userIndex = 0; userIndex < numUsers; ++userIndex) {
            for (int groupIndex = 0; groupIndex < numMemberships; ++groupIndex) {
                this.ldapDirectory.addUserToGroup(MUTANT_USER_PREFIX + userIndex, MUTANT_GROUP_PREFIX + groupIndex);
            }
        }
    }

    private void assertUserDetails(String username, String firstname, String lastname, String email) {
        this.gotoViewPrincipal(username, "Test Connector Directory");
        this.assertTextFieldEquals("email", email);
        this.assertTextFieldEquals("firstname", firstname);
        this.assertTextFieldEquals("lastname", lastname);
    }

    private void assertMembershipsPresent(int membershipsCount) {
        for (int i = 0; i < 5; ++i) {
            this.gotoViewPrincipal(MUTANT_USER_PREFIX + i, "Test Connector Directory");
            this.clickLink("user-groups-tab");
            this.setWorkingForm("groupsForm");
            this.assertTableRowCountEquals("groupsTable", membershipsCount + 1);
            this.assertTextPresent("mutant-group");
        }
    }

    private void assertMembershipsNotPresent() {
        for (int i = 0; i < 5; ++i) {
            this.gotoViewPrincipal(MUTANT_USER_PREFIX + i, "Test Connector Directory");
            this.clickLink("user-groups-tab");
            this.assertKeyPresent("principal.nogroupmemberships.text", Arrays.asList(MUTANT_USER_PREFIX + i));
            this.assertTableNotPresent("groupsTable");
            this.assertTextNotPresent("mutant-group");
        }
    }

    private void assertMutantUsersAndGroupsNotPresent() {
        this.searchMutantUsers();
        this.assertTextNotPresent("mutant-user-0");
        this.assertTextNotPresent("mutant-user-1");
        this.assertTextNotPresent("mutant-user-5");
        this.searchMutantGroups();
        this.assertTextNotPresent("mutant-group-0");
        this.assertTextNotPresent("mutant-group-1");
        this.assertTextNotPresent("mutant-group-10");
    }

    private void assertMutantUsersAndGroupsPresent() {
        this.searchMutantUsers();
        this.assertTextPresent("mutant-user-0");
        this.assertTextPresent("mutant-user-1");
        this.assertTextPresent("mutant-user-5");
        this.searchMutantGroups();
        this.assertTextPresent("mutant-group-0");
        this.assertTextPresent("mutant-group-1");
        this.assertTextPresent("mutant-group-10");
    }

    private void searchMutantGroups() {
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.setTextField("name", "mutant-group");
        this.selectOption("directoryID", "Test Connector Directory");
        this.submit();
    }

    private void searchMutantUsers() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.setTextField("search", "mutant-user");
        this.selectOption("directoryID", "Test Connector Directory");
        this.submit();
    }

    private RemoteDirectory createLDAPRemoteDirectory() {
        HashMap<String, String> directoryAttributes = new HashMap<String, String>();
        directoryAttributes.put("ldap.url", CONNECTOR_URL);
        directoryAttributes.put("ldap.secure", CONNECTOR_SECURE);
        directoryAttributes.put("ldap.referral", CONNECTOR_REFERRAL);
        directoryAttributes.put("ldap.pagedresults", CONNECTOR_PAGEDRESULTS);
        directoryAttributes.put("ldap.pagedresults.size", CONNECTOR_PAGEDRESULTSSIZE);
        directoryAttributes.put("ldap.nestedgroups.disabled", CONNECTOR_NESTEDGROUPS);
        directoryAttributes.put("ldap.usermembership.use.for.groups", Boolean.toString(false));
        directoryAttributes.put("ldap.read.timeout", "0");
        directoryAttributes.put("ldap.search.timelimit", "0");
        directoryAttributes.put("ldap.connection.timeout", "3600000");
        directoryAttributes.put("directory.cache.synchronise.interval", "360000");
        directoryAttributes.put("ldap.relaxed.dn.standardisation", Boolean.toString(true));
        directoryAttributes.put("ldap.basedn", CONNECTOR_BASEDN);
        directoryAttributes.put("ldap.userdn", CONNECTOR_USERDN);
        directoryAttributes.put("ldap.password", CONNECTOR_USERPW);
        LDAPPropertiesHelperImpl ldapPropertiesHelperImpl = new LDAPPropertiesHelperImpl();
        Properties directorySchema = (Properties)ldapPropertiesHelperImpl.getConfigurationDetails().get(CONNECTOR_CLASSNAME);
        directoryAttributes.put("ldap.group.description", (String)directorySchema.get("ldap.group.description"));
        directoryAttributes.put("ldap.group.name", (String)directorySchema.get("ldap.group.name"));
        directoryAttributes.put("ldap.group.objectclass", (String)directorySchema.get("ldap.group.objectclass"));
        directoryAttributes.put("ldap.group.filter", (String)directorySchema.get("ldap.group.filter"));
        directoryAttributes.put("ldap.group.usernames", (String)directorySchema.get("ldap.group.usernames"));
        directoryAttributes.put("ldap.roles.disabled", Boolean.toString(true));
        directoryAttributes.put("ldap.role.description", (String)directorySchema.get("ldap.role.description"));
        directoryAttributes.put("ldap.role.name", (String)directorySchema.get("ldap.role.name"));
        directoryAttributes.put("ldap.role.objectclass", (String)directorySchema.get("ldap.role.objectclass"));
        directoryAttributes.put("ldap.role.filter", (String)directorySchema.get("ldap.role.filter"));
        directoryAttributes.put("ldap.role.usernames", (String)directorySchema.get("ldap.role.usernames"));
        directoryAttributes.put("ldap.user.email", (String)directorySchema.get("ldap.user.email"));
        directoryAttributes.put("ldap.user.firstname", (String)directorySchema.get("ldap.user.firstname"));
        directoryAttributes.put("ldap.user.group", (String)directorySchema.get("ldap.user.group"));
        directoryAttributes.put("ldap.user.lastname", (String)directorySchema.get("ldap.user.lastname"));
        directoryAttributes.put("ldap.user.displayname", (String)directorySchema.get("ldap.user.displayname"));
        directoryAttributes.put("ldap.user.objectclass", (String)directorySchema.get("ldap.user.objectclass"));
        directoryAttributes.put("ldap.user.filter", (String)directorySchema.get("ldap.user.filter"));
        directoryAttributes.put("ldap.user.username", (String)directorySchema.get("ldap.user.username"));
        directoryAttributes.put("ldap.user.username.rdn", (String)directorySchema.get("ldap.user.username.rdn"));
        directoryAttributes.put("ldap.user.password", (String)directorySchema.get("ldap.user.password"));
        InstanceFactory mockInstanceFactory = (InstanceFactory)Mockito.mock(InstanceFactory.class);
        Mockito.when((Object)mockInstanceFactory.getInstance(LDAPPropertiesMapperImpl.class)).thenReturn((Object)new LDAPPropertiesMapperImpl((LDAPPropertiesHelper)ldapPropertiesHelperImpl));
        Object remoteDirectory = this.getConnectorType().equals(OpenLDAP.getStaticDirectoryType()) ? new OpenLDAP((LDAPQueryTranslater)new LDAPQueryTranslaterImpl(), null, mockInstanceFactory, (PasswordEncoderFactory)new PasswordEncoderFactoryImpl()) : new MicrosoftActiveDirectory((LDAPQueryTranslater)new LDAPQueryTranslaterImpl(), null, mockInstanceFactory);
        remoteDirectory.setAttributes(directoryAttributes);
        return remoteDirectory;
    }
}

