/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.osuser;

import com.atlassian.crowd.acceptance.tests.client.NestedGroupsBase;
import com.atlassian.crowd.integration.osuser.CrowdAccessProvider;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CacheExpiryManager;
import com.atlassian.crowd.service.cache.CacheExpiryManagerImpl;
import com.atlassian.crowd.service.cache.CachingGroupManager;
import com.atlassian.crowd.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.service.cache.CachingUserManager;
import java.util.Collection;
import java.util.List;

public class NestedGroupsTest
extends NestedGroupsBase {
    CrowdAccessProvider accessProvider;

    protected void setupClientLibrary() throws Exception {
        CachingUserManager userManager = new CachingUserManager(this.securityServerClient, CachingManagerFactory.getCache());
        CachingGroupManager groupManager = new CachingGroupManager(this.securityServerClient, CachingManagerFactory.getCache());
        CachingGroupMembershipManager groupMembershipManager = new CachingGroupMembershipManager(this.securityServerClient, (UserManager)userManager, (GroupManager)groupManager, CachingManagerFactory.getCache());
        CacheExpiryManagerImpl cem = new CacheExpiryManagerImpl(CachingManagerFactory.getCache());
        this.accessProvider = new CrowdAccessProvider((UserManager)userManager, (GroupManager)groupManager, (GroupMembershipManager)groupMembershipManager, (CacheExpiryManager)cem);
        this.accessProvider.flushCaches();
    }

    public List getAllGroupNames() throws Exception {
        return this.accessProvider.list();
    }

    public List getUsersInGroup(String groupName) throws Exception {
        return this.accessProvider.listUsersInGroup(groupName);
    }

    public List getGroupsForUser(String userName) throws Exception {
        return this.accessProvider.listGroupsContainingUser(userName);
    }

    public boolean isInGroup(String userName, String groupName) throws Exception {
        return this.accessProvider.inGroup(userName, groupName);
    }

    public boolean removeUserFromGroup(String userName, String groupName) throws Exception {
        return this.accessProvider.removeFromGroup(userName, groupName);
    }

    public boolean isUserInList(Collection userList, String userName) {
        return userList.contains(userName);
    }

    public boolean isGroupInList(Collection groupList, String groupName) {
        return groupList.contains(groupName);
    }
}

