/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.atlassianuser;

import com.atlassian.crowd.acceptance.tests.client.NestedGroupsBase;
import com.atlassian.crowd.integration.atlassianuser.CrowdGroupManager;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingGroupManager;
import com.atlassian.crowd.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.service.cache.CachingUserManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import java.util.Collection;
import java.util.List;

public class NestedGroupsTest
extends NestedGroupsBase {
    CrowdGroupManager atlassianUserGroupManager;

    protected void setupClientLibrary() throws Exception {
        CachingUserManager userManager = new CachingUserManager(this.securityServerClient, CachingManagerFactory.getCache());
        CachingGroupManager groupManager = new CachingGroupManager(this.securityServerClient, CachingManagerFactory.getCache());
        CachingGroupMembershipManager groupMembershipManager = new CachingGroupMembershipManager(this.securityServerClient, (UserManager)userManager, (GroupManager)groupManager, CachingManagerFactory.getCache());
        this.atlassianUserGroupManager = new CrowdGroupManager((RepositoryIdentifier)new DefaultRepositoryIdentifier("a", "b"), (GroupManager)groupManager, (GroupMembershipManager)groupMembershipManager);
    }

    public List getAllGroupNames() throws Exception {
        Pager pager = this.atlassianUserGroupManager.getGroups();
        return pager.getCurrentPage();
    }

    public List getUsersInGroup(String groupName) throws Exception {
        Pager pager = this.atlassianUserGroupManager.getMemberNames((Group)new DefaultGroup(groupName));
        return pager.getCurrentPage();
    }

    public List getGroupsForUser(String userName) throws Exception {
        Pager pager = this.atlassianUserGroupManager.getGroups((User)new DefaultUser(userName));
        List list = pager.getCurrentPage();
        return list;
    }

    public boolean isInGroup(String userName, String groupName) throws Exception {
        return this.atlassianUserGroupManager.hasMembership((Group)new DefaultGroup(groupName), (User)new DefaultUser(userName));
    }

    public boolean removeUserFromGroup(String userName, String groupName) throws Exception {
        try {
            this.atlassianUserGroupManager.removeMembership((Group)new DefaultGroup(groupName), (User)new DefaultUser(userName));
            return true;
        }
        catch (EntityException e) {
            this.logger.info((Object)e);
            return false;
        }
    }

    public boolean isUserInList(Collection userList, String userName) {
        return userList.contains(userName);
    }

    public boolean isGroupInList(Collection groupList, String groupName) {
        return groupList.contains(new DefaultGroup(groupName));
    }
}

