/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.atlassianuser;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.integration.atlassianuser.CrowdUserManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.BasicCache;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.service.cache.CachingUserManager;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.password.Credential;
import java.util.Properties;

public class CrowdUserManagerTest
extends CrowdAcceptanceTestCase {
    private com.atlassian.user.UserManager atlassianUserManager;
    private static final long MAX_WAIT_TIME_MS = 10000L;
    private static final String USER_NAME_1 = "my-user-name";
    private static final String USER_EMAIL_1 = "bob@example.com";
    private static final String DISPLAY_NAME_1 = "Hi User";
    private static final String PASSWORD_1 = "xxx";
    private static final String USER_NAME_2 = "jbloggs";
    private static final String USER_EMAIL_2 = "jbloggs@testingarea.org";
    private static final String DISPLAY_NAME_2 = "Joe Bloggs";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("ldapclientlib.xml");
        DbCachingTestHelper.synchroniseDirectory(this.tester, "ApacheDS102", 10000L);
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        SecurityServerClientImpl ssc = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        BasicCache cache = CachingManagerFactory.getCache();
        CachingUserManager userManager = new CachingUserManager((SecurityServerClient)ssc, cache);
        this.atlassianUserManager = new CrowdUserManager((RepositoryIdentifier)new DefaultRepositoryIdentifier("a", "b"), (UserManager)userManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateUserAndUpdateAttributes() throws Exception {
        User user = this.atlassianUserManager.createUser((User)new DefaultUser(USER_NAME_1, "", ""), Credential.unencrypted((String)PASSWORD_1));
        try {
            DefaultUser updatedUser = new DefaultUser(user);
            updatedUser.setEmail(USER_EMAIL_1);
            updatedUser.setFullName(DISPLAY_NAME_1);
            this.atlassianUserManager.saveUser((User)updatedUser);
            User foundUser = this.atlassianUserManager.getUser(USER_NAME_1);
            CrowdUserManagerTest.assertNotNull((Object)foundUser);
            CrowdUserManagerTest.assertEquals((String)USER_NAME_1, (String)foundUser.getName());
            CrowdUserManagerTest.assertEquals((String)USER_EMAIL_1, (String)foundUser.getEmail());
            CrowdUserManagerTest.assertEquals((String)DISPLAY_NAME_1, (String)foundUser.getFullName());
        }
        finally {
            this.atlassianUserManager.removeUser(user);
        }
    }

    public void testUpdateUserAttributes_noChanges() throws Exception {
        User user = this.atlassianUserManager.getUser(USER_NAME_2);
        CrowdUserManagerTest.assertNotNull((Object)user);
        CrowdUserManagerTest.assertEquals((String)USER_NAME_2, (String)user.getName());
        CrowdUserManagerTest.assertEquals((String)USER_EMAIL_2, (String)user.getEmail());
        CrowdUserManagerTest.assertEquals((String)DISPLAY_NAME_2, (String)user.getFullName());
        this.atlassianUserManager.saveUser(user);
        User savedUser = this.atlassianUserManager.getUser(USER_NAME_2);
        CrowdUserManagerTest.assertEquals((String)USER_NAME_2, (String)savedUser.getName());
        CrowdUserManagerTest.assertEquals((String)USER_EMAIL_2, (String)savedUser.getEmail());
        CrowdUserManagerTest.assertEquals((String)DISPLAY_NAME_2, (String)savedUser.getFullName());
    }
}

