/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.atlassianuser;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.integration.atlassianuser.CrowdEntityQueryParser;
import com.atlassian.crowd.integration.atlassianuser.CrowdGroupManager;
import com.atlassian.crowd.integration.atlassianuser.CrowdUserManager;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingGroupManager;
import com.atlassian.crowd.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.service.cache.CachingUserManager;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.MultiTermBooleanQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.UserNameTermQuery;
import java.util.Properties;

public abstract class CrowdEntityQueryParserTest
extends CrowdAcceptanceTestCase {
    protected static CrowdEntityQueryParser queryParser;
    public static final String ADMIN = "admin";
    public static final String ALICE = "alice";
    public static final String BOB = "bob";
    public static final String CONFADMIN = "confadmin";
    public static final String SHIHAB = "shihab";
    public static final String CROWD_ADMIN_GROUP = "crowd-administrators";
    public static final String CONF_USER_GROUP = "confluence-users";
    public static final String CONF_ADMIN_GROUP = "confluence-administrators";

    public void setUp() throws Exception {
        super.setUp();
        if (!this.hasBeenSetUpOnce()) {
            this.setUpOnce();
        }
    }

    protected abstract boolean hasBeenSetUpOnce();

    protected void setUpOnce() throws Exception {
        Properties properties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl clientProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        SecurityServerClientImpl securityServerClient = new SecurityServerClientImpl((SoapClientProperties)clientProperties);
        CachingUserManager crowdUserManager = new CachingUserManager((SecurityServerClient)securityServerClient, CachingManagerFactory.getCache());
        CachingGroupManager crowdGroupManager = new CachingGroupManager((SecurityServerClient)securityServerClient, CachingManagerFactory.getCache());
        CachingGroupMembershipManager crowdGroupMembershipManager = new CachingGroupMembershipManager((SecurityServerClient)securityServerClient, (UserManager)crowdUserManager, (GroupManager)crowdGroupManager, CachingManagerFactory.getCache());
        DefaultRepositoryIdentifier repositoryIdentifier = new DefaultRepositoryIdentifier("test-crowd", "Test Crowd Repository");
        CrowdUserManager atlassianUserManager = new CrowdUserManager((RepositoryIdentifier)repositoryIdentifier, (UserManager)crowdUserManager);
        CrowdGroupManager atlassianGroupManager = new CrowdGroupManager((RepositoryIdentifier)repositoryIdentifier, (GroupManager)crowdGroupManager, (GroupMembershipManager)crowdGroupMembershipManager);
        queryParser = new CrowdEntityQueryParser((com.atlassian.user.UserManager)atlassianUserManager, (com.atlassian.user.GroupManager)atlassianGroupManager, (RepositoryIdentifier)repositoryIdentifier, (UserManager)crowdUserManager, (GroupManager)crowdGroupManager);
    }

    public void testSearchAllUsers() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new UserNameTermQuery(""));
        this.assertResultConsistsOf(result, ADMIN, ALICE, BOB, CONFADMIN, SHIHAB);
    }

    public void testSearchUsername_manyMatches() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new UserNameTermQuery(ADMIN));
        this.assertResultConsistsOf(result, ADMIN, CONFADMIN);
    }

    public void testSearchUsername_oneMatch() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new UserNameTermQuery(ALICE));
        this.assertResultConsistsOf(result, ALICE);
    }

    public void testSearchUsername_noMatch() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new UserNameTermQuery("bogus"));
        this.assertNoResults(result);
    }

    public void testSearchEmail_oneMatch() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new EmailTermQuery("shamid@atlassian.com"));
        this.assertResultConsistsOf(result, SHIHAB);
    }

    public void testSearchEmail_manyMatches() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new EmailTermQuery("@example.com"));
        this.assertResultConsistsOf(result, ADMIN, ALICE, BOB, CONFADMIN);
    }

    public void testSearchEmail_noMatch() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new EmailTermQuery("@boguss.com"));
        this.assertNoResults(result);
    }

    public void testSearchFullname_oneMatch() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new FullNameTermQuery("Alice Smith"));
        this.assertResultConsistsOf(result, ALICE);
    }

    public void testSearchFullname_manyMatches() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new FullNameTermQuery("smith"));
        this.assertResultConsistsOf(result, ALICE, BOB);
    }

    public void testSearchFullname_noMatch() throws EntityException {
        SearchResult result = queryParser.findUsers((Query)new FullNameTermQuery("I am Mr Schmoe"));
        this.assertNoResults(result);
    }

    public void testSearchUsernameAndEmailAndFullname_oneMatch() throws EntityException {
        UserNameTermQuery usernameQuery = new UserNameTermQuery(ADMIN);
        EmailTermQuery emailQuery = new EmailTermQuery(ADMIN);
        FullNameTermQuery fullnameQuery = new FullNameTermQuery(ADMIN);
        MultiTermBooleanQuery conjunctiveQuery = new MultiTermBooleanQuery(new Query[]{usernameQuery, emailQuery, fullnameQuery}, true);
        SearchResult result = queryParser.findUsers((Query)conjunctiveQuery);
        this.assertResultConsistsOf(result, CONFADMIN);
    }

    public void testSearchUsernameAndEmailAndFullname_manyMatches() throws EntityException {
        UserNameTermQuery usernameQuery = new UserNameTermQuery("A");
        EmailTermQuery emailQuery = new EmailTermQuery("A");
        FullNameTermQuery fullnameQuery = new FullNameTermQuery("A");
        MultiTermBooleanQuery conjunctiveQuery = new MultiTermBooleanQuery(new Query[]{usernameQuery, emailQuery, fullnameQuery}, true);
        SearchResult result = queryParser.findUsers((Query)conjunctiveQuery);
        this.assertResultConsistsOf(result, ALICE, CONFADMIN, SHIHAB);
    }

    public void testSearchUsernameAndEmailAndFullname_noMatch() throws EntityException {
        UserNameTermQuery usernameQuery = new UserNameTermQuery(ADMIN);
        EmailTermQuery emailQuery = new EmailTermQuery("@atlassian.com");
        FullNameTermQuery fullnameQuery = new FullNameTermQuery("Alice");
        MultiTermBooleanQuery conjunctiveQuery = new MultiTermBooleanQuery(new Query[]{usernameQuery, emailQuery, fullnameQuery}, true);
        SearchResult result = queryParser.findUsers((Query)conjunctiveQuery);
        this.assertNoResults(result);
    }

    public void testSearchUsernameOrEmailOrFullname_oneMatch() throws EntityException {
        UserNameTermQuery usernameQuery = new UserNameTermQuery(ALICE);
        EmailTermQuery emailQuery = new EmailTermQuery(ALICE);
        FullNameTermQuery fullnameQuery = new FullNameTermQuery(ALICE);
        MultiTermBooleanQuery disjunctiveQuery = new MultiTermBooleanQuery(new Query[]{usernameQuery, emailQuery, fullnameQuery}, false);
        SearchResult result = queryParser.findUsers((Query)disjunctiveQuery);
        this.assertResultConsistsOf(result, ALICE);
    }

    public void testSearchUsernameOrEmailOrFullname_manyMatches() throws EntityException {
        UserNameTermQuery usernameQuery = new UserNameTermQuery(ADMIN);
        EmailTermQuery emailQuery = new EmailTermQuery("@example.com");
        FullNameTermQuery fullnameQuery = new FullNameTermQuery(SHIHAB);
        MultiTermBooleanQuery disjunctiveQuery = new MultiTermBooleanQuery(new Query[]{usernameQuery, emailQuery, fullnameQuery}, false);
        SearchResult result = queryParser.findUsers((Query)disjunctiveQuery);
        this.assertResultConsistsOf(result, ADMIN, ALICE, BOB, CONFADMIN, SHIHAB);
    }

    public void testSearchUsernameOrEmailOrFullname_noMatches() throws EntityException {
        UserNameTermQuery usernameQuery = new UserNameTermQuery("bogus");
        EmailTermQuery emailQuery = new EmailTermQuery("@bogus.com");
        FullNameTermQuery fullnameQuery = new FullNameTermQuery("schmuck");
        MultiTermBooleanQuery disjunctiveQuery = new MultiTermBooleanQuery(new Query[]{usernameQuery, emailQuery, fullnameQuery}, false);
        SearchResult result = queryParser.findUsers((Query)disjunctiveQuery);
        this.assertNoResults(result);
    }

    public void testSearchGroups_allGroups() throws EntityException {
        SearchResult results = queryParser.findGroups((Query)new GroupNameTermQuery(""));
        this.assertResultConsistsOf(results, CROWD_ADMIN_GROUP, CONF_ADMIN_GROUP, CONF_USER_GROUP);
    }

    public void testSearchGroups_oneMatch() throws EntityException {
        SearchResult results = queryParser.findGroups((Query)new GroupNameTermQuery(CROWD_ADMIN_GROUP));
        this.assertResultConsistsOf(results, CROWD_ADMIN_GROUP);
    }

    public void testSearchGroups_manyMatches() throws EntityException {
        SearchResult results = queryParser.findGroups((Query)new GroupNameTermQuery("aDmIn"));
        this.assertResultConsistsOf(results, CROWD_ADMIN_GROUP, CONF_ADMIN_GROUP);
    }

    public void testSearchGroups_noMatches() throws EntityException {
        SearchResult results = queryParser.findGroups((Query)new GroupNameTermQuery("bogus"));
        this.assertNoResults(results);
    }

    protected void assertNoResults(SearchResult result) {
        CrowdEntityQueryParserTest.assertEquals((int)0, (int)result.pager().getCurrentPage().size());
    }

    protected void assertResultContains(SearchResult result, String name) {
        for (Entity entity : result.pager().getCurrentPage()) {
            if (!entity.getName().equals(name)) continue;
            return;
        }
        CrowdEntityQueryParserTest.fail((String)("Entity '" + name + "' not found in results"));
    }

    protected void assertResultContains(SearchResult result, String ... names) {
        for (String username : names) {
            this.assertResultContains(result, username);
        }
    }

    protected void assertResultConsistsOf(SearchResult result, String ... names) {
        this.assertResultContains(result, names);
        if (names.length != result.pager().getCurrentPage().size()) {
            CrowdEntityQueryParserTest.fail((String)("Result contains " + result.pager().getCurrentPage().size() + " objects and not " + names.length));
        }
    }
}

