/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;

public class XFireGzipTest
extends CrowdAcceptanceTestCase {
    private static final int listenerPort = 9085;
    private boolean gzipEncodingOn = false;

    public void setUp() throws Exception {
        super.setUp();
    }

    private AuthenticateApplicationProxy startUpFakeCrowd() {
        AuthenticateApplicationProxy socketListener = new AuthenticateApplicationProxy(9085);
        Thread tSocketListener = new Thread((Runnable)socketListener, "CrowdSocketListener");
        tSocketListener.start();
        return socketListener;
    }

    private SecurityServerClient createCrowdClient(String serverURL) {
        Properties properties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        properties.remove("crowd.server.url");
        properties.setProperty("crowd.server.url", serverURL);
        SoapClientPropertiesImpl clientProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)properties);
        return new SecurityServerClientImpl((SoapClientProperties)clientProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testClientHeaders() {
        this.log("Running testClientHeaders");
        AuthenticateApplicationProxy socketListener = this.startUpFakeCrowd();
        SecurityServerClient crowdClient = this.createCrowdClient("http://localhost:9085/crowd/services/");
        try {
            crowdClient.authenticate();
        }
        catch (InvalidAuthorizationTokenException tokenEx) {
        }
        catch (Exception e) {
            XFireGzipTest.fail((String)"Client can't authenticate to our socket server at port:9085");
            e.printStackTrace();
        }
        List<String> headerList = socketListener.getHeaders();
        StringBuilder concatedHeadersBuffer = new StringBuilder();
        int countOfUserAgentString = 0;
        for (String headerline : headerList) {
            if (headerline.toLowerCase(Locale.ENGLISH).matches("^user-agent:.*")) {
                ++countOfUserAgentString;
            }
            if (headerline.toLowerCase(Locale.ENGLISH).matches("^expect:.*")) continue;
            concatedHeadersBuffer.append(headerline).append("\n");
        }
        String concatedHeaders = concatedHeadersBuffer.toString();
        XFireGzipTest.assertEquals((String)"User-Agent must appear once only in Headers", (int)1, (int)countOfUserAgentString);
        this.addRequestHeader("Accept-Encoding", "gzip");
        this._loginAdminUser();
        this.gotoGeneral();
        this.checkCheckbox("gzip");
        this.submit();
        this.gotoGeneral();
        this.assertServerResponseContains("\nContent-Encoding: gzip\n");
        this.assertCheckboxSelected("gzip");
        Socket clientSocket = null;
        DataOutputStream out = null;
        DataInputStream in = null;
        BufferedReader serverResults = null;
        try {
            String serverResponse;
            URL baseURL = this.getTestContext().getBaseUrl();
            clientSocket = new Socket(baseURL.getHost(), baseURL.getPort());
            out = new DataOutputStream(clientSocket.getOutputStream());
            in = new DataInputStream(clientSocket.getInputStream());
            concatedHeaders = "GET /crowd/services/SecurityServer?wsdl HTTP/1.1\n" + concatedHeaders;
            this.log("Client headers generated (expect header stripped): \n" + concatedHeaders);
            out.writeBytes(concatedHeaders + "\n");
            serverResults = new BufferedReader(new InputStreamReader(in));
            StringBuilder serverResponseBuffer = new StringBuilder();
            while ((serverResponse = serverResults.readLine()) != null) {
                serverResponseBuffer.append(serverResponse).append("\n");
                if (serverResponse.toLowerCase(Locale.ENGLISH).equals("content-encoding: gzip")) {
                    this.gzipEncodingOn = true;
                }
                if (!serverResponse.equals("")) continue;
            }
            this.log("Crowd server reponse to headers: \n" + serverResponseBuffer.toString());
            XFireGzipTest.assertEquals((String)"Content Encoding is GZIP enabled", (boolean)true, (boolean)this.gzipEncodingOn);
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Exception e) {
            XFireGzipTest.fail((String)"Unable to complete XFireGzipTest");
            e.printStackTrace();
            return;
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((Reader)serverResults);
        try {
            clientSocket.close();
            return;
        }
        catch (IOException e) {
            return;
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(serverResults);
            try {
                clientSocket.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AuthenticateApplicationProxy
    implements Runnable {
        protected ServerSocket connection;
        protected Socket clientSocket;
        protected List<String> headers;
        protected final String authAppSOAPResponse = "HTTP/1.1 200 OK\nServer: Apache-Coyote/1.1\nContent-Type: text/xml;charset=UTF-8\nDate: Sat, 24 Jan 1997 10:16:51 GMT\n\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:authenticateApplicationResponse xmlns:ns1=\"urn:SecurityServer\"><ns1:out><name xmlns=\"http://authentication.integration.crowd.atlassian.com\">bamboo-connect</name><token xmlns=\"http://authentication.integration.crowd.atlassian.com\">qkzPvczkQgyYdNwYSzk1jw00</token></ns1:out></ns1:authenticateApplicationResponse></soap:Body></soap:Envelope>";

        public AuthenticateApplicationProxy(int port) {
            try {
                this.clientSocket = new Socket();
                this.connection = new ServerSocket(port);
                this.headers = new ArrayList<String>();
            }
            catch (BindException bindEx) {
                bindEx.printStackTrace();
                Assert.fail((String)"Unable to bind to port.  Check port status for: 9085");
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
                Assert.fail((String)"Can't start ServerSocket");
            }
        }

        public List<String> getHeaders() {
            return this.headers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block23: {
                DataInputStream in = null;
                PrintStream out = null;
                BufferedReader inputReader = null;
                this.clientSocket = this.connection.accept();
                in = new DataInputStream(this.clientSocket.getInputStream());
                out = new PrintStream(this.clientSocket.getOutputStream());
                inputReader = new BufferedReader(new InputStreamReader(in));
                String line = inputReader.readLine();
                out.println("HTTP/1.1 200 OK\nServer: Apache-Coyote/1.1\nContent-Type: text/xml;charset=UTF-8\nDate: Sat, 24 Jan 1997 10:16:51 GMT\n\n<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:authenticateApplicationResponse xmlns:ns1=\"urn:SecurityServer\"><ns1:out><name xmlns=\"http://authentication.integration.crowd.atlassian.com\">bamboo-connect</name><token xmlns=\"http://authentication.integration.crowd.atlassian.com\">qkzPvczkQgyYdNwYSzk1jw00</token></ns1:out></ns1:authenticateApplicationResponse></soap:Body></soap:Envelope>");
                while ((line = inputReader.readLine()) != null) {
                    this.headers.add(line);
                }
                out.close();
                IOUtils.closeQuietly((Reader)inputReader);
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
                try {
                    if (this.clientSocket != null) {
                        this.clientSocket.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                    break block23;
                }
                catch (IOException e) {}
                break block23;
                catch (IOException ioEx) {
                    try {
                        ioEx.printStackTrace();
                        Assert.fail((String)ioEx.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputReader);
                        IOUtils.closeQuietly(out);
                        IOUtils.closeQuietly(in);
                        try {
                            if (this.clientSocket != null) {
                                this.clientSocket.close();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        try {
                            if (this.connection != null) {
                                this.connection.close();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    IOUtils.closeQuietly(inputReader);
                    IOUtils.closeQuietly(out);
                    IOUtils.closeQuietly((InputStream)in);
                    try {
                        if (this.clientSocket != null) {
                            this.clientSocket.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        if (this.connection != null) {
                            this.connection.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }
}

