/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.ArrayAssertions;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.Properties;

public class SecurityServerClientGroupTest
extends CrowdAcceptanceTestCase {
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;
    private Properties sscProperties;
    private static final String GENERAL_GROUP = "general-group";
    private static final String SINGLE_ATTRIBUTE_NAME = "colour";
    private static final String LIST_ATTRIBUTE_NAME = "numbers";
    private static final SOAPAttribute SINGLE_VALUE_ATTRIBUTE = new SOAPAttribute("colour", "green");
    private static final SOAPAttribute LIST_ATTRIBUTE = new SOAPAttribute("numbers", new String[]{"one", "two", "three"});

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("securityserverclienttest.xml");
        this.sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)this.sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testFindGroupByName() throws Exception {
        SOAPGroup soapGroup = this.securityServerClient.findGroupByName(GENERAL_GROUP);
        SecurityServerClientGroupTest.assertEquals((String)GENERAL_GROUP, (String)soapGroup.getName());
        SecurityServerClientGroupTest.assertEquals((int)0, (int)soapGroup.getAttributes().length);
    }

    public void testFindGroupWithAttributesByName() throws Exception {
        SOAPGroup soapGroup = this.securityServerClient.findGroupWithAttributesByName(GENERAL_GROUP);
        SecurityServerClientGroupTest.assertEquals((String)GENERAL_GROUP, (String)soapGroup.getName());
        SecurityServerClientGroupTest.assertEquals((int)0, (int)soapGroup.getAttributes().length);
    }

    public void testFindGroupWithAttributesByNameCustomAttributes() throws Exception {
        this.securityServerClient.addAttributeToGroup(GENERAL_GROUP, SINGLE_VALUE_ATTRIBUTE);
        this.securityServerClient.addAttributeToGroup(GENERAL_GROUP, LIST_ATTRIBUTE);
        SOAPGroup soapGroup = this.securityServerClient.findGroupWithAttributesByName(GENERAL_GROUP);
        SecurityServerClientGroupTest.assertEquals((String)GENERAL_GROUP, (String)soapGroup.getName());
        SecurityServerClientGroupTest.assertEquals((int)2, (int)soapGroup.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapGroup.getAttribute(SINGLE_ATTRIBUTE_NAME).getValues(), "green");
        ArrayAssertions.assertContainsElements(soapGroup.getAttribute(LIST_ATTRIBUTE_NAME).getValues(), "one", "two", "three");
    }

    public void testAddRemoveGroupCustomAttributes() throws Exception {
        SOAPGroup soapGroup = this.securityServerClient.findGroupWithAttributesByName(GENERAL_GROUP);
        SecurityServerClientGroupTest.assertEquals((String)GENERAL_GROUP, (String)soapGroup.getName());
        SecurityServerClientGroupTest.assertEquals((int)0, (int)soapGroup.getAttributes().length);
        this.securityServerClient.addAttributeToGroup(GENERAL_GROUP, SINGLE_VALUE_ATTRIBUTE);
        this.securityServerClient.addAttributeToGroup(GENERAL_GROUP, LIST_ATTRIBUTE);
        soapGroup = this.securityServerClient.findGroupWithAttributesByName(GENERAL_GROUP);
        SecurityServerClientGroupTest.assertEquals((int)2, (int)soapGroup.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapGroup.getAttribute(SINGLE_ATTRIBUTE_NAME).getValues(), "green");
        ArrayAssertions.assertContainsElements(soapGroup.getAttribute(LIST_ATTRIBUTE_NAME).getValues(), "one", "two", "three");
        this.securityServerClient.removeAttributeFromGroup(GENERAL_GROUP, SINGLE_ATTRIBUTE_NAME);
        soapGroup = this.securityServerClient.findGroupWithAttributesByName(GENERAL_GROUP);
        SecurityServerClientGroupTest.assertEquals((int)1, (int)soapGroup.getAttributes().length);
        ArrayAssertions.assertContainsElements(soapGroup.getAttribute(LIST_ATTRIBUTE_NAME).getValues(), "one", "two", "three");
        SecurityServerClientGroupTest.assertNull((Object)soapGroup.getAttribute(SINGLE_ATTRIBUTE_NAME));
    }
}

