/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.model.authentication.AuthenticatedToken;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.rmi.RemoteException;
import java.util.Properties;

public class AuthenticationTokenTest
extends CrowdAcceptanceTestCase {
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;
    private Properties sscProperties;
    private static final String USER_AGENT = "User-Agent";

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("tokenauthenticationtest.xml");
        this.sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)this.sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testAuthenticateSimpleDifferentUsersAuthenticationProducesDifferentTokens() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticateSimpleDifferentUsersAuthenticationProducesDifferentTokens");
        String token1 = this.securityServerClient.authenticatePrincipalSimple("user", "user");
        String token2 = this.securityServerClient.authenticatePrincipalSimple("user2", "user2");
        AuthenticationTokenTest.assertFalse((boolean)token1.equals(token2));
    }

    public void testAuthenticateSimpleSuccessiveAuthenticationProducesSameToken() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticateSimpleSuccessiveAuthenticationProducesSameToken");
        String token1 = this.securityServerClient.authenticatePrincipalSimple("admin", "admin");
        String token2 = this.securityServerClient.authenticatePrincipalSimple("admin", "admin");
        AuthenticationTokenTest.assertEquals((String)token1, (String)token2);
    }

    public void testAuthenticateSimpleDifferentTokenAfterLogout() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticateSimpleDifferentTokenAfterLogout");
        String token1 = this.securityServerClient.authenticatePrincipalSimple("admin", "admin");
        String token2 = this.securityServerClient.authenticatePrincipalSimple("admin", "admin");
        AuthenticationTokenTest.assertEquals((String)token1, (String)token2);
        this.securityServerClient.invalidateToken(token1);
        token1 = this.securityServerClient.authenticatePrincipalSimple("admin", "admin");
        AuthenticationTokenTest.assertFalse((boolean)token1.equals(token2));
    }

    public void testAuthenticatePrincipalDifferentUsersAuthenticationProducesDifferentTokens() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticatePrincipalDifferentUsersAuthenticationProducesDifferentTokens");
        this.userAuthenticationContext.setName("user");
        this.userAuthenticationContext.setCredential(new PasswordCredential("user"));
        String token1 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        this.userAuthenticationContext.setName("user2");
        this.userAuthenticationContext.setCredential(new PasswordCredential("user2"));
        String token2 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        AuthenticationTokenTest.assertFalse((boolean)token1.equals(token2));
    }

    public void testAuthenticatePrincipalSuccessiveAuthenticationProducesSameToken() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticatePrincipalSuccessiveAuthenticationProducesSameToken");
        this.userAuthenticationContext.setName("user");
        this.userAuthenticationContext.setCredential(new PasswordCredential("user"));
        String token1 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        String token2 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        AuthenticationTokenTest.assertEquals((String)token1, (String)token2);
    }

    public void testAuthenticatePrincipalDifferentTokenAfterLogout() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticatePrincipalDifferentTokenAfterLogout");
        this.userAuthenticationContext.setName("user");
        this.userAuthenticationContext.setCredential(new PasswordCredential("user"));
        String token1 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        String token2 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        AuthenticationTokenTest.assertEquals((String)token1, (String)token2);
        this.securityServerClient.invalidateToken(token1);
        token1 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        AuthenticationTokenTest.assertFalse((boolean)token1.equals(token2));
    }

    public void testAuthenticatePrincipalSameUserDifferentConditionProducesDifferentTokens() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticatePrincipalSameUserDifferentConditionProducesDifferentTokens");
        this.userAuthenticationContext.setName("admin");
        this.userAuthenticationContext.setCredential(new PasswordCredential("admin"));
        this.userAuthenticationContext.setValidationFactors(new ValidationFactor[]{new ValidationFactor("remote_address", "127.0.0.1")});
        String token1 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        this.userAuthenticationContext.setValidationFactors(new ValidationFactor[]{new ValidationFactor("remote_address", "192.168.0.1")});
        String token2 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        AuthenticationTokenTest.assertFalse((boolean)token1.equals(token2));
    }

    public void testAuthenticatePrincipalSameUserDifferentUserAgentProducesSameTokens() throws InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ExpiredCredentialException {
        this.log("Running testAuthenticatePrincipalSameUserDifferentUserAgentProducesSameTokens");
        this.userAuthenticationContext.setName("admin");
        this.userAuthenticationContext.setCredential(new PasswordCredential("admin"));
        this.userAuthenticationContext.setValidationFactors(new ValidationFactor[]{new ValidationFactor(USER_AGENT, "IE 8.0"), new ValidationFactor("remote_address", "127.0.0.1")});
        String token1 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        this.userAuthenticationContext.setValidationFactors(new ValidationFactor[]{new ValidationFactor(USER_AGENT, "IE 7.0"), new ValidationFactor("remote_address", "127.0.0.1")});
        String token2 = this.securityServerClient.authenticatePrincipal(this.userAuthenticationContext);
        AuthenticationTokenTest.assertTrue((boolean)token1.equals(token2));
    }

    public void testAuthenticateApplicationSuccessiveAuthenticationSameTokens() throws Exception {
        this.log("Running testAuthenticateApplicationSuccessiveAuthenticationSameTokens");
        this.securityServerClient.authenticate();
        AuthenticatedToken token = this.securityServerClient.getApplicationToken();
        String token1 = token.getToken();
        this.securityServerClient.authenticate();
        token = this.securityServerClient.getApplicationToken();
        String token2 = token.getToken();
        AuthenticationTokenTest.assertEquals((String)token1, (String)token2);
    }

    public void testAuthenticateApplicationDifferntContextDifferentTokens() throws Exception {
        this.log("Running testAuthenticateApplicationDifferntContextDifferentTokens");
        this.securityServerClient.authenticate();
        AuthenticatedToken token = this.securityServerClient.getApplicationToken();
        String token1 = token.getToken();
        this.gotoCurrentApplicationSessions();
        this.assertKeyPresent("session.application.title");
        this.assertLinkPresentWithExactText("integrationtest");
        this.gotoPage("/console/secure/session/removesessionapplication!removeApplicationSession.action?randomHash=" + token1);
        this.securityServerClient.authenticate();
        token = this.securityServerClient.getApplicationToken();
        String token2 = token.getToken();
        AuthenticationTokenTest.assertFalse((boolean)token1.equals(token2));
    }
}

