/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraUserBrowserTest
extends JiraAcceptanceTestCase {
    public void testBrowseUsers() {
        this.adminLoginToJira();
        this.gotoBrowseUsers();
        this.assertTableRowCountEquals("user_browser_table", 5);
        this.assertTextInTable("user_browser_table", new String[]{"admin", "admin@example.com", "Super User", "crowd-administrators\n jira-administrators\n jira-developers\n jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"jira-admin", "jiraadmin@example.com", "Jira Administrator", "jira-administrators\n jira-developers\n jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"test", "test@example.com", "Test User", "jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed User", "jira-users\n"});
    }

    public void testSearchUsersViaEmail() {
        this.adminLoginToJira();
        this.gotoBrowseUsers();
        this.setWorkingForm("jiraform");
        this.setTextField("emailFilter", "admin");
        this.submit();
        this.assertTableRowCountEquals("user_browser_table", 3);
        this.assertTextInTable("user_browser_table", new String[]{"admin", "admin@example.com", "Super User", "crowd-administrators\n jira-administrators\n jira-developers\n jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"jira-admin", "jiraadmin@example.com", "Jira Administrator", "jira-administrators\n jira-developers\n jira-users\n"});
    }

    public void testSearchUsersViaEmailAndGroup() {
        this.adminLoginToJira();
        this.gotoBrowseUsers();
        this.setWorkingForm("jiraform");
        this.setTextField("emailFilter", "admin");
        this.selectOptionByValue("group", "crowd-administrators");
        this.submit();
        this.assertTableRowCountEquals("user_browser_table", 2);
        this.assertTextInTable("user_browser_table", new String[]{"admin", "admin@example.com", "Super User", "crowd-administrators\n jira-administrators\n jira-developers\n jira-users\n"});
    }

    public void testViewUser() {
        this.adminLoginToJira();
        this.gotoBrowseUsers();
        this.clickLink("jira-admin");
        this.assertTextPresent("User: Jira Administrator");
        this.assertTextPresent("jira-admin");
        this.assertTextPresent("Jira Administrator");
        this.assertTextPresent("jiraadmin@example.com");
        this.assertTextPresent("jira-administrators");
        this.assertTextPresent("jira-developers");
        this.assertTextPresent("jira-users");
        this.assertTextNotPresent("crowd-administrators");
        this.assertLinkPresentWithText("View Public Profile");
        this.assertLinkPresentWithText("Edit Properties");
        this.assertLinkPresentWithText("Edit Groups");
        this.assertLinkPresentWithText("View Project Roles");
        this.assertLinkPresentWithText("Edit Details");
        this.assertLinkPresentWithText("Set Password");
        this.assertLinkPresentWithText("Delete User");
    }
}

