/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraGroupBrowserTest
extends JiraAcceptanceTestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBrowseGroups() {
        this.adminLoginToJira();
        this.gotoBrowseGroups();
        this.assertTableRowCountEquals("group_browser_table", 5);
        this.assertTextInTable("group_browser_table", new String[]{"crowd-administrators", "1 (View)"});
        this.assertTextInTable("group_browser_table", new String[]{"jira-administrators", "2 (View)"});
        this.assertTextInTable("group_browser_table", new String[]{"jira-developers", "2 (View)"});
        this.assertTextInTable("group_browser_table", new String[]{"jira-users", "4 (View)"});
    }

    public void testFilterGroups() {
        this.adminLoginToJira();
        this.gotoBrowseGroups();
        this.setTextField("nameFilter", "jira");
        this.clickButtonWithText("Filter");
        this.assertTableRowCountEquals("group_browser_table", 4);
        this.assertTextInTable("group_browser_table", new String[]{"jira-administrators", "2 (View)"});
        this.assertTextInTable("group_browser_table", new String[]{"jira-developers", "2 (View)"});
        this.assertTextInTable("group_browser_table", new String[]{"jira-users", "4 (View)"});
    }

    public void testViewGroup() {
        this.adminLoginToJira();
        this.gotoBrowseGroups();
        this.clickLinkWithText("jira-users");
        this.assertTextPresent("Group: jira-users");
        this.assertTextPresent("Permission Schemes");
        this.assertTextPresent("Notification Schemes");
        this.assertTextPresent("Issue Security Schemes");
        this.assertTextPresent("Saved Filters");
        this.clickLinkWithText("View");
        this.assertSelectedOptionEquals("group", "jira-users");
        this.assertTableRowCountEquals("user_browser_table", 5);
        this.assertTextInTable("user_browser_table", new String[]{"admin", "admin@example.com", "Super User", "crowd-administrators\n jira-administrators\n jira-developers\n jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"jira-admin", "jiraadmin@example.com", "Jira Administrator", "jira-administrators\n jira-developers\n jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"test", "test@example.com", "Test User", "jira-users\n"});
        this.assertTextInTable("user_browser_table", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed User", "jira-users\n"});
    }
}

