/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.user;

import com.atlassian.crowd.acceptance.tests.applications.crowd.user.CrowdUserConsoleAcceptenceTestCase;

public class ChangePasswordTest
extends CrowdUserConsoleAcceptenceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.loadXmlOnSetUp("userconsoletest.xml");
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testViewChangePassword() {
        this.log("Running testViewChangePassword");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextFieldEquals("originalPassword", "");
        this.assertTextFieldEquals("password", "");
        this.assertTextFieldEquals("confirmPassword", "");
    }

    public void testChangePasswordOldPasswordBlank() {
        this.log("Running testChangePasswordOldPasswordBlank");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("password.invalid");
    }

    public void testChangePasswordNewPasswordBlank() {
        this.log("Running testChangePasswordNewPasswordBlank");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "password");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passwordempty.invalid");
    }

    public void testChangePasswordNewPasswordMismatch() {
        this.log("Running testChangePasswordNewPasswordMismatch");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "password");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "somethingelse");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passworddonotmatch.invalid");
    }

    public void testChangePasswordOldPasswordWrong() {
        this.log("Running testChangePasswordOldPasswordWrong");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "wrong");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "new");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("password.invalid");
    }

    public void testChangePasswordSuccess() {
        this.log("Running testChangePasswordSuccess");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "password");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "new");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passwordupdate.message");
        this._logout();
        this.setTextField("j_username", "user");
        this.setTextField("j_password", "password");
        this.submit();
        this.assertKeyPresent("login.failed.label");
        this.setTextField("j_username", "user");
        this.setTextField("j_password", "new");
        this.submit();
        this.assertLinkPresentWithKey("menu.logout.label");
        this.assertKeyPresent("menu.user.console.editprofile.label");
    }

    public void testChangePasswordNoPermissions() {
        this.log("Running testChangePasswordNoPermissions");
        this._loginImmutableUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "password");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "new");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("user.console.password.permission.error");
    }
}

