/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.plugin.saml;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class UpdateSAMLConfigurationTest
extends CrowdAcceptanceTestCase {
    private static final String KEY_PATH = "/plugin-data/crowd-saml-plugin";
    private static final String PUBLIC_KEY = "DSAPublic.key";
    private static final String PRIVATE_KEY = "DSAPrivate.key";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this._loginAdminUser();
        this.restoreBaseSetup();
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    protected File getKeyPath() {
        return new File(this.getCrowdHome() + KEY_PATH);
    }

    protected boolean pluginDataExists() {
        List<String> files;
        File keyPath = this.getKeyPath();
        return keyPath.exists() && keyPath.isDirectory() && keyPath.list() != null && (files = Arrays.asList(keyPath.list())).contains(PUBLIC_KEY) && files.contains(PRIVATE_KEY);
    }

    protected void createPluginData() throws IOException {
        File keyPath = this.getKeyPath();
        File privateKey = new File(this.getKeyPath() + "/" + PRIVATE_KEY);
        File publicKey = new File(this.getKeyPath() + "/" + PUBLIC_KEY);
        String keyString = "some bogus key string";
        FileUtils.forceMkdir((File)keyPath);
        FileUtils.writeByteArrayToFile((File)privateKey, (byte[])keyString.getBytes());
        FileUtils.writeByteArrayToFile((File)publicKey, (byte[])keyString.getBytes());
    }

    protected void nukePluginData() throws IOException {
        File keyPath = this.getKeyPath();
        if (keyPath.exists()) {
            FileUtils.forceDelete((File)keyPath);
        }
    }

    public void testViewSAMLConfig() {
        this.log("Running testViewSAMLConfig");
        this.gotoSAMLConfig();
        this.assertKeyPresent("menu.viewapplication.label");
        this.assertKeyPresent("saml.auth.url.label");
        this.assertKeyPresent("saml.signout.url.label");
        this.assertKeyPresent("saml.password.url.label");
        this.assertKeyPresent("saml.key.label");
        this.assertTextPresent(this.getBaseUrl() + "/console/plugin/secure/saml/samlauth.action");
        this.assertTextPresent(this.getBaseUrl() + "/console/logoff.action");
        this.assertTextPresent(this.getBaseUrl() + "/console/user/viewchangepassword.action");
        this.assertButtonPresent("keygenButton");
        if (this.pluginDataExists()) {
            this.assertButtonPresent("keydelButton");
            this.assertTextPresent(this.getCrowdHome() + KEY_PATH);
        } else {
            this.assertKeyPresent("saml.key.none");
        }
    }

    public void testGenerateKeys() throws IOException {
        this.log("Running testGenerateKeys");
        this.gotoSAMLConfig();
        this.nukePluginData();
        UpdateSAMLConfigurationTest.assertFalse((boolean)this.pluginDataExists());
        this.clickButton("keygenButton");
        UpdateSAMLConfigurationTest.assertTrue((boolean)this.pluginDataExists());
        this.assertKeyPresent("saml.key.gen.success");
        this.assertButtonPresent("keydelButton");
        this.assertTextPresent(this.getCrowdHome() + KEY_PATH);
    }

    public void testOverwriteKeys() throws IOException {
        this.log("Running testOverwriteKeys");
        this.gotoSAMLConfig();
        if (!this.pluginDataExists()) {
            this.createPluginData();
            UpdateSAMLConfigurationTest.assertTrue((boolean)this.pluginDataExists());
        }
        this.clickButton("keygenButton");
        UpdateSAMLConfigurationTest.assertTrue((boolean)this.pluginDataExists());
        this.assertKeyPresent("saml.key.gen.success");
        this.assertButtonPresent("keydelButton");
        this.assertTextPresent(this.getCrowdHome() + KEY_PATH);
    }

    public void testDeleteKeys() {
        this.log("Running testDeleteKeys");
        this.gotoSAMLConfig();
        this.clickButton("keygenButton");
        UpdateSAMLConfigurationTest.assertTrue((boolean)this.pluginDataExists());
        this.assertKeyPresent("saml.key.gen.success");
        this.assertButtonPresent("keydelButton");
        this.assertTextPresent(this.getCrowdHome() + KEY_PATH);
        this.clickButton("keydelButton");
        UpdateSAMLConfigurationTest.assertFalse((boolean)this.pluginDataExists());
        this.assertKeyPresent("saml.key.del.success");
        this.assertButtonNotPresent("keydelButton");
        this.assertKeyPresent("saml.key.none");
    }
}

