/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.plugin;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import junit.framework.AssertionFailedError;

public class ApplicationPluginPermissioningTest
extends CrowdAcceptanceTestCase {
    private String DUAL_USER = "admin";
    private String CROWD_USER = "user";
    private String GOOGLE_USER = "google";

    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("googletest.xml");
        this.ensureNoKeysPresent();
        this._logout();
    }

    protected void ensureNoKeysPresent() {
        this.gotoSAMLConfig();
        try {
            this.assertButtonPresent("keydelButton");
            this.clickButton("keydelButton");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        this.assertButtonNotPresent("keydelButton");
        this.assertKeyPresent("saml.key.none");
    }

    protected void gotoGoogleApplication() {
        this.gotoPage("/console/plugin/secure/saml/samlauth.action");
    }

    protected void gotoCrowdApplication() {
        this.gotoPage("/console");
    }

    protected void assertLoggedInToGoogle() {
        this.gotoGoogleApplication();
        this.assertTextPresent("Invalid SAML authentication request");
    }

    protected void assertLoggedInToCrowd() {
        this.gotoCrowdApplication();
        this.assertKeyPresent("menu.profile.label");
    }

    protected void assertNotLoggedInToCrowd() {
        this.gotoCrowdApplication();
        this.assertAtLoginScreen();
    }

    protected void assertNotLoggedInToGoogle() {
        this.gotoGoogleApplication();
        this.assertAtLoginScreen();
    }

    protected void assertAtLoginScreen() {
        this.assertKeyPresent("login.title");
    }

    protected void login(String user) {
        this.setTextField("j_username", user);
        this.setTextField("j_password", user);
        this.submit();
    }

    public void testCrowdToPluginSSO() {
        this.log("Running testCrowdToPluginSSO");
        this.gotoCrowdApplication();
        this.login(this.DUAL_USER);
        this.assertLoggedInToCrowd();
        this.assertLoggedInToGoogle();
    }

    public void testPluginToCrowdSSO() {
        this.log("Running testPluginToCrowdSSO");
        this.gotoGoogleApplication();
        this.login(this.DUAL_USER);
        this.assertLoggedInToGoogle();
        this.assertLoggedInToCrowd();
    }

    public void testCrowdToPluginSSOFail() {
        this.log("Running testCrowdToPluginSSOFail");
        this.gotoCrowdApplication();
        this.login(this.CROWD_USER);
        this.assertLoggedInToCrowd();
        this.assertNotLoggedInToGoogle();
    }

    public void testPluginToCrowdSSOFail() {
        this.log("Running testPluginToCrowdSSOFail");
        this.gotoGoogleApplication();
        this.login(this.GOOGLE_USER);
        this.assertLoggedInToGoogle();
        this.assertNotLoggedInToCrowd();
    }

    public void testPluginDirectFail() {
        this.log("Running testPluginDirectFail");
        this.gotoGoogleApplication();
        this.login(this.CROWD_USER);
        this.assertAtLoginScreen();
        this.assertNotLoggedInToGoogle();
        this.assertNotLoggedInToCrowd();
    }

    public void testCrowdDirectFail() {
        this.log("Running testCrowdDirectFail");
        this.gotoCrowdApplication();
        this.login(this.GOOGLE_USER);
        this.assertAtLoginScreen();
        this.assertNotLoggedInToGoogle();
        this.assertNotLoggedInToCrowd();
    }
}

