/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.performance;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import net.sourceforge.jwebunit.html.Table;

public class LargeCsvImporterTest
extends CrowdAcceptanceTestCase {
    private String userFileLocation = null;
    private String groupmembershipFileLocation = null;

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this._loginAdminUser();
        this.restoreBaseSetup();
        this.gotoImporters();
        this.clickButton("importcsv");
        this.userFileLocation = this.getCsvFileLocation("users.csv");
        this.groupmembershipFileLocation = this.getCsvFileLocation("groupmembers.csv");
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testCsvImportLargeDatasetOfUsersAndGroupMappings() throws IOException {
        String userNumber;
        int i;
        this.log("Running testCsvImportLargeDatasetOfUsersAndGroupMappings");
        this.userFileLocation = this.getCsvFileLocation("1000users.csv");
        this.groupmembershipFileLocation = this.getCsvFileLocation("100groups5000members.csv");
        this.setTextField("delimiter", ",");
        this.setTextField("users", this.userFileLocation);
        this.setTextField("groupMemberships", this.groupmembershipFileLocation);
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.text");
        this.selectOptionByValue("user.0", "user.username");
        this.selectOptionByValue("user.1", "user.firstname");
        this.selectOptionByValue("user.2", "user.lastname");
        this.selectOptionByValue("user.3", "user.emailaddress");
        this.selectOptionByValue("user.4", "user.password");
        this.selectOptionByValue("group.0", "group.username");
        this.selectOptionByValue("group.1", "group.name");
        this.submit();
        this.assertKeyPresent("dataimport.csv.configuration.confirmation.text");
        this.assertKeyPresent("dataimport.csv.configuration.passwordencrypted.label", EasyList.build((Object)this.getMessage("yes.label")));
        this.assertKeyPresent("dataimport.csv.configuration.userfile.label", EasyList.build((Object)this.userFileLocation));
        this.assertKeyPresent("dataimport.csv.configuration.groupmembershipfile.label", EasyList.build((Object)this.groupmembershipFileLocation));
        Object[][] userMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User Name", this.getMessage("user.username")}, {"First Name", this.getMessage("user.firstname")}, {"Last Name", this.getMessage("user.lastname")}, {"Email Address", this.getMessage("user.emailaddress")}, {"Password", this.getMessage("user.password")}};
        this.assertTableEquals("usermappings", new Table(userMappingsTableData));
        Object[][] groupMappingsTableData = new String[][]{{this.getMessage("dataimport.csv.configuration.headerrow"), this.getMessage("dataimport.csv.configuration.mapping")}, {"User", this.getMessage("group.username")}, {"Group", this.getMessage("group.name")}};
        this.assertTableEquals("groupmappings", new Table(groupMappingsTableData));
        this.submit();
        this.assertKeyPresent("dataimport.csv.result.text");
        this.assertTextInElement("users-imported", "1000");
        this.assertTextInElement("groups-imported", "100");
        this.assertTextInElement("memberships-imported", "5000");
        this.log("Finished importing 1000 users, 100 groups and 5000 memberships");
        this.gotoBrowsePrincipals();
        this.assertUserInTable("user-details", "admin", "Super User", "admin@example.com");
        DecimalFormat df = new DecimalFormat("000");
        for (i = 0; i < 99; ++i) {
            userNumber = df.format(i);
            this.assertUserInTable("user-details", "user" + userNumber, "First" + userNumber + " Last" + userNumber, "user" + userNumber + "@example.com");
        }
        this.gotoBrowsePrincipals(1000);
        this.assertUserInTable("user-details", "user999", "First999 Last999", "user999@example.com");
        this.gotoBrowseGroups();
        this.assertTextInTable("group-details", new String[]{"crowd-administrators", "true"});
        for (i = 0; i < 99; ++i) {
            String groupNumber = df.format(i);
            this.assertTextInTable("group-details", new String[]{"group" + groupNumber, "true"});
        }
        this.gotoBrowseGroups(100);
        this.assertTextInTable("group-details", new String[]{"group099", "true"});
        this.gotoViewGroup("group004", "Test Internal Directory ");
        this.clickLink("view-group-users");
        for (i = 0; i < 50; ++i) {
            userNumber = df.format(i);
            this.assertTextInTable("view-group-users", new String[]{"user" + userNumber, "user" + userNumber + "@example.com", "true"});
        }
    }

    private String getCsvFileLocation(String fileName) throws IOException {
        File fileLocation = AcceptanceTestHelper.getResource("com/atlassian/crowd/acceptance/tests/applications/crowd/" + fileName);
        if (!fileLocation.exists()) {
            URL resource = ClassLoaderUtils.getResource((String)("com/atlassian/crowd/acceptance/tests/applications/crowd/" + fileName), ((Object)((Object)this)).getClass());
            fileLocation = new File(resource.getFile());
        }
        if (!fileLocation.exists()) {
            throw new IllegalArgumentException("File: " + fileName + " does not exist in the resources directory, under the 'com/atlassian/crowd/acceptance/tests/console/' directory");
        }
        return fileLocation.getCanonicalPath();
    }
}

