/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.legacy;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.directory.ApacheDS;
import com.atlassian.security.password.DefaultPasswordEncoder;
import java.io.File;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public abstract class BaseLegacyXmlRestoreTest
extends CrowdAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("legacy/" + this.getLegacyXmlFileName());
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public abstract String getLegacyXmlFileName();

    public void testConsoleAdminLoginSuccessfull() {
        this.log("Running testConsoleAdminLoginSuccessfull");
        this.gotoPage("/console/logoff.action");
        this.gotoPage("/console/login.action");
        this.setTextField("j_username", "admin");
        this.setTextField("j_password", "admin");
        this.submit();
        this.assertKeyPresent("console.welcome");
        this.assertTextPresent("Log Out");
    }

    public void testBrowseDirectories() {
        this.log("Running testBrowseDirectories");
        this.gotoBrowseDirectories();
        this.assertTextPresent("ApacheDS");
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.assertTextPresent("Crowd Internal");
        this.assertTextPresent("Crowd Internal Directory");
    }

    public void testViewInternalDirectory() {
        this.log("Running testViewInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Internal");
        this.assertKeyPresent("menu.viewdirectory.label", Arrays.asList("Crowd Internal"));
        this.assertTextFieldEquals("name", "Crowd Internal");
        this.assertTextFieldEquals("directoryDescription", "");
        this.assertCheckboxSelected("active");
        this.clickLink("internal-configuration");
        this.assertTextFieldEquals("passwordRegex", "");
        this.assertTextFieldEquals("passwordMaxAttempts", "0");
        this.assertTextFieldEquals("passwordMaxChangeTime", "0");
        this.assertTextFieldEquals("passwordHistoryCount", "0");
        this.assertTextFieldEquals("passwordRegex", "");
        this.clickLink("internal-permissions");
        this.assertCheckboxSelected("permissionPrincipalAdd");
        this.assertCheckboxSelected("permissionPrincipalModify");
        this.assertCheckboxSelected("permissionPrincipalRemove");
        this.assertCheckboxSelected("permissionGroupAdd");
        this.assertCheckboxSelected("permissionGroupModify");
        this.assertCheckboxSelected("permissionGroupRemove");
        this.assertCheckboxSelected("permissionRoleAdd");
        this.assertCheckboxSelected("permissionRoleModify");
        this.assertCheckboxSelected("permissionRoleRemove");
        this.gotoBrowseDirectories();
        this.viewDirectoryAsCustom("Crowd Internal");
        this.assertTextPresent("com.atlassian.crowd.directory.InternalDirectory");
    }

    private void viewDirectoryAsCustom(String directory) {
        int id = this.extractIdParameter(this.tester.getElementAttributeByXPath("//a[contains(text(), '" + directory + "')]", "href"));
        this.gotoPage("/console/secure/directory/viewcustom.action?ID=" + id);
    }

    private int extractIdParameter(String url) {
        String[] queryParams;
        for (String queryParam : queryParams = url.substring(url.indexOf(63) + 1).split("&")) {
            if (!queryParam.startsWith("ID=")) continue;
            return Integer.valueOf(queryParam.substring(3));
        }
        BaseLegacyXmlRestoreTest.fail((String)"Should have found an ID in the query params");
        return 0;
    }

    public void testViewLDAPDirectory() {
        this.log("Running testViewLDAPDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("ApacheDS");
        this.assertKeyPresent("menu.viewdirectory.label", Arrays.asList("ApacheDS"));
        this.assertTextFieldEquals("name", "ApacheDS");
        this.assertTextFieldEquals("directoryDescription", "");
        this.assertCheckboxSelected("active");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertCheckboxNotSelected("secure");
        this.assertCheckboxNotSelected("referral");
        this.assertCheckboxNotSelected("useNestedGroups");
        this.assertCheckboxNotSelected("useUserMembershipAttribute");
        this.assertCheckboxNotSelected("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertTextFieldEquals("ldapPassword", "");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "");
        this.assertTextFieldEquals("groupObjectClass", "groupOfUniqueNames");
        this.assertTextFieldEquals("groupObjectFilter", "(objectclass=groupOfUniqueNames)");
        this.assertTextFieldEquals("groupNameAttr", "cn");
        this.assertTextFieldEquals("groupDescriptionAttr", "description");
        this.assertTextFieldEquals("groupMemberAttr", "uniqueMember");
        this.assertCheckboxNotSelected("rolesDisabled");
        this.assertTextFieldEquals("roleDNaddition", "");
        this.assertTextFieldEquals("roleObjectClass", "groupOfUniqueNames");
        this.assertTextFieldEquals("roleObjectFilter", "(objectclass=groupOfUniqueNames)");
        this.assertTextFieldEquals("roleNameAttr", "cn");
        this.assertTextFieldEquals("roleDescriptionAttr", "description");
        this.assertTextFieldEquals("roleMemberAttr", "uniqueMember");
        this.assertTextFieldEquals("userDNaddition", "");
        this.assertTextFieldEquals("userObjectClass", "inetorgperson");
        this.assertTextFieldEquals("userObjectFilter", "(objectclass=inetorgperson)");
        this.assertTextFieldEquals("userNameAttr", "cn");
        this.assertTextFieldEquals("userNameRdnAttr", "cn");
        this.assertTextFieldEquals("userFirstnameAttr", "givenname");
        this.assertTextFieldEquals("userLastnameAttr", "sn");
        this.assertTextFieldEquals("userDisplayNameAttr", "displayName");
        this.assertTextFieldEquals("userMailAttr", "mail");
        this.assertTextFieldEquals("userGroupMemberAttr", "memberOf");
        this.assertTextFieldEquals("userPasswordAttr", "userpassword");
        this.clickLink("connector-permissions");
        this.assertCheckboxSelected("permissionPrincipalAdd");
        this.assertCheckboxSelected("permissionPrincipalModify");
        this.assertCheckboxSelected("permissionPrincipalRemove");
        this.assertCheckboxSelected("permissionGroupAdd");
        this.assertCheckboxSelected("permissionGroupModify");
        this.assertCheckboxSelected("permissionGroupRemove");
        this.assertCheckboxSelected("permissionRoleAdd");
        this.assertCheckboxSelected("permissionRoleModify");
        this.assertCheckboxSelected("permissionRoleRemove");
        this.gotoBrowseDirectories();
        this.viewDirectoryAsCustom("ApacheDS");
        this.assertTextPresent("com.atlassian.crowd.directory.ApacheDS");
    }

    public void testBrowseApplications() {
        this.log("Running testBrowseApplications");
        this.gotoBrowseApplications();
        this.assertTextInTable("application-table", new String[]{"crowd", "Crowd Console", "View"});
        this.assertTextInTable("application-table", new String[]{"demo", "Crowd Demo Application", "View"});
    }

    public void testViewCrowdApplication() {
        this.log("Running testViewCrowdApplication");
        this.gotoBrowseApplications();
        this.clickLinkWithExactText("crowd");
        this.assertTextInElement("name", "crowd");
        this.assertTextFieldEquals("applicationDescription", "Crowd Console");
        this.assertCheckboxSelected("active");
        this.clickLink("application-directories");
        this.assertTextInTable("directoriesTable", new String[]{"Crowd Internal"});
        this.setWorkingForm("directoriesForm");
        this.assertSelectedOptionEquals("directory1-allowAll", "False");
        this.clickLink("application-groups");
        this.assertTextInElement("groupsTable", "Crowd Internal - crowd-administrators");
        this.assertTextPresent("crowd-administrators");
        this.clickLink("application-permissions");
        this.assertKeyPresent("application.permission.text");
        this.setWorkingForm("permissionForm");
        String[] selectOptions = this.getDialog().getSelectOptionValues("directory-select");
        this.selectOptionByValue("directory-select", selectOptions[0]);
        this.setWorkingForm("permissionForm");
        this.assertCheckboxSelected("CREATE_GROUP");
        this.assertCheckboxSelected("CREATE_USER");
        this.assertCheckboxSelected("CREATE_ROLE");
        this.assertCheckboxSelected("UPDATE_GROUP");
        this.assertCheckboxSelected("UPDATE_USER");
        this.assertCheckboxSelected("UPDATE_ROLE");
        this.assertCheckboxSelected("DELETE_GROUP");
        this.assertCheckboxSelected("DELETE_USER");
        this.assertCheckboxSelected("DELETE_ROLE");
        this.clickLink("application-remoteaddress");
        this.assertTextInTable("addressesTable", new String[]{"localhost"});
        this.assertTextInTable("addressesTable", new String[]{"127.0.0.1"});
        this.clickLink("application-options");
        this.setWorkingForm("applicationOptions");
        this.assertCheckboxNotSelected("lowerCaseOutput");
    }

    public void testViewDemoApplication() {
        this.log("Running testViewDemoApplication");
        this.gotoBrowseApplications();
        this.clickLinkWithExactText("demo");
        this.assertTextInElement("name", "demo");
        this.assertTextFieldEquals("applicationDescription", "Crowd Demo Application");
        this.assertCheckboxSelected("active");
        this.clickLink("application-directories");
        this.assertTextInTable("directoriesTable", new String[]{"Crowd Internal"});
        this.setWorkingForm("directoriesForm");
        this.assertSelectedOptionEquals("directory1-allowAll", "True");
        this.clickLink("application-groups");
        this.assertTextInElement("groupsTable", "Crowd Internal - crowd-administrators");
        this.clickLink("application-permissions");
        this.assertKeyPresent("application.permission.text");
        this.setWorkingForm("permissionForm");
        String[] selectOptions = this.getDialog().getSelectOptionValues("directory-select");
        this.selectOptionByValue("directory-select", selectOptions[0]);
        this.setWorkingForm("permissionForm");
        this.assertCheckboxSelected("CREATE_GROUP");
        this.assertCheckboxSelected("CREATE_USER");
        this.assertCheckboxSelected("CREATE_ROLE");
        this.assertCheckboxSelected("UPDATE_GROUP");
        this.assertCheckboxSelected("UPDATE_USER");
        this.assertCheckboxSelected("UPDATE_ROLE");
        this.assertCheckboxSelected("DELETE_GROUP");
        this.assertCheckboxSelected("DELETE_USER");
        this.assertCheckboxSelected("DELETE_ROLE");
        this.clickLink("application-remoteaddress");
        this.assertTextInTable("addressesTable", new String[]{"localhost"});
        this.assertTextInTable("addressesTable", new String[]{"127.0.0.1"});
        this.clickLink("application-options");
        this.setWorkingForm("applicationOptions");
        this.assertCheckboxNotSelected("lowerCaseOutput");
    }

    public void testBrowseUsers() {
        this.log("Running testBrowseUsers");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Crowd Internal");
        this.submit();
        this.assertUserInTable("user-details", "admin", "Super Admin", "admin@example.com");
        this.assertUserInTable("user-details", "user", "Super User", "user@example.com");
    }

    public void testViewUser() {
        this.log("Running testViewUser");
        this.gotoViewPrincipal("admin", "Crowd Internal");
        this.assertTextFieldEquals("email", "admin@example.com");
        this.assertCheckboxSelected("active");
        this.assertTextFieldEquals("firstname", "Super");
        this.assertTextFieldEquals("lastname", "Admin");
        this.clickLink("user-attributes-tab");
        this.assertTextInTable("attributesTable", new String[]{"passwordLastChanged"});
        this.assertTextInTable("attributesTable", new String[]{"invalidPasswordAttempts"});
        this.assertTextInTable("attributesTable", new String[]{"lastAuthenticated"});
        this.assertTextInTable("attributesTable", new String[]{"requiresPasswordChange"});
        this.setWorkingForm("attributesForm");
        this.assertTextFieldEquals("invalidPasswordAttempts1", "0");
        this.assertTextFieldEquals("requiresPasswordChange1", "false");
        this.clickLink("user-groups-tab");
        this.assertTextInTable("groupsTable", new String[]{"crowd-administrators"});
    }

    public void testBrowseGroups() {
        this.log("Running testBrowseGroups");
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", "Crowd Internal");
        this.submit();
        this.assertTextInTable("group-details", new String[]{"crowd-administrators", "true", "View"});
    }

    public void testViewGroup() {
        this.log("Running testViewGroup");
        this.gotoViewGroup("crowd-administrators", "Crowd Internal");
        this.setWorkingForm("groupForm");
        this.assertTextFieldEquals("description", "");
        this.assertCheckboxSelected("active");
        this.clickLink("view-group-users");
        this.assertTextInTable("view-group-users", new String[]{"admin", "admin@example.com", "true"});
    }

    public void testGeneralOptions() {
        this.log("Running testGeneralOptions");
        this.gotoGeneral();
        this.setWorkingForm("general");
        this.assertTextFieldEquals("title", "Atlassian Crowd");
        this.assertTextFieldEquals("domain", "");
        this.assertCheckboxNotSelected("secureCookie");
        this.assertCheckboxSelected("cachingEnabled");
        this.assertCheckboxSelected("gzip");
    }

    public void testLicenseScreen() {
        this.log("Running testLicenseScreen");
        this.gotoLicensing();
        this.assertTextPresent("ARVO-O3PS-SFJ8-ZDP9");
    }

    public void testMailConfiguration() {
        this.log("Running testMailConfiguration");
        this.gotoMailServer();
        this.setWorkingForm("mailserver");
        this.assertTextFieldEquals("notificationEmail", "admin@example.com");
        this.assertTextFieldEquals("from", "admin@example.com");
        this.assertTextFieldEquals("prefix", "[Atlassian Crowd - Atlassian Crowd]");
        this.assertRadioOptionSelected("jndiMailActive", "false");
        this.assertTextFieldEquals("host", "localhost");
        this.assertTextFieldEquals("port", "25");
        this.assertTextFieldEquals("username", "");
        this.assertTextFieldEquals("password", "");
    }

    public void testMailTemplate() {
        this.log("Running testMailTemplate");
        this.gotoMailTemplate();
        this.setWorkingForm("mailtemplate");
        this.assertTextFieldEquals("forgottenPasswordTemplate", "Hello $firstname $lastname, Your password has been reset by a $deploymenttitle administrator at $date. Your new password is: $password $deploymenttitle Administrator");
    }

    public void testSessionConfig() {
        this.log("Running testSessionConfig");
        this.gotoSessionConfig();
        this.setWorkingForm("session");
        this.assertTextFieldEquals("sessionTime", "30");
        this.assertRadioOptionSelected("storageType", "database");
    }

    public void testDisplayNameUpdated() throws Exception {
        this.log("Running testDisplayNameUpdated");
        String displayName = this.backupAndRetrieveXPath("//user[name='blank']/displayName/text()");
        BaseLegacyXmlRestoreTest.assertEquals((String)"DisplayName has not been updated from empty to username", (String)"blank", (String)displayName);
    }

    public void testLastNameUpdated() throws Exception {
        this.log("Running testLastNameUpdated");
        String lastName = this.backupAndRetrieveXPath("//user[name='blank']/lastName/text()");
        BaseLegacyXmlRestoreTest.assertEquals((String)"Last name has not been updated from empty to username", (String)"blank", (String)lastName);
    }

    public void testPasswordUpgraded() throws Exception {
        this.log("Running testPasswordUpgraded");
        String encPass = this.backupAndRetrieveXPath("//user[name='admin']/credential/text()");
        BaseLegacyXmlRestoreTest.assertTrue((String)"SHA1 encoded password has not been updated", (boolean)DefaultPasswordEncoder.getDefaultInstance().canDecodePassword(encPass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String backupAndRetrieveXPath(String expr) throws Exception {
        String backupFileName = "BaseLegacyXmlRestoreTest_TempBackupFile.xml";
        String backupFilePath = this.getCrowdHome() + File.separator + "backups" + File.separator + backupFileName;
        this.gotoBackup();
        this.setTextField("exportFileName", backupFileName);
        this.submit();
        this.assertTextPresent("Crowd has successfully backed up to " + backupFilePath);
        File fileLocation = new File(backupFilePath);
        try {
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            Document doc = builder.parse(fileLocation);
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            String string = xpath.evaluate(expr, doc);
            return string;
        }
        finally {
            if (!fileLocation.delete()) {
                fileLocation.deleteOnExit();
            }
        }
    }
}

