/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import javax.mail.internet.MimeMessage;

public class ResetPrincipalPasswordTest
extends CrowdAcceptanceTestCase {
    private GreenMail greenMail;
    private static final String SMTP_FROM_ADDRESS = "crowd-tests@example.com";
    private static final String SMTP_SUBJECT_PREFIX = "[crowd-tests]";
    private static final String EMAIL_TEMPLATE_JAPANESE = "\u3053\u3093\u306b\u3061\u306f";
    private static final String EMAIL_TEMPLATE_GREEK = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03c2";
    private static final String USERNAME = "TestUser";
    private static final String DIRECTORY_NAME = "Test Internal Directory";
    private String smtpPort;

    public void setUp() throws Exception {
        super.setUp();
        this.smtpPort = System.getProperty("crowd.test.smtp.port", "3025");
        ServerSetup smtpServer = new ServerSetup(Integer.parseInt(this.smtpPort), null, "smtp");
        this.greenMail = new GreenMail(smtpServer);
        this.greenMail.start();
        this._loginAdminUser();
        this.gotoAddPrincipal();
    }

    public void tearDown() throws Exception {
        if (null != this.greenMail) {
            this.greenMail.stop();
        }
        super.tearDown();
    }

    public void testResetEmailWithNonAsciiBody() throws Exception {
        this.log("Running testResetEmailWithNonAsciiBody");
        this.gotoAddPrincipal();
        this.setTextField("email", SMTP_FROM_ADDRESS);
        this.setTextField("name", USERNAME);
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", DIRECTORY_NAME);
        this.submit();
        this.gotoMailServer();
        this.setTextField("notificationEmail", SMTP_FROM_ADDRESS);
        this.setTextField("from", SMTP_FROM_ADDRESS);
        this.setTextField("prefix", SMTP_SUBJECT_PREFIX);
        this.setTextField("host", "localhost");
        this.setTextField("port", this.smtpPort);
        this.submit();
        this.gotoMailTemplate();
        this.setTextField("forgottenPasswordTemplate", "\u3053\u3093\u306b\u3061\u306f\u03b1\u03b2\u03b3\u03b4\u03b5\u03c2");
        this.submit();
        this.gotoViewPrincipal(USERNAME, DIRECTORY_NAME);
        this.clickLink("reset-password-principal");
        this.submit();
        ResetPrincipalPasswordTest.assertTrue((String)"Error in retrieving reset password email", (boolean)this.greenMail.waitForIncomingEmail(5000L, 1));
        MimeMessage[] messages = this.greenMail.getReceivedMessages();
        ResetPrincipalPasswordTest.assertEquals((String)"Incorrect number of emails present", (int)1, (int)messages.length);
        ResetPrincipalPasswordTest.assertEquals((String)"Reset password email contains incorrect content", (String)"\u3053\u3093\u306b\u3061\u306f\u03b1\u03b2\u03b3\u03b4\u03b5\u03c2", (String)messages[0].getContent().toString());
    }
}

