/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ModifyApplicationPermissionsTest
extends CrowdAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        this._loginAdminUser();
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testAddingAndRemovingApplicationPermissions() {
        this.log("Running testAddingAndRemovingApplicationPermissions");
        this.gotoPage("/console/secure/application/browse.action");
        this.clickLinkWithText("crowd-openid-server");
        this.clickLinkWithText("Permissions");
        this.assertKeyPresent("application.permission.text");
        this.setWorkingForm("permissionForm");
        String[] selectOptions = this.getDialog().getSelectOptionValues("directory-select");
        this.selectOptionByValue("directory-select", selectOptions[0]);
        this.setWorkingForm("permissionForm");
        this.checkCheckbox("CREATE_GROUP");
        this.uncheckCheckbox("CREATE_USER");
        this.checkCheckbox("UPDATE_GROUP");
        this.uncheckCheckbox("UPDATE_USER");
        this.checkCheckbox("DELETE_GROUP");
        this.uncheckCheckbox("DELETE_USER");
        this.submit("update-permissions");
        this.setWorkingForm("permissionForm");
        this.assertCheckboxSelected("CREATE_GROUP");
        this.assertCheckboxNotSelected("CREATE_USER");
        this.assertCheckboxSelected("UPDATE_GROUP");
        this.assertCheckboxNotSelected("UPDATE_USER");
        this.assertCheckboxSelected("DELETE_GROUP");
        this.assertCheckboxNotSelected("DELETE_USER");
    }

    public void testSetGlobalPermissionReflectedInApplicationPermissions() {
        this.log("Running testSetGlobalPermissionReflectedInApplicationPermissions");
        this.gotoPage("/console/secure/directory/browse.action");
        this.clickLinkWithText("View");
        this.clickLinkWithText("Permissions");
        this.setWorkingForm("permissionForm");
        this.uncheckCheckbox("permissionGroupAdd");
        this.uncheckCheckbox("permissionPrincipalAdd");
        this.uncheckCheckbox("permissionGroupModify");
        this.uncheckCheckbox("permissionPrincipalModify");
        this.uncheckCheckbox("permissionGroupRemove");
        this.uncheckCheckbox("permissionPrincipalRemove");
        this.submit("update-permissions");
        this.gotoPage("/console/secure/application/browse.action");
        this.clickLinkWithText("crowd-openid-server");
        this.clickLinkWithText("Permissions");
        this.setWorkingForm("permissionForm");
        String[] selectOptions = this.getDialog().getSelectOptionValues("directory-select");
        this.selectOptionByValue("directory-select", selectOptions[0]);
        String setglobally = this.getMessage("application.permission.disabledglobally");
        String permissionType = this.getMessage("permission.addgroup.label");
        this.assertTextPresent(permissionType + " (" + setglobally + ")");
        permissionType = this.getMessage("permission.addprincipal.label");
        this.assertTextPresent(permissionType + " (" + setglobally + ")");
        permissionType = this.getMessage("permission.modifygroup.label");
        this.assertTextPresent(permissionType + " (" + setglobally + ")");
        permissionType = this.getMessage("permission.modifyprincipal.label");
        this.assertTextPresent(permissionType + " (" + setglobally + ")");
        permissionType = this.getMessage("permission.removegroup.label");
        this.assertTextPresent(permissionType + " (" + setglobally + ")");
        permissionType = this.getMessage("permission.removeprincipal.label");
        this.assertTextPresent(permissionType + " (" + setglobally + ")");
    }

    public void testPermissionsCancelButton() {
        this.log("Running testPermissionsCancelButton");
        this.gotoPage("/console/secure/application/browse.action");
        this.clickLinkWithKey("crowdid.application.name");
        this.clickLinkWithKey("menu.permissions.label");
        this.assertKeyPresent("application.permission.text");
        this.selectOption("directory-select", this.getText("application.permission.test.directory"));
        this.assertCheckboxSelected("UPDATE_GROUP_ATTRIBUTE");
        this.uncheckCheckbox("UPDATE_GROUP_ATTRIBUTE");
        this.clickButtonWithText(this.getText("cancel.label"));
        this.assertKeyPresent("application.permission.text");
        this.assertKeyPresent("application.permission.directory.none");
        this.selectOption("directory-select", this.getText("application.permission.test.directory"));
        this.assertCheckboxSelected("UPDATE_GROUP_ATTRIBUTE");
    }
}

