/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class DirectoryPermissionRoleTest
extends CrowdAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("directorypermissionroletest.xml");
    }

    public void testUnableToModifyRole() {
        this.gotoViewRole("tester-role", "Test Internal Directory");
        this.setWorkingForm("roleForm");
        this.setTextField("description", "A new description");
        this.submit();
        this.assertTextPresent("Directory does not allow role modifications");
    }

    public void testUnableToModifyRoleMembers() {
        this.gotoViewRole("tester-role", "Test Internal Directory");
        this.clickLink("view-role-principals");
        this.clickLinkWithExactText("testuser");
        this.clickLink("removerole-tester-role-Test Internal Directory");
        this.assertTextPresent("Directory does not allow role modifications");
        this.assertTextInTable("rolesTable", new String[]{"tester-role", "Remove"});
    }

    public void testUnableToDeleteRole() {
        this.gotoViewRole("tester-role", "Test Internal Directory");
        this.clickLink("remove-role");
        this.submit();
        this.assertTextPresent("Directory does not allow role removal");
    }

    public void testUnableToAddRole() {
        this.gotoAddRole();
        this.setTextField("name", "tester-role-to-add");
        this.setTextField("description", "Crowd Acceptance Test Role");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertTextPresent("Directory does not allow adding of roles");
    }

    public void testAbleToUpdateGroup() {
        this.gotoViewGroup("tester-group", "Test Internal Directory");
        this.setWorkingForm("groupForm");
        this.setTextField("description", "Crowd Acceptance Test Group Updated");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.setWorkingForm("groupForm");
        this.assertTextFieldEquals("description", "Crowd Acceptance Test Group Updated");
        this.assertTextNotPresent("Directory does not allow group modifications");
    }

    public void testAbleToRemoveGroup() {
        this.gotoViewGroup("tester-group", "Test Internal Directory");
        this.clickLink("remove-group");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotPresent("tester-group");
    }

    public void testAbleToAddGroup() {
        this.gotoAddGroup();
        this.setTextField("name", "test-group");
        this.setTextField("description", "Crowd Test Group");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("test-group");
    }
}

