/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import org.apache.commons.lang.StringUtils;

public class DirectoryImporterTest
extends CrowdAcceptanceTestCase {
    private static final String SOURCE_DIRECTORY_NAME = "Test Internal Directory";
    private static final String TARGET_DIRECTORY_NAME = "Blank Internal Directory";
    private static final String DIFFERENT_ENCRYPTION_DIRECTORY_NAME = "Third Directory";
    private static final String SOURCE_DIRECTORY_NAME_WITH_NESTED_GROUPS = "nested group";
    private static final String DESTINATION_DIRECTORY_NAME_WITH_NESTED_GROUPS = "another blank directory with nested group";
    private static final String DESTINATION_DIRECTORY_NAME_WITHOUT_NESTED_GROUPS = "another blank directory without nested group";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("directoryimportertest.xml");
        this._loginAdminUser();
        this.gotoImporters();
        this.clickButton("importdirectory");
    }

    public void tearDown() throws Exception {
        this.restoreBaseSetup();
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testBothDirectoriesCannotBeTheSame() {
        this.log("Running testBothDirectoriesCannotBeTheSame");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", TARGET_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.sourcetargetsame.error");
    }

    public void testUserEncryptionMustBeTheSame() {
        this.log("Running testUserEncryptionMustBeTheSame");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", TARGET_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", DIFFERENT_ENCRYPTION_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.same.encryption.error");
    }

    public void testPerformDirectoryMigration() {
        this.log("Running testPerformDirectoryMigration");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.source.confirmation.directory.text", EasyList.build((Object)SOURCE_DIRECTORY_NAME));
        this.assertKeyPresent("dataimport.directory.target.confirmation.directory.text", EasyList.build((Object)TARGET_DIRECTORY_NAME));
        this.assertKeyPresent("dataimport.directory.overwrite.confirmation.directory.text", EasyList.build((Object)StringUtils.capitalize((String)Boolean.FALSE.toString())));
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        this.assertTextInElement("users-imported", Integer.toString(2));
        this.assertTextInElement("groups-imported", Integer.toString(2));
        this.assertTextInElement("memberships-imported", Integer.toString(3));
    }

    public void testPerformDirectoryImportWithNestedGroups() {
        this.log("Running testPerformDirectoryImportWithNestedGroups");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME_WITH_NESTED_GROUPS);
        this.selectOption("targetDirectoryID", DESTINATION_DIRECTORY_NAME_WITH_NESTED_GROUPS);
        this.submit();
        this.assertKeyPresent("dataimport.importnestedgroup.text");
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        this.assertTextInElement("users-imported", Integer.toString(1));
        this.assertTextInElement("groups-imported", Integer.toString(2));
        this.assertTextInElement("memberships-imported", Integer.toString(2));
    }

    public void testPerformDirectoryImportWithoutNestedGroups() {
        this.log("Running testPerformDirectoryImportWithoutNestedGroups");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME_WITH_NESTED_GROUPS);
        this.selectOption("targetDirectoryID", DESTINATION_DIRECTORY_NAME_WITHOUT_NESTED_GROUPS);
        this.submit();
        this.assertKeyPresent("dataimport.importnestedgroup.not.text");
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
        this.assertTextInElement("users-imported", Integer.toString(1));
        this.assertTextInElement("groups-imported", Integer.toString(2));
        this.assertTextInElement("memberships-imported", Integer.toString(1));
    }
}

