/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;

public class BrowsePrincipalsTest
extends CrowdAcceptanceTestCase {
    private static final long MAX_WAIT_TIME_MS = 10000L;

    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("searchdirectories.xml");
        this.synchroniseDirectory();
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Apache DS", 10000L);
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Apache DS 1.5.4", 10000L);
    }

    public void testBrowseInternalDirectoryUsers() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertUserInTable("user-details", "admin", "Justin Koke", "admin@test.org");
        this.assertUserInTable("user-details", "justin", "Justin Koke", "justin@test.org");
    }

    public void testBrowseApacheDSUsers() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "jdoe", "John Doe", "jdoe@testingarea.org");
        this.assertUserInTable("user-details", "ldapusera", "LDAP User A", "ldapusera@testingarea.org");
        this.assertUserInTable("user-details", "ldapuserb", "LDAP User B", "ldapuserb@testingarea.org");
        this.assertUserInTable("user-details", "ldapuserc", "LDAP User C", "ldapuserc@testingarea.org");
        this.assertUserInTable("user-details", "ldapuserd", "LDAP User D", "ldapuserd@testingarea.org");
        this.assertUserInTable("user-details", "ldapusere", "LDAP User E", "ldapusere@testingarea.org");
        this.assertUserInTable("user-details", "ldapuserf", "LDAP User F", "ldapuserf@testingarea.org");
        this.assertUserInTable("user-details", "ldapuserg", "LDAP User G", "ldapuserg@testingarea.org");
        this.assertUserInTable("user-details", "ldapuserh", "LDAP User H", "ldapuserh@testingarea.org");
    }

    public void testSearchForSpecificUsersByUsernameInApacheDS154() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.setTextField("search", "aeinstein");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserNotInTable("user-details", "mplanck", "Max Planck", "mplanck@example.com");
    }

    public void testSearchForSpecificUsersByEmailInApacheDS154() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Apache DS 1.5.4");
        this.setTextField("search", "@example.com");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "aeinstein", "Albert Einstein", "aeinstein@example.com");
        this.assertUserInTable("user-details", "mplanck", "Max Planck", "mplanck@example.com");
        this.assertUserInTable("user-details", "nbohr", "Neils Bohr", "nbohr@example.com");
        this.assertUserInTable("user-details", "mborn", "Max Born", "mborn@example.com");
        this.assertUserInTable("user-details", "wpauli", "Wolfgang Pauli", "wpauli@example.com");
        this.assertUserInTable("user-details", "mcurie", "Marie Curie", "mcurie@example.com");
    }

    public void testSearchForSpecificUsersByUsernameInInternalDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("search", "admin");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "admin", "Justin Koke", "admin@test.org");
        this.assertUserNotInTable("user-details", "justin", "Justin Koke", "justin@test.org");
    }

    public void testSearchForSpecificUsersByEmailInInternalDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.setTextField("search", "admin@test.org");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "admin", "Justin Koke", "admin@test.org");
        this.assertUserNotInTable("user-details", "justin", "Justin Koke", "justin@test.org");
    }

    public void testSearchForInactiveUsersWithNoSearchText() {
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Inactive");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "inactive", "Inactive User", "inactive@example.com");
        this.assertUserNotInTable("user-details", "user", "Test User", "user@example.com");
        this.assertUserNotInTable("user-details", "admin", "Shihab Hamid", "shihab@gmai.com");
    }

    public void testSearchForActiveUsersWithSearchText() {
        this.restoreCrowdFromXML("authenticationtest.xml");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", "Test Internal Directory");
        this.selectOption("active", "Active");
        this.setTextField("search", "user");
        this.submit("submit-search");
        this.assertUserInTable("user-details", "user", "Test User", "user@example.com");
        this.assertUserNotInTable("user-details", "inactive", "Inactive User", "inactive@example.com");
        this.assertUserNotInTable("user-details", "admin", "Shihab Hamid", "shihab@gmai.com");
    }

    public void tearDown() throws Exception {
        this.restoreBaseSetup();
        super.tearDown();
    }
}

