/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class AliasTest
extends CrowdAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("aliastest.xml");
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testUpdateAliases() {
        this.gotoViewPrincipal("admin", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "bob");
        this.assertTextFieldEquals("alias-appid-4", "");
        this.setTextField("alias-appid-3", "robert");
        this.setTextField("alias-appid-4", "john");
        this.submit();
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "robert");
        this.assertTextFieldEquals("alias-appid-4", "john");
    }

    public void testClearAliases() {
        this.gotoViewPrincipal("admin", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.clickLink("remove-alias-appid-3");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "");
        this.assertTextFieldEquals("alias-appid-4", "");
    }

    public void testClearAliasFails() {
        this.gotoViewPrincipal("admin", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.setTextField("alias-appid-3", "test");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.gotoViewPrincipal("test", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.clickLink("remove-alias-appid-3");
        this.assertWarningPresent();
        this.assertTextPresent("Alias [test] already in use for application [demo] by user [admin]");
    }

    public void testSearchApplicationUsersWithAliases() {
        this.gotoViewApplication("demo");
        this.clickLink("application-users");
        this.setWorkingForm("searchusers");
        this.submit();
        this.assertUserInTable("user-details", "admin", "admin man", "shamid@atlassian.com", "bob");
        this.assertUserInTable("user-details", "test", "test test", "testuser@atlassian.com", "test12");
    }

    public void testUpdateAliasWithPrimaryUsername() {
        this.gotoViewPrincipal("admin", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "bob");
        this.assertTextFieldEquals("alias-appid-4", "");
        this.setTextField("alias-appid-3", "admin");
        this.submit();
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertWarningPresent();
        this.assertTextFieldEquals("alias-appid-3", "bob");
        this.assertTextFieldEquals("alias-appid-4", "");
    }

    public void testUpdateAliasWithExistingUsername() {
        this.gotoViewPrincipal("test", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "test12");
        this.assertTextFieldEquals("alias-appid-4", "test34");
        this.setTextField("alias-appid-4", "admin");
        this.submit();
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertWarningPresent();
        this.assertTextFieldEquals("alias-appid-3", "test12");
        this.assertTextFieldEquals("alias-appid-4", "test34");
    }

    public void testUpdateAliasWithPrimaryUsernameAndValidUsername() {
        this.gotoViewPrincipal("admin", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "bob");
        this.assertTextFieldEquals("alias-appid-4", "");
        this.setTextField("alias-appid-3", "admin");
        this.setTextField("alias-appid-4", "john");
        this.submit();
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertWarningPresent();
        this.assertTextFieldEquals("alias-appid-3", "bob");
        this.assertTextFieldEquals("alias-appid-4", "john");
    }

    public void testUpdateAliasWithExistingUsernameAndValidUsername() {
        this.gotoViewPrincipal("test", "Atlassian Crowd");
        this.clickLink("user-applications-tab");
        this.setWorkingForm("applicationsForm");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertTextFieldEquals("alias-appid-3", "test12");
        this.assertTextFieldEquals("alias-appid-4", "test34");
        this.setTextField("alias-appid-3", "john");
        this.setTextField("alias-appid-4", "admin");
        this.submit();
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Application aliasing disabled"});
        this.assertWarningPresent();
        this.assertTextFieldEquals("alias-appid-3", "john");
        this.assertTextFieldEquals("alias-appid-4", "test34");
    }
}

